/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.adf.reader.handle;

import com.aliyun.dataworks.migrationx.reader.adf.AdfReader;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.adf.reader.handle.AdfFileHandle;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class AdfOpenApiHandle
extends AdfFileHandle {
    public AdfOpenApiHandle(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public void init() {
        Map properties = this.scheduleDataSource.getProperties();
        String token = (String)properties.get("token");
        String factory = (String)properties.get("factory");
        String subscriptionId = (String)properties.get("subscriptionId");
        String resourceGroupName = (String)properties.get("resourceGroupName");
        String exportFilePath = this.taskContext.getSourceFilePackage();
        File exportFile = new File(exportFilePath);
        if (!exportFile.exists()) {
            try {
                FileUtils.forceMkdir((File)exportFile);
            }
            catch (IOException e) {
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.BWM_READER_EXPORT_ERROR);
            }
        }
        this.adfReader = new AdfReader(token, subscriptionId, resourceGroupName, factory, exportFile);
    }

    @Override
    public WorkflowProjectPackage read() throws Exception {
        File export = this.adfReader.export();
        Map properties = this.scheduleDataSource.getProperties();
        properties.put("source-file-path", export.getPath());
        this.taskContext.setSourceFilePackage(export.getPath());
        super.init();
        return super.read();
    }
}

