/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.utils;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCenter {
    private static final Logger log = LoggerFactory.getLogger(IdCenter.class);
    private static volatile SnowFlakeGenerator snowFlakeGenerator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Long dataCenterId, Long nodeId) {
        if (snowFlakeGenerator != null) return;
        Class<IdCenter> clazz = IdCenter.class;
        synchronized (IdCenter.class) {
            if (null != snowFlakeGenerator) return;
            snowFlakeGenerator = new SnowFlakeGenerator(dataCenterId, nodeId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Long singleSnowFlakeId() {
        return snowFlakeGenerator.nextId();
    }

    public static List<Long> batchSnowFlakeId(int capacity) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < capacity; ++i) {
            ids.add(snowFlakeGenerator.nextId());
        }
        return ids;
    }

    public static void main(String[] args) {
        SnowFlakeGenerator snowFlakeGenerator = new SnowFlakeGenerator(0L, 0L);
        int range = 10;
        for (int i = 0; i < range; ++i) {
            log.info(String.valueOf(snowFlakeGenerator.nextId()));
        }
    }

    public static class SnowFlakeGenerator {
        private final long dataCenterId;
        private final long nodeId;
        private long sequence = 0L;
        private long lastTime = -1L;
        private static final long START_STAMP = 781401600000L;
        private static final long SEQUENCE_BIT = 12L;
        private static final long MAX_SEQUENCE = 4095L;
        private static final long NODE_BIT = 5L;
        private static final long MAX_NODE_NUM = 31L;
        private static final long DATA_CENTER_BIT = 5L;
        private static final long MAX_DATA_CENTER_NUM = 31L;
        private static final long NODE_OFFSET = 12L;
        private static final long DATA_CENTER_OFFSET = 17L;
        private static final long TIMESTAMP_OFFSET = 22L;

        public SnowFlakeGenerator(long dataCenterId, long nodeId) {
            if (dataCenterId > 31L || dataCenterId < 0L) {
                throw new IllegalArgumentException("dataCenterId can't be greater than MAX_DATA_CENTER_NUM or less than 0");
            }
            if (nodeId > 31L || nodeId < 0L) {
                throw new IllegalArgumentException("nodeId can't be greater than MAX_NODE_NUM or less than 0");
            }
            this.dataCenterId = dataCenterId;
            this.nodeId = nodeId;
        }

        public synchronized long nextId() {
            long currentTime = this.currentTime();
            if (currentTime < this.lastTime) {
                throw new RuntimeException("Clock moved backwards.  Refusing to generate id. lastTimeStamp:" + this.lastTime + " currentTime: " + currentTime);
            }
            if (currentTime == this.lastTime) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    currentTime = this.nextMilliSecond();
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTime = currentTime;
            return currentTime - 781401600000L << 22 | this.dataCenterId << 17 | this.nodeId << 12 | this.sequence;
        }

        private long nextMilliSecond() {
            long millTime = this.currentTime();
            while (millTime <= this.lastTime) {
                millTime = this.currentTime();
            }
            return millTime;
        }

        private long currentTime() {
            return System.currentTimeMillis();
        }
    }
}

