/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.exception;

import com.aliyun.migration.api.exception.BwmErrorCode;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class BwmException
extends RuntimeException {
    private String code;
    private Object[] params;

    private BwmException() {
    }

    private BwmException(String code, Object ... params) {
        super(BwmException.getMessage(code, params));
        this.code = code;
        this.params = params;
    }

    private BwmException(Throwable throwable, @NonNull String code, Object ... params) {
        super(BwmException.getMessage(code, params), throwable);
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        this.code = code;
        this.params = params;
    }

    private BwmException(@NonNull String code, @NonNull String message) {
        super(message);
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.code = code;
    }

    public static BwmException asBwmException(@NonNull BwmErrorCode errorCode) {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        return new BwmException(errorCode.getCode(), errorCode.getDescription());
    }

    public static BwmException asBwmException(@NonNull BwmErrorCode errorCode, String errorMessage) {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        return new BwmException(errorCode.getCode(), errorCode.getDescription() + "---" + errorMessage);
    }

    public static BwmException asBwmException(@NonNull BwmErrorCode errorCode, String errorMessage, @NonNull Throwable throwable) {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        if (throwable instanceof BwmException) {
            return (BwmException)throwable;
        }
        return new BwmException(throwable, errorCode.getCode(), errorCode.getDescription() + "---" + errorMessage);
    }

    public static BwmException asBwmExceptionWithParam(@NonNull BwmErrorCode errorCode, Object ... params) {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        return new BwmException(errorCode.getCode(), params);
    }

    private static String getMessage(String code, Object ... params) {
        if (Objects.isNull(code)) {
            return "";
        }
        String paramStr = StringUtils.join((Object[])params, (String)",");
        if (Objects.isNull(paramStr)) {
            return code;
        }
        return code.concat(":").concat(paramStr);
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }
}

