/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.context;

import com.aliyun.tea.NameInMap;
import com.aliyun.tea.TeaModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticOp
extends TeaModel {
    private static final Logger log = LoggerFactory.getLogger(StatisticOp.class);
    private List<StatisticIterm> statisticIterms = new ArrayList<StatisticIterm>();
    public Map<String, Integer> nodeTypeStatistic = new HashMap<String, Integer>();
    public Map<String, Map<String, Integer>> nodeTypeStatisticEachWorkflow = new HashMap<String, Map<String, Integer>>();
    @NameInMap(value="workflowTotalStatisticOp")
    public StatisticIterm workflowTotalStatisticOp = new StatisticIterm(StatisticType.WORKFLOW, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowSuccessStatisticOp")
    public StatisticIterm workflowSuccessStatisticOp = new StatisticIterm(StatisticType.WORKFLOW, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowFailureStatisticOp")
    public StatisticIterm workflowFailureStatisticOp = new StatisticIterm(StatisticType.WORKFLOW, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowNodeTotalStatisticOp")
    public StatisticIterm workflowNodeTotalStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowNodeSuccessStatisticOp")
    public StatisticIterm workflowNodeSuccessStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowNodeFailureStatisticOp")
    public StatisticIterm workflowNodeFailureStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowNodeSkipStatisticOp")
    public StatisticIterm workflowNodeSkipStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.SKIP);
    @NameInMap(value="workflowNodeTempStatisticOp")
    public StatisticIterm workflowNodeTempStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.TEMP);
    @NameInMap(value="workflowNodeResult")
    public StatisticIterm workflowNodeResultStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.RESULT);
    @NameInMap(value="workflowResourceTotalStatisticOp")
    public StatisticIterm workflowResourceTotalStatisticOp = new StatisticIterm(StatisticType.RESOURCE, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowResourceSuccessStatisticOp")
    public StatisticIterm workflowResourceSuccessStatisticOp = new StatisticIterm(StatisticType.RESOURCE, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowResourceFailureStatisticOp")
    public StatisticIterm workflowResourceFailureStatisticOp = new StatisticIterm(StatisticType.RESOURCE, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowFunTotalStatisticOp")
    public StatisticIterm workflowFunTotalStatisticOp = new StatisticIterm(StatisticType.FUNCTION, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowFunSuccessStatisticOp")
    public StatisticIterm workflowFunSuccessStatisticOp = new StatisticIterm(StatisticType.FUNCTION, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowFunFailureStatisticOp")
    public StatisticIterm workflowFunFailureStatisticOp = new StatisticIterm(StatisticType.FUNCTION, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowCompTotalStatisticOp")
    public StatisticIterm workflowCompTotalStatisticOp = new StatisticIterm(StatisticType.COMPONENT, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowCompSuccessStatisticOp")
    public StatisticIterm workflowCompSuccessStatisticOp = new StatisticIterm(StatisticType.COMPONENT, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowCompFailureStatisticOp")
    public StatisticIterm workflowCompFailureStatisticOp = new StatisticIterm(StatisticType.COMPONENT, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowTableTotalStatisticOp")
    public StatisticIterm workflowTableTotalStatisticOp = new StatisticIterm(StatisticType.TABLE, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowTableSuccessStatisticOp")
    public StatisticIterm workflowTableSuccessStatisticOp = new StatisticIterm(StatisticType.TABLE, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowTableFailureStatisticOp")
    public StatisticIterm workflowTableFailureStatisticOp = new StatisticIterm(StatisticType.TABLE, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowDataSocTotalStatisticOp")
    public StatisticIterm workflowDataSocTotalStatisticOp = new StatisticIterm(StatisticType.DATASOURCE, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowDataSocSuccessStatisticOp")
    public StatisticIterm workflowDataSocSuccessStatisticOp = new StatisticIterm(StatisticType.DATASOURCE, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowDataSocFailureStatisticOp")
    public StatisticIterm workflowDataSocFailureStatisticOp = new StatisticIterm(StatisticType.DATASOURCE, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowAdHocTotalStatisticOp")
    public StatisticIterm workflowAdHocTotalStatisticOp = new StatisticIterm(StatisticType.AD_HOC_QUERY, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowAdHocSuccessStatisticOp")
    public StatisticIterm workflowAdHocSuccessStatisticOp = new StatisticIterm(StatisticType.AD_HOC_QUERY, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowAdHocFailureStatisticOp")
    public StatisticIterm workflowAdHocFailureStatisticOp = new StatisticIterm(StatisticType.AD_HOC_QUERY, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowDataSvcTotalStatisticOp")
    public StatisticIterm workflowDataSvcTotalStatisticOp = new StatisticIterm(StatisticType.DATA_SERVICE, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowDataSvcSuccessStatisticOp")
    public StatisticIterm workflowDataSvcSuccessStatisticOp = new StatisticIterm(StatisticType.DATA_SERVICE, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowDataSvcFailureStatisticOp")
    public StatisticIterm workflowDataSvcFailureStatisticOp = new StatisticIterm(StatisticType.DATA_SERVICE, StatisticItemEnum.FAILURE);
    @NameInMap(value="workflowDQCTotalStatisticOp")
    public StatisticIterm workflowDQCTotalStatisticOp = new StatisticIterm(StatisticType.DQC, StatisticItemEnum.TOTAL);
    @NameInMap(value="workflowDQCSuccessStatisticOp")
    public StatisticIterm workflowDQCSuccessStatisticOp = new StatisticIterm(StatisticType.DQC, StatisticItemEnum.SUCCESS);
    @NameInMap(value="workflowDQCFailureStatisticOp")
    public StatisticIterm workflowDQCFailureStatisticOp = new StatisticIterm(StatisticType.DQC, StatisticItemEnum.FAILURE);
    private List<NodeMapping> nodeMappings = new ArrayList<NodeMapping>();

    public StatisticIterm getWorkflowTotalStatisticOp() {
        return this.workflowTotalStatisticOp;
    }

    public StatisticIterm getWorkflowSuccessStatisticOp() {
        return this.workflowSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowFailureStatisticOp() {
        return this.workflowFailureStatisticOp;
    }

    public StatisticIterm getWorkflowNodeTotalStatisticOp() {
        return this.workflowNodeTotalStatisticOp;
    }

    public StatisticIterm getWorkflowNodeSuccessStatisticOp() {
        return this.workflowNodeSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowNodeFailureStatisticOp() {
        return this.workflowNodeFailureStatisticOp;
    }

    public StatisticIterm getWorkflowResourceTotalStatisticOp() {
        return this.workflowResourceTotalStatisticOp;
    }

    public StatisticIterm getWorkflowResourceSuccessStatisticOp() {
        return this.workflowResourceSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowResourceFailureStatisticOp() {
        return this.workflowResourceFailureStatisticOp;
    }

    public StatisticIterm getWorkflowFunTotalStatisticOp() {
        return this.workflowFunTotalStatisticOp;
    }

    public StatisticIterm getWorkflowFunSuccessStatisticOp() {
        return this.workflowFunSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowFunFailureStatisticOp() {
        return this.workflowFunFailureStatisticOp;
    }

    public StatisticIterm getWorkflowCompTotalStatisticOp() {
        return this.workflowCompTotalStatisticOp;
    }

    public StatisticIterm getWorkflowCompSuccessStatisticOp() {
        return this.workflowCompSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowCompFailureStatisticOp() {
        return this.workflowCompFailureStatisticOp;
    }

    public StatisticIterm getWorkflowTableTotalStatisticOp() {
        return this.workflowTableTotalStatisticOp;
    }

    public StatisticIterm getWorkflowTableSuccessStatisticOp() {
        return this.workflowTableSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowTableFailureStatisticOp() {
        return this.workflowTableFailureStatisticOp;
    }

    public StatisticIterm getWorkflowDataSocTotalStatisticOp() {
        return this.workflowDataSocTotalStatisticOp;
    }

    public StatisticIterm getWorkflowDataSocSuccessStatisticOp() {
        return this.workflowDataSocSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowDataSocFailureStatisticOp() {
        return this.workflowDataSocFailureStatisticOp;
    }

    public StatisticIterm getWorkflowAdHocTotalStatisticOp() {
        return this.workflowAdHocTotalStatisticOp;
    }

    public StatisticIterm getWorkflowAdHocSuccessStatisticOp() {
        return this.workflowAdHocSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowAdHocFailureStatisticOp() {
        return this.workflowAdHocFailureStatisticOp;
    }

    public StatisticIterm getWorkflowDataSvcTotalStatisticOp() {
        return this.workflowDataSvcTotalStatisticOp;
    }

    public StatisticIterm getWorkflowDataSvcSuccessStatisticOp() {
        return this.workflowDataSvcSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowDataSvcFailureStatisticOp() {
        return this.workflowDataSvcFailureStatisticOp;
    }

    public StatisticIterm getWorkflowDQCTotalStatisticOp() {
        return this.workflowDQCTotalStatisticOp;
    }

    public StatisticIterm getWorkflowDQCSuccessStatisticOp() {
        return this.workflowDQCSuccessStatisticOp;
    }

    public StatisticIterm getWorkflowDQCFailureStatisticOp() {
        return this.workflowDQCFailureStatisticOp;
    }

    public void addNodeMap(NodeMapping nodeMapping) {
        if (CollectionUtils.isEmpty(this.nodeMappings)) {
            this.nodeMappings = new ArrayList<NodeMapping>();
        }
        this.nodeMappings.add(nodeMapping);
    }

    public void add(StatisticIterm statisticIterm) {
        this.statisticIterms.add(statisticIterm);
    }

    public List<StatisticIterm> collectStatisticIterms() {
        this.statisticIterms.add(this.workflowTotalStatisticOp);
        this.statisticIterms.add(this.workflowSuccessStatisticOp);
        this.statisticIterms.add(this.workflowFailureStatisticOp);
        this.statisticIterms.add(this.workflowNodeTotalStatisticOp);
        this.statisticIterms.add(this.workflowNodeSuccessStatisticOp);
        this.statisticIterms.add(this.workflowNodeFailureStatisticOp);
        this.statisticIterms.add(this.workflowNodeResultStatisticOp);
        this.statisticIterms.add(this.workflowResourceTotalStatisticOp);
        this.statisticIterms.add(this.workflowResourceSuccessStatisticOp);
        this.statisticIterms.add(this.workflowResourceFailureStatisticOp);
        this.statisticIterms.add(this.workflowFunTotalStatisticOp);
        this.statisticIterms.add(this.workflowFunSuccessStatisticOp);
        this.statisticIterms.add(this.workflowFunFailureStatisticOp);
        return this.statisticIterms;
    }

    public void cleanAll() {
        this.statisticIterms.clear();
        this.nodeMappings.clear();
        this.workflowTotalStatisticOp = new StatisticIterm(StatisticType.WORKFLOW, StatisticItemEnum.TOTAL);
        this.workflowSuccessStatisticOp = new StatisticIterm(StatisticType.WORKFLOW, StatisticItemEnum.SUCCESS);
        this.workflowFailureStatisticOp = new StatisticIterm(StatisticType.WORKFLOW, StatisticItemEnum.FAILURE);
        this.workflowNodeTotalStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.TOTAL);
        this.workflowNodeSuccessStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.SUCCESS);
        this.workflowNodeFailureStatisticOp = new StatisticIterm(StatisticType.WORKFLOWNODE, StatisticItemEnum.FAILURE);
        this.workflowResourceTotalStatisticOp = new StatisticIterm(StatisticType.RESOURCE, StatisticItemEnum.TOTAL);
        this.workflowResourceSuccessStatisticOp = new StatisticIterm(StatisticType.RESOURCE, StatisticItemEnum.SUCCESS);
        this.workflowResourceFailureStatisticOp = new StatisticIterm(StatisticType.RESOURCE, StatisticItemEnum.FAILURE);
        this.workflowFunTotalStatisticOp = new StatisticIterm(StatisticType.FUNCTION, StatisticItemEnum.TOTAL);
        this.workflowFunSuccessStatisticOp = new StatisticIterm(StatisticType.FUNCTION, StatisticItemEnum.SUCCESS);
        this.workflowFunFailureStatisticOp = new StatisticIterm(StatisticType.FUNCTION, StatisticItemEnum.FAILURE);
    }

    public void addWorkflowTotal(int total) {
        this.workflowTotalStatisticOp.increment(total);
    }

    public void addWorkflowSuccess(String iterm) {
        this.workflowSuccessStatisticOp.incrementOne(iterm);
    }

    public void addWorkflowFailure(String iterm, String msg) {
        this.workflowFailureStatisticOp.incrementFailedOne(iterm, msg);
    }

    public void addWorkflowNodeTotal(int total) {
        this.workflowNodeTotalStatisticOp.increment(total);
    }

    public void addWorkflowNodeSuccess(String iterm) {
        this.workflowNodeSuccessStatisticOp.incrementOne(iterm);
    }

    public void addWorkflowNodeFailure(String iterm, String msg) {
        this.workflowNodeFailureStatisticOp.incrementFailedOne(iterm, msg);
    }

    public void addWorkflowNodeSkip(String iterm, Integer ct) {
        this.workflowNodeFailureStatisticOp.incrementDetailOne(iterm);
    }

    public void addWorkflowNodeTemp(String iterm, Integer ct) {
        this.workflowNodeFailureStatisticOp.incrementDetailOne(iterm);
    }

    public void addWorkflowNodeResult(String iterm, Integer ct) {
        this.workflowNodeResultStatisticOp.incrementDetailOne(iterm);
    }

    public void addWorkflowResourceTotal(int total) {
        this.workflowResourceTotalStatisticOp.increment(total);
    }

    public void addWorkflowResourceSuccess(String iterm) {
        this.workflowResourceSuccessStatisticOp.incrementOne(iterm);
    }

    public void addWorkflowResourceFailure(String iterm, String msg) {
        this.workflowResourceFailureStatisticOp.incrementFailedOne(iterm, msg);
    }

    public void addWorkflowFunTotal(int size) {
        this.workflowFunTotalStatisticOp.increment(size);
    }

    public void addWorkflowFunSuccess(String iterm) {
        this.workflowFunSuccessStatisticOp.incrementOne(iterm);
    }

    public void addWorkflowFunFailure(String iterm, String msg) {
        this.workflowFunFailureStatisticOp.incrementFailedOne(iterm, msg);
    }

    public void print() {
        StringBuilder overviewSb = new StringBuilder();
        int width = 20;
        overviewSb.append("\n");
        overviewSb.append("=============================================start print statistic overview=======================================================\n");
        List<StatisticIterm> statisticItermsRes = this.collectStatisticIterms();
        overviewSb.append("Statistic Overview:");
        overviewSb.append("\n");
        overviewSb.append(this.leftAlign("statisticType", width));
        overviewSb.append(this.leftAlign("statisticItem", width));
        overviewSb.append(this.leftAlign("statisticItemValue", width));
        overviewSb.append("\n");
        for (StatisticIterm statisticIterm : statisticItermsRes) {
            overviewSb.append(this.leftAlign((Object)statisticIterm.getStatisticType(), width));
            overviewSb.append(this.leftAlign((Object)statisticIterm.getStatisticItem(), width));
            overviewSb.append(this.leftAlign(statisticIterm.getAtomicInteger(), width));
            overviewSb.append("\n");
        }
        overviewSb.append("=============================================end print statistic overview========================================================");
        log.info(overviewSb.toString());
        log.info("Statistic Failure Detail:");
        log.info("\tStatistic-Failure-Detail-Workflow:");
        this.printFailed(this.workflowFailureStatisticOp);
        log.info("\tStatistic-Failure-Detail-WorkflowNode:");
        this.printFailed(this.workflowNodeFailureStatisticOp);
        log.info("\tStatistic-Failure-Detail-WorkflowFile:");
        this.printFailed(this.workflowResourceFailureStatisticOp);
        log.info("\tStatistic-Failure-Detail-WorkflowFunc:");
        this.printFailed(this.workflowFunFailureStatisticOp);
    }

    private void printFailed(StatisticIterm statisticIterm) {
        List<Pair<String, String>> itermAndMsgs = statisticIterm.getItermAndMsgs();
        if (itermAndMsgs.isEmpty() || statisticIterm.getStatisticItem() != StatisticItemEnum.FAILURE) {
            return;
        }
        log.info("statisticType:{},statisticName:{},statisticValue:{}", new Object[]{statisticIterm.getStatisticType(), statisticIterm.getStatisticItem(), statisticIterm.getAtomicInteger()});
        for (Pair<String, String> pair : itermAndMsgs) {
            log.info("errorIterm:{},errorMsg:{}", pair.getKey(), pair.getValue());
        }
    }

    private String leftAlign(Object obj, int width) {
        String str = "";
        if (Objects.nonNull(obj)) {
            str = obj.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        while (sb.length() < width) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static StatisticOpBuilder builder() {
        return new StatisticOpBuilder();
    }

    public List<StatisticIterm> getStatisticIterms() {
        return this.statisticIterms;
    }

    public Map<String, Integer> getNodeTypeStatistic() {
        return this.nodeTypeStatistic;
    }

    public Map<String, Map<String, Integer>> getNodeTypeStatisticEachWorkflow() {
        return this.nodeTypeStatisticEachWorkflow;
    }

    public StatisticIterm getWorkflowNodeSkipStatisticOp() {
        return this.workflowNodeSkipStatisticOp;
    }

    public StatisticIterm getWorkflowNodeTempStatisticOp() {
        return this.workflowNodeTempStatisticOp;
    }

    public StatisticIterm getWorkflowNodeResultStatisticOp() {
        return this.workflowNodeResultStatisticOp;
    }

    public List<NodeMapping> getNodeMappings() {
        return this.nodeMappings;
    }

    public void setStatisticIterms(List<StatisticIterm> statisticIterms) {
        this.statisticIterms = statisticIterms;
    }

    public void setNodeTypeStatistic(Map<String, Integer> nodeTypeStatistic) {
        this.nodeTypeStatistic = nodeTypeStatistic;
    }

    public void setNodeTypeStatisticEachWorkflow(Map<String, Map<String, Integer>> nodeTypeStatisticEachWorkflow) {
        this.nodeTypeStatisticEachWorkflow = nodeTypeStatisticEachWorkflow;
    }

    public void setWorkflowTotalStatisticOp(StatisticIterm workflowTotalStatisticOp) {
        this.workflowTotalStatisticOp = workflowTotalStatisticOp;
    }

    public void setWorkflowSuccessStatisticOp(StatisticIterm workflowSuccessStatisticOp) {
        this.workflowSuccessStatisticOp = workflowSuccessStatisticOp;
    }

    public void setWorkflowFailureStatisticOp(StatisticIterm workflowFailureStatisticOp) {
        this.workflowFailureStatisticOp = workflowFailureStatisticOp;
    }

    public void setWorkflowNodeTotalStatisticOp(StatisticIterm workflowNodeTotalStatisticOp) {
        this.workflowNodeTotalStatisticOp = workflowNodeTotalStatisticOp;
    }

    public void setWorkflowNodeSuccessStatisticOp(StatisticIterm workflowNodeSuccessStatisticOp) {
        this.workflowNodeSuccessStatisticOp = workflowNodeSuccessStatisticOp;
    }

    public void setWorkflowNodeFailureStatisticOp(StatisticIterm workflowNodeFailureStatisticOp) {
        this.workflowNodeFailureStatisticOp = workflowNodeFailureStatisticOp;
    }

    public void setWorkflowNodeSkipStatisticOp(StatisticIterm workflowNodeSkipStatisticOp) {
        this.workflowNodeSkipStatisticOp = workflowNodeSkipStatisticOp;
    }

    public void setWorkflowNodeTempStatisticOp(StatisticIterm workflowNodeTempStatisticOp) {
        this.workflowNodeTempStatisticOp = workflowNodeTempStatisticOp;
    }

    public void setWorkflowNodeResultStatisticOp(StatisticIterm workflowNodeResultStatisticOp) {
        this.workflowNodeResultStatisticOp = workflowNodeResultStatisticOp;
    }

    public void setWorkflowResourceTotalStatisticOp(StatisticIterm workflowResourceTotalStatisticOp) {
        this.workflowResourceTotalStatisticOp = workflowResourceTotalStatisticOp;
    }

    public void setWorkflowResourceSuccessStatisticOp(StatisticIterm workflowResourceSuccessStatisticOp) {
        this.workflowResourceSuccessStatisticOp = workflowResourceSuccessStatisticOp;
    }

    public void setWorkflowResourceFailureStatisticOp(StatisticIterm workflowResourceFailureStatisticOp) {
        this.workflowResourceFailureStatisticOp = workflowResourceFailureStatisticOp;
    }

    public void setWorkflowFunTotalStatisticOp(StatisticIterm workflowFunTotalStatisticOp) {
        this.workflowFunTotalStatisticOp = workflowFunTotalStatisticOp;
    }

    public void setWorkflowFunSuccessStatisticOp(StatisticIterm workflowFunSuccessStatisticOp) {
        this.workflowFunSuccessStatisticOp = workflowFunSuccessStatisticOp;
    }

    public void setWorkflowFunFailureStatisticOp(StatisticIterm workflowFunFailureStatisticOp) {
        this.workflowFunFailureStatisticOp = workflowFunFailureStatisticOp;
    }

    public void setWorkflowCompTotalStatisticOp(StatisticIterm workflowCompTotalStatisticOp) {
        this.workflowCompTotalStatisticOp = workflowCompTotalStatisticOp;
    }

    public void setWorkflowCompSuccessStatisticOp(StatisticIterm workflowCompSuccessStatisticOp) {
        this.workflowCompSuccessStatisticOp = workflowCompSuccessStatisticOp;
    }

    public void setWorkflowCompFailureStatisticOp(StatisticIterm workflowCompFailureStatisticOp) {
        this.workflowCompFailureStatisticOp = workflowCompFailureStatisticOp;
    }

    public void setWorkflowTableTotalStatisticOp(StatisticIterm workflowTableTotalStatisticOp) {
        this.workflowTableTotalStatisticOp = workflowTableTotalStatisticOp;
    }

    public void setWorkflowTableSuccessStatisticOp(StatisticIterm workflowTableSuccessStatisticOp) {
        this.workflowTableSuccessStatisticOp = workflowTableSuccessStatisticOp;
    }

    public void setWorkflowTableFailureStatisticOp(StatisticIterm workflowTableFailureStatisticOp) {
        this.workflowTableFailureStatisticOp = workflowTableFailureStatisticOp;
    }

    public void setWorkflowDataSocTotalStatisticOp(StatisticIterm workflowDataSocTotalStatisticOp) {
        this.workflowDataSocTotalStatisticOp = workflowDataSocTotalStatisticOp;
    }

    public void setWorkflowDataSocSuccessStatisticOp(StatisticIterm workflowDataSocSuccessStatisticOp) {
        this.workflowDataSocSuccessStatisticOp = workflowDataSocSuccessStatisticOp;
    }

    public void setWorkflowDataSocFailureStatisticOp(StatisticIterm workflowDataSocFailureStatisticOp) {
        this.workflowDataSocFailureStatisticOp = workflowDataSocFailureStatisticOp;
    }

    public void setWorkflowAdHocTotalStatisticOp(StatisticIterm workflowAdHocTotalStatisticOp) {
        this.workflowAdHocTotalStatisticOp = workflowAdHocTotalStatisticOp;
    }

    public void setWorkflowAdHocSuccessStatisticOp(StatisticIterm workflowAdHocSuccessStatisticOp) {
        this.workflowAdHocSuccessStatisticOp = workflowAdHocSuccessStatisticOp;
    }

    public void setWorkflowAdHocFailureStatisticOp(StatisticIterm workflowAdHocFailureStatisticOp) {
        this.workflowAdHocFailureStatisticOp = workflowAdHocFailureStatisticOp;
    }

    public void setWorkflowDataSvcTotalStatisticOp(StatisticIterm workflowDataSvcTotalStatisticOp) {
        this.workflowDataSvcTotalStatisticOp = workflowDataSvcTotalStatisticOp;
    }

    public void setWorkflowDataSvcSuccessStatisticOp(StatisticIterm workflowDataSvcSuccessStatisticOp) {
        this.workflowDataSvcSuccessStatisticOp = workflowDataSvcSuccessStatisticOp;
    }

    public void setWorkflowDataSvcFailureStatisticOp(StatisticIterm workflowDataSvcFailureStatisticOp) {
        this.workflowDataSvcFailureStatisticOp = workflowDataSvcFailureStatisticOp;
    }

    public void setWorkflowDQCTotalStatisticOp(StatisticIterm workflowDQCTotalStatisticOp) {
        this.workflowDQCTotalStatisticOp = workflowDQCTotalStatisticOp;
    }

    public void setWorkflowDQCSuccessStatisticOp(StatisticIterm workflowDQCSuccessStatisticOp) {
        this.workflowDQCSuccessStatisticOp = workflowDQCSuccessStatisticOp;
    }

    public void setWorkflowDQCFailureStatisticOp(StatisticIterm workflowDQCFailureStatisticOp) {
        this.workflowDQCFailureStatisticOp = workflowDQCFailureStatisticOp;
    }

    public void setNodeMappings(List<NodeMapping> nodeMappings) {
        this.nodeMappings = nodeMappings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticOp)) {
            return false;
        }
        StatisticOp other = (StatisticOp)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<StatisticIterm> this$statisticIterms = this.getStatisticIterms();
        List<StatisticIterm> other$statisticIterms = other.getStatisticIterms();
        if (this$statisticIterms == null ? other$statisticIterms != null : !((Object)this$statisticIterms).equals(other$statisticIterms)) {
            return false;
        }
        Map<String, Integer> this$nodeTypeStatistic = this.getNodeTypeStatistic();
        Map<String, Integer> other$nodeTypeStatistic = other.getNodeTypeStatistic();
        if (this$nodeTypeStatistic == null ? other$nodeTypeStatistic != null : !((Object)this$nodeTypeStatistic).equals(other$nodeTypeStatistic)) {
            return false;
        }
        Map<String, Map<String, Integer>> this$nodeTypeStatisticEachWorkflow = this.getNodeTypeStatisticEachWorkflow();
        Map<String, Map<String, Integer>> other$nodeTypeStatisticEachWorkflow = other.getNodeTypeStatisticEachWorkflow();
        if (this$nodeTypeStatisticEachWorkflow == null ? other$nodeTypeStatisticEachWorkflow != null : !((Object)this$nodeTypeStatisticEachWorkflow).equals(other$nodeTypeStatisticEachWorkflow)) {
            return false;
        }
        StatisticIterm this$workflowTotalStatisticOp = this.getWorkflowTotalStatisticOp();
        StatisticIterm other$workflowTotalStatisticOp = other.getWorkflowTotalStatisticOp();
        if (this$workflowTotalStatisticOp == null ? other$workflowTotalStatisticOp != null : !((Object)this$workflowTotalStatisticOp).equals(other$workflowTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowSuccessStatisticOp = this.getWorkflowSuccessStatisticOp();
        StatisticIterm other$workflowSuccessStatisticOp = other.getWorkflowSuccessStatisticOp();
        if (this$workflowSuccessStatisticOp == null ? other$workflowSuccessStatisticOp != null : !((Object)this$workflowSuccessStatisticOp).equals(other$workflowSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowFailureStatisticOp = this.getWorkflowFailureStatisticOp();
        StatisticIterm other$workflowFailureStatisticOp = other.getWorkflowFailureStatisticOp();
        if (this$workflowFailureStatisticOp == null ? other$workflowFailureStatisticOp != null : !((Object)this$workflowFailureStatisticOp).equals(other$workflowFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowNodeTotalStatisticOp = this.getWorkflowNodeTotalStatisticOp();
        StatisticIterm other$workflowNodeTotalStatisticOp = other.getWorkflowNodeTotalStatisticOp();
        if (this$workflowNodeTotalStatisticOp == null ? other$workflowNodeTotalStatisticOp != null : !((Object)this$workflowNodeTotalStatisticOp).equals(other$workflowNodeTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowNodeSuccessStatisticOp = this.getWorkflowNodeSuccessStatisticOp();
        StatisticIterm other$workflowNodeSuccessStatisticOp = other.getWorkflowNodeSuccessStatisticOp();
        if (this$workflowNodeSuccessStatisticOp == null ? other$workflowNodeSuccessStatisticOp != null : !((Object)this$workflowNodeSuccessStatisticOp).equals(other$workflowNodeSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowNodeFailureStatisticOp = this.getWorkflowNodeFailureStatisticOp();
        StatisticIterm other$workflowNodeFailureStatisticOp = other.getWorkflowNodeFailureStatisticOp();
        if (this$workflowNodeFailureStatisticOp == null ? other$workflowNodeFailureStatisticOp != null : !((Object)this$workflowNodeFailureStatisticOp).equals(other$workflowNodeFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowNodeSkipStatisticOp = this.getWorkflowNodeSkipStatisticOp();
        StatisticIterm other$workflowNodeSkipStatisticOp = other.getWorkflowNodeSkipStatisticOp();
        if (this$workflowNodeSkipStatisticOp == null ? other$workflowNodeSkipStatisticOp != null : !((Object)this$workflowNodeSkipStatisticOp).equals(other$workflowNodeSkipStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowNodeTempStatisticOp = this.getWorkflowNodeTempStatisticOp();
        StatisticIterm other$workflowNodeTempStatisticOp = other.getWorkflowNodeTempStatisticOp();
        if (this$workflowNodeTempStatisticOp == null ? other$workflowNodeTempStatisticOp != null : !((Object)this$workflowNodeTempStatisticOp).equals(other$workflowNodeTempStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowNodeResultStatisticOp = this.getWorkflowNodeResultStatisticOp();
        StatisticIterm other$workflowNodeResultStatisticOp = other.getWorkflowNodeResultStatisticOp();
        if (this$workflowNodeResultStatisticOp == null ? other$workflowNodeResultStatisticOp != null : !((Object)this$workflowNodeResultStatisticOp).equals(other$workflowNodeResultStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowResourceTotalStatisticOp = this.getWorkflowResourceTotalStatisticOp();
        StatisticIterm other$workflowResourceTotalStatisticOp = other.getWorkflowResourceTotalStatisticOp();
        if (this$workflowResourceTotalStatisticOp == null ? other$workflowResourceTotalStatisticOp != null : !((Object)this$workflowResourceTotalStatisticOp).equals(other$workflowResourceTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowResourceSuccessStatisticOp = this.getWorkflowResourceSuccessStatisticOp();
        StatisticIterm other$workflowResourceSuccessStatisticOp = other.getWorkflowResourceSuccessStatisticOp();
        if (this$workflowResourceSuccessStatisticOp == null ? other$workflowResourceSuccessStatisticOp != null : !((Object)this$workflowResourceSuccessStatisticOp).equals(other$workflowResourceSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowResourceFailureStatisticOp = this.getWorkflowResourceFailureStatisticOp();
        StatisticIterm other$workflowResourceFailureStatisticOp = other.getWorkflowResourceFailureStatisticOp();
        if (this$workflowResourceFailureStatisticOp == null ? other$workflowResourceFailureStatisticOp != null : !((Object)this$workflowResourceFailureStatisticOp).equals(other$workflowResourceFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowFunTotalStatisticOp = this.getWorkflowFunTotalStatisticOp();
        StatisticIterm other$workflowFunTotalStatisticOp = other.getWorkflowFunTotalStatisticOp();
        if (this$workflowFunTotalStatisticOp == null ? other$workflowFunTotalStatisticOp != null : !((Object)this$workflowFunTotalStatisticOp).equals(other$workflowFunTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowFunSuccessStatisticOp = this.getWorkflowFunSuccessStatisticOp();
        StatisticIterm other$workflowFunSuccessStatisticOp = other.getWorkflowFunSuccessStatisticOp();
        if (this$workflowFunSuccessStatisticOp == null ? other$workflowFunSuccessStatisticOp != null : !((Object)this$workflowFunSuccessStatisticOp).equals(other$workflowFunSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowFunFailureStatisticOp = this.getWorkflowFunFailureStatisticOp();
        StatisticIterm other$workflowFunFailureStatisticOp = other.getWorkflowFunFailureStatisticOp();
        if (this$workflowFunFailureStatisticOp == null ? other$workflowFunFailureStatisticOp != null : !((Object)this$workflowFunFailureStatisticOp).equals(other$workflowFunFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowCompTotalStatisticOp = this.getWorkflowCompTotalStatisticOp();
        StatisticIterm other$workflowCompTotalStatisticOp = other.getWorkflowCompTotalStatisticOp();
        if (this$workflowCompTotalStatisticOp == null ? other$workflowCompTotalStatisticOp != null : !((Object)this$workflowCompTotalStatisticOp).equals(other$workflowCompTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowCompSuccessStatisticOp = this.getWorkflowCompSuccessStatisticOp();
        StatisticIterm other$workflowCompSuccessStatisticOp = other.getWorkflowCompSuccessStatisticOp();
        if (this$workflowCompSuccessStatisticOp == null ? other$workflowCompSuccessStatisticOp != null : !((Object)this$workflowCompSuccessStatisticOp).equals(other$workflowCompSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowCompFailureStatisticOp = this.getWorkflowCompFailureStatisticOp();
        StatisticIterm other$workflowCompFailureStatisticOp = other.getWorkflowCompFailureStatisticOp();
        if (this$workflowCompFailureStatisticOp == null ? other$workflowCompFailureStatisticOp != null : !((Object)this$workflowCompFailureStatisticOp).equals(other$workflowCompFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowTableTotalStatisticOp = this.getWorkflowTableTotalStatisticOp();
        StatisticIterm other$workflowTableTotalStatisticOp = other.getWorkflowTableTotalStatisticOp();
        if (this$workflowTableTotalStatisticOp == null ? other$workflowTableTotalStatisticOp != null : !((Object)this$workflowTableTotalStatisticOp).equals(other$workflowTableTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowTableSuccessStatisticOp = this.getWorkflowTableSuccessStatisticOp();
        StatisticIterm other$workflowTableSuccessStatisticOp = other.getWorkflowTableSuccessStatisticOp();
        if (this$workflowTableSuccessStatisticOp == null ? other$workflowTableSuccessStatisticOp != null : !((Object)this$workflowTableSuccessStatisticOp).equals(other$workflowTableSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowTableFailureStatisticOp = this.getWorkflowTableFailureStatisticOp();
        StatisticIterm other$workflowTableFailureStatisticOp = other.getWorkflowTableFailureStatisticOp();
        if (this$workflowTableFailureStatisticOp == null ? other$workflowTableFailureStatisticOp != null : !((Object)this$workflowTableFailureStatisticOp).equals(other$workflowTableFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDataSocTotalStatisticOp = this.getWorkflowDataSocTotalStatisticOp();
        StatisticIterm other$workflowDataSocTotalStatisticOp = other.getWorkflowDataSocTotalStatisticOp();
        if (this$workflowDataSocTotalStatisticOp == null ? other$workflowDataSocTotalStatisticOp != null : !((Object)this$workflowDataSocTotalStatisticOp).equals(other$workflowDataSocTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDataSocSuccessStatisticOp = this.getWorkflowDataSocSuccessStatisticOp();
        StatisticIterm other$workflowDataSocSuccessStatisticOp = other.getWorkflowDataSocSuccessStatisticOp();
        if (this$workflowDataSocSuccessStatisticOp == null ? other$workflowDataSocSuccessStatisticOp != null : !((Object)this$workflowDataSocSuccessStatisticOp).equals(other$workflowDataSocSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDataSocFailureStatisticOp = this.getWorkflowDataSocFailureStatisticOp();
        StatisticIterm other$workflowDataSocFailureStatisticOp = other.getWorkflowDataSocFailureStatisticOp();
        if (this$workflowDataSocFailureStatisticOp == null ? other$workflowDataSocFailureStatisticOp != null : !((Object)this$workflowDataSocFailureStatisticOp).equals(other$workflowDataSocFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowAdHocTotalStatisticOp = this.getWorkflowAdHocTotalStatisticOp();
        StatisticIterm other$workflowAdHocTotalStatisticOp = other.getWorkflowAdHocTotalStatisticOp();
        if (this$workflowAdHocTotalStatisticOp == null ? other$workflowAdHocTotalStatisticOp != null : !((Object)this$workflowAdHocTotalStatisticOp).equals(other$workflowAdHocTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowAdHocSuccessStatisticOp = this.getWorkflowAdHocSuccessStatisticOp();
        StatisticIterm other$workflowAdHocSuccessStatisticOp = other.getWorkflowAdHocSuccessStatisticOp();
        if (this$workflowAdHocSuccessStatisticOp == null ? other$workflowAdHocSuccessStatisticOp != null : !((Object)this$workflowAdHocSuccessStatisticOp).equals(other$workflowAdHocSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowAdHocFailureStatisticOp = this.getWorkflowAdHocFailureStatisticOp();
        StatisticIterm other$workflowAdHocFailureStatisticOp = other.getWorkflowAdHocFailureStatisticOp();
        if (this$workflowAdHocFailureStatisticOp == null ? other$workflowAdHocFailureStatisticOp != null : !((Object)this$workflowAdHocFailureStatisticOp).equals(other$workflowAdHocFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDataSvcTotalStatisticOp = this.getWorkflowDataSvcTotalStatisticOp();
        StatisticIterm other$workflowDataSvcTotalStatisticOp = other.getWorkflowDataSvcTotalStatisticOp();
        if (this$workflowDataSvcTotalStatisticOp == null ? other$workflowDataSvcTotalStatisticOp != null : !((Object)this$workflowDataSvcTotalStatisticOp).equals(other$workflowDataSvcTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDataSvcSuccessStatisticOp = this.getWorkflowDataSvcSuccessStatisticOp();
        StatisticIterm other$workflowDataSvcSuccessStatisticOp = other.getWorkflowDataSvcSuccessStatisticOp();
        if (this$workflowDataSvcSuccessStatisticOp == null ? other$workflowDataSvcSuccessStatisticOp != null : !((Object)this$workflowDataSvcSuccessStatisticOp).equals(other$workflowDataSvcSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDataSvcFailureStatisticOp = this.getWorkflowDataSvcFailureStatisticOp();
        StatisticIterm other$workflowDataSvcFailureStatisticOp = other.getWorkflowDataSvcFailureStatisticOp();
        if (this$workflowDataSvcFailureStatisticOp == null ? other$workflowDataSvcFailureStatisticOp != null : !((Object)this$workflowDataSvcFailureStatisticOp).equals(other$workflowDataSvcFailureStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDQCTotalStatisticOp = this.getWorkflowDQCTotalStatisticOp();
        StatisticIterm other$workflowDQCTotalStatisticOp = other.getWorkflowDQCTotalStatisticOp();
        if (this$workflowDQCTotalStatisticOp == null ? other$workflowDQCTotalStatisticOp != null : !((Object)this$workflowDQCTotalStatisticOp).equals(other$workflowDQCTotalStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDQCSuccessStatisticOp = this.getWorkflowDQCSuccessStatisticOp();
        StatisticIterm other$workflowDQCSuccessStatisticOp = other.getWorkflowDQCSuccessStatisticOp();
        if (this$workflowDQCSuccessStatisticOp == null ? other$workflowDQCSuccessStatisticOp != null : !((Object)this$workflowDQCSuccessStatisticOp).equals(other$workflowDQCSuccessStatisticOp)) {
            return false;
        }
        StatisticIterm this$workflowDQCFailureStatisticOp = this.getWorkflowDQCFailureStatisticOp();
        StatisticIterm other$workflowDQCFailureStatisticOp = other.getWorkflowDQCFailureStatisticOp();
        if (this$workflowDQCFailureStatisticOp == null ? other$workflowDQCFailureStatisticOp != null : !((Object)this$workflowDQCFailureStatisticOp).equals(other$workflowDQCFailureStatisticOp)) {
            return false;
        }
        List<NodeMapping> this$nodeMappings = this.getNodeMappings();
        List<NodeMapping> other$nodeMappings = other.getNodeMappings();
        return !(this$nodeMappings == null ? other$nodeMappings != null : !((Object)this$nodeMappings).equals(other$nodeMappings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatisticOp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<StatisticIterm> $statisticIterms = this.getStatisticIterms();
        result = result * 59 + ($statisticIterms == null ? 43 : ((Object)$statisticIterms).hashCode());
        Map<String, Integer> $nodeTypeStatistic = this.getNodeTypeStatistic();
        result = result * 59 + ($nodeTypeStatistic == null ? 43 : ((Object)$nodeTypeStatistic).hashCode());
        Map<String, Map<String, Integer>> $nodeTypeStatisticEachWorkflow = this.getNodeTypeStatisticEachWorkflow();
        result = result * 59 + ($nodeTypeStatisticEachWorkflow == null ? 43 : ((Object)$nodeTypeStatisticEachWorkflow).hashCode());
        StatisticIterm $workflowTotalStatisticOp = this.getWorkflowTotalStatisticOp();
        result = result * 59 + ($workflowTotalStatisticOp == null ? 43 : ((Object)$workflowTotalStatisticOp).hashCode());
        StatisticIterm $workflowSuccessStatisticOp = this.getWorkflowSuccessStatisticOp();
        result = result * 59 + ($workflowSuccessStatisticOp == null ? 43 : ((Object)$workflowSuccessStatisticOp).hashCode());
        StatisticIterm $workflowFailureStatisticOp = this.getWorkflowFailureStatisticOp();
        result = result * 59 + ($workflowFailureStatisticOp == null ? 43 : ((Object)$workflowFailureStatisticOp).hashCode());
        StatisticIterm $workflowNodeTotalStatisticOp = this.getWorkflowNodeTotalStatisticOp();
        result = result * 59 + ($workflowNodeTotalStatisticOp == null ? 43 : ((Object)$workflowNodeTotalStatisticOp).hashCode());
        StatisticIterm $workflowNodeSuccessStatisticOp = this.getWorkflowNodeSuccessStatisticOp();
        result = result * 59 + ($workflowNodeSuccessStatisticOp == null ? 43 : ((Object)$workflowNodeSuccessStatisticOp).hashCode());
        StatisticIterm $workflowNodeFailureStatisticOp = this.getWorkflowNodeFailureStatisticOp();
        result = result * 59 + ($workflowNodeFailureStatisticOp == null ? 43 : ((Object)$workflowNodeFailureStatisticOp).hashCode());
        StatisticIterm $workflowNodeSkipStatisticOp = this.getWorkflowNodeSkipStatisticOp();
        result = result * 59 + ($workflowNodeSkipStatisticOp == null ? 43 : ((Object)$workflowNodeSkipStatisticOp).hashCode());
        StatisticIterm $workflowNodeTempStatisticOp = this.getWorkflowNodeTempStatisticOp();
        result = result * 59 + ($workflowNodeTempStatisticOp == null ? 43 : ((Object)$workflowNodeTempStatisticOp).hashCode());
        StatisticIterm $workflowNodeResultStatisticOp = this.getWorkflowNodeResultStatisticOp();
        result = result * 59 + ($workflowNodeResultStatisticOp == null ? 43 : ((Object)$workflowNodeResultStatisticOp).hashCode());
        StatisticIterm $workflowResourceTotalStatisticOp = this.getWorkflowResourceTotalStatisticOp();
        result = result * 59 + ($workflowResourceTotalStatisticOp == null ? 43 : ((Object)$workflowResourceTotalStatisticOp).hashCode());
        StatisticIterm $workflowResourceSuccessStatisticOp = this.getWorkflowResourceSuccessStatisticOp();
        result = result * 59 + ($workflowResourceSuccessStatisticOp == null ? 43 : ((Object)$workflowResourceSuccessStatisticOp).hashCode());
        StatisticIterm $workflowResourceFailureStatisticOp = this.getWorkflowResourceFailureStatisticOp();
        result = result * 59 + ($workflowResourceFailureStatisticOp == null ? 43 : ((Object)$workflowResourceFailureStatisticOp).hashCode());
        StatisticIterm $workflowFunTotalStatisticOp = this.getWorkflowFunTotalStatisticOp();
        result = result * 59 + ($workflowFunTotalStatisticOp == null ? 43 : ((Object)$workflowFunTotalStatisticOp).hashCode());
        StatisticIterm $workflowFunSuccessStatisticOp = this.getWorkflowFunSuccessStatisticOp();
        result = result * 59 + ($workflowFunSuccessStatisticOp == null ? 43 : ((Object)$workflowFunSuccessStatisticOp).hashCode());
        StatisticIterm $workflowFunFailureStatisticOp = this.getWorkflowFunFailureStatisticOp();
        result = result * 59 + ($workflowFunFailureStatisticOp == null ? 43 : ((Object)$workflowFunFailureStatisticOp).hashCode());
        StatisticIterm $workflowCompTotalStatisticOp = this.getWorkflowCompTotalStatisticOp();
        result = result * 59 + ($workflowCompTotalStatisticOp == null ? 43 : ((Object)$workflowCompTotalStatisticOp).hashCode());
        StatisticIterm $workflowCompSuccessStatisticOp = this.getWorkflowCompSuccessStatisticOp();
        result = result * 59 + ($workflowCompSuccessStatisticOp == null ? 43 : ((Object)$workflowCompSuccessStatisticOp).hashCode());
        StatisticIterm $workflowCompFailureStatisticOp = this.getWorkflowCompFailureStatisticOp();
        result = result * 59 + ($workflowCompFailureStatisticOp == null ? 43 : ((Object)$workflowCompFailureStatisticOp).hashCode());
        StatisticIterm $workflowTableTotalStatisticOp = this.getWorkflowTableTotalStatisticOp();
        result = result * 59 + ($workflowTableTotalStatisticOp == null ? 43 : ((Object)$workflowTableTotalStatisticOp).hashCode());
        StatisticIterm $workflowTableSuccessStatisticOp = this.getWorkflowTableSuccessStatisticOp();
        result = result * 59 + ($workflowTableSuccessStatisticOp == null ? 43 : ((Object)$workflowTableSuccessStatisticOp).hashCode());
        StatisticIterm $workflowTableFailureStatisticOp = this.getWorkflowTableFailureStatisticOp();
        result = result * 59 + ($workflowTableFailureStatisticOp == null ? 43 : ((Object)$workflowTableFailureStatisticOp).hashCode());
        StatisticIterm $workflowDataSocTotalStatisticOp = this.getWorkflowDataSocTotalStatisticOp();
        result = result * 59 + ($workflowDataSocTotalStatisticOp == null ? 43 : ((Object)$workflowDataSocTotalStatisticOp).hashCode());
        StatisticIterm $workflowDataSocSuccessStatisticOp = this.getWorkflowDataSocSuccessStatisticOp();
        result = result * 59 + ($workflowDataSocSuccessStatisticOp == null ? 43 : ((Object)$workflowDataSocSuccessStatisticOp).hashCode());
        StatisticIterm $workflowDataSocFailureStatisticOp = this.getWorkflowDataSocFailureStatisticOp();
        result = result * 59 + ($workflowDataSocFailureStatisticOp == null ? 43 : ((Object)$workflowDataSocFailureStatisticOp).hashCode());
        StatisticIterm $workflowAdHocTotalStatisticOp = this.getWorkflowAdHocTotalStatisticOp();
        result = result * 59 + ($workflowAdHocTotalStatisticOp == null ? 43 : ((Object)$workflowAdHocTotalStatisticOp).hashCode());
        StatisticIterm $workflowAdHocSuccessStatisticOp = this.getWorkflowAdHocSuccessStatisticOp();
        result = result * 59 + ($workflowAdHocSuccessStatisticOp == null ? 43 : ((Object)$workflowAdHocSuccessStatisticOp).hashCode());
        StatisticIterm $workflowAdHocFailureStatisticOp = this.getWorkflowAdHocFailureStatisticOp();
        result = result * 59 + ($workflowAdHocFailureStatisticOp == null ? 43 : ((Object)$workflowAdHocFailureStatisticOp).hashCode());
        StatisticIterm $workflowDataSvcTotalStatisticOp = this.getWorkflowDataSvcTotalStatisticOp();
        result = result * 59 + ($workflowDataSvcTotalStatisticOp == null ? 43 : ((Object)$workflowDataSvcTotalStatisticOp).hashCode());
        StatisticIterm $workflowDataSvcSuccessStatisticOp = this.getWorkflowDataSvcSuccessStatisticOp();
        result = result * 59 + ($workflowDataSvcSuccessStatisticOp == null ? 43 : ((Object)$workflowDataSvcSuccessStatisticOp).hashCode());
        StatisticIterm $workflowDataSvcFailureStatisticOp = this.getWorkflowDataSvcFailureStatisticOp();
        result = result * 59 + ($workflowDataSvcFailureStatisticOp == null ? 43 : ((Object)$workflowDataSvcFailureStatisticOp).hashCode());
        StatisticIterm $workflowDQCTotalStatisticOp = this.getWorkflowDQCTotalStatisticOp();
        result = result * 59 + ($workflowDQCTotalStatisticOp == null ? 43 : ((Object)$workflowDQCTotalStatisticOp).hashCode());
        StatisticIterm $workflowDQCSuccessStatisticOp = this.getWorkflowDQCSuccessStatisticOp();
        result = result * 59 + ($workflowDQCSuccessStatisticOp == null ? 43 : ((Object)$workflowDQCSuccessStatisticOp).hashCode());
        StatisticIterm $workflowDQCFailureStatisticOp = this.getWorkflowDQCFailureStatisticOp();
        result = result * 59 + ($workflowDQCFailureStatisticOp == null ? 43 : ((Object)$workflowDQCFailureStatisticOp).hashCode());
        List<NodeMapping> $nodeMappings = this.getNodeMappings();
        result = result * 59 + ($nodeMappings == null ? 43 : ((Object)$nodeMappings).hashCode());
        return result;
    }

    public String toString() {
        return "StatisticOp(statisticIterms=" + this.getStatisticIterms() + ", nodeTypeStatistic=" + this.getNodeTypeStatistic() + ", nodeTypeStatisticEachWorkflow=" + this.getNodeTypeStatisticEachWorkflow() + ", workflowTotalStatisticOp=" + this.getWorkflowTotalStatisticOp() + ", workflowSuccessStatisticOp=" + this.getWorkflowSuccessStatisticOp() + ", workflowFailureStatisticOp=" + this.getWorkflowFailureStatisticOp() + ", workflowNodeTotalStatisticOp=" + this.getWorkflowNodeTotalStatisticOp() + ", workflowNodeSuccessStatisticOp=" + this.getWorkflowNodeSuccessStatisticOp() + ", workflowNodeFailureStatisticOp=" + this.getWorkflowNodeFailureStatisticOp() + ", workflowNodeSkipStatisticOp=" + this.getWorkflowNodeSkipStatisticOp() + ", workflowNodeTempStatisticOp=" + this.getWorkflowNodeTempStatisticOp() + ", workflowNodeResultStatisticOp=" + this.getWorkflowNodeResultStatisticOp() + ", workflowResourceTotalStatisticOp=" + this.getWorkflowResourceTotalStatisticOp() + ", workflowResourceSuccessStatisticOp=" + this.getWorkflowResourceSuccessStatisticOp() + ", workflowResourceFailureStatisticOp=" + this.getWorkflowResourceFailureStatisticOp() + ", workflowFunTotalStatisticOp=" + this.getWorkflowFunTotalStatisticOp() + ", workflowFunSuccessStatisticOp=" + this.getWorkflowFunSuccessStatisticOp() + ", workflowFunFailureStatisticOp=" + this.getWorkflowFunFailureStatisticOp() + ", workflowCompTotalStatisticOp=" + this.getWorkflowCompTotalStatisticOp() + ", workflowCompSuccessStatisticOp=" + this.getWorkflowCompSuccessStatisticOp() + ", workflowCompFailureStatisticOp=" + this.getWorkflowCompFailureStatisticOp() + ", workflowTableTotalStatisticOp=" + this.getWorkflowTableTotalStatisticOp() + ", workflowTableSuccessStatisticOp=" + this.getWorkflowTableSuccessStatisticOp() + ", workflowTableFailureStatisticOp=" + this.getWorkflowTableFailureStatisticOp() + ", workflowDataSocTotalStatisticOp=" + this.getWorkflowDataSocTotalStatisticOp() + ", workflowDataSocSuccessStatisticOp=" + this.getWorkflowDataSocSuccessStatisticOp() + ", workflowDataSocFailureStatisticOp=" + this.getWorkflowDataSocFailureStatisticOp() + ", workflowAdHocTotalStatisticOp=" + this.getWorkflowAdHocTotalStatisticOp() + ", workflowAdHocSuccessStatisticOp=" + this.getWorkflowAdHocSuccessStatisticOp() + ", workflowAdHocFailureStatisticOp=" + this.getWorkflowAdHocFailureStatisticOp() + ", workflowDataSvcTotalStatisticOp=" + this.getWorkflowDataSvcTotalStatisticOp() + ", workflowDataSvcSuccessStatisticOp=" + this.getWorkflowDataSvcSuccessStatisticOp() + ", workflowDataSvcFailureStatisticOp=" + this.getWorkflowDataSvcFailureStatisticOp() + ", workflowDQCTotalStatisticOp=" + this.getWorkflowDQCTotalStatisticOp() + ", workflowDQCSuccessStatisticOp=" + this.getWorkflowDQCSuccessStatisticOp() + ", workflowDQCFailureStatisticOp=" + this.getWorkflowDQCFailureStatisticOp() + ", nodeMappings=" + this.getNodeMappings() + ")";
    }

    public StatisticOp() {
    }

    public StatisticOp(List<StatisticIterm> statisticIterms, Map<String, Integer> nodeTypeStatistic, Map<String, Map<String, Integer>> nodeTypeStatisticEachWorkflow, StatisticIterm workflowTotalStatisticOp, StatisticIterm workflowSuccessStatisticOp, StatisticIterm workflowFailureStatisticOp, StatisticIterm workflowNodeTotalStatisticOp, StatisticIterm workflowNodeSuccessStatisticOp, StatisticIterm workflowNodeFailureStatisticOp, StatisticIterm workflowNodeSkipStatisticOp, StatisticIterm workflowNodeTempStatisticOp, StatisticIterm workflowNodeResultStatisticOp, StatisticIterm workflowResourceTotalStatisticOp, StatisticIterm workflowResourceSuccessStatisticOp, StatisticIterm workflowResourceFailureStatisticOp, StatisticIterm workflowFunTotalStatisticOp, StatisticIterm workflowFunSuccessStatisticOp, StatisticIterm workflowFunFailureStatisticOp, StatisticIterm workflowCompTotalStatisticOp, StatisticIterm workflowCompSuccessStatisticOp, StatisticIterm workflowCompFailureStatisticOp, StatisticIterm workflowTableTotalStatisticOp, StatisticIterm workflowTableSuccessStatisticOp, StatisticIterm workflowTableFailureStatisticOp, StatisticIterm workflowDataSocTotalStatisticOp, StatisticIterm workflowDataSocSuccessStatisticOp, StatisticIterm workflowDataSocFailureStatisticOp, StatisticIterm workflowAdHocTotalStatisticOp, StatisticIterm workflowAdHocSuccessStatisticOp, StatisticIterm workflowAdHocFailureStatisticOp, StatisticIterm workflowDataSvcTotalStatisticOp, StatisticIterm workflowDataSvcSuccessStatisticOp, StatisticIterm workflowDataSvcFailureStatisticOp, StatisticIterm workflowDQCTotalStatisticOp, StatisticIterm workflowDQCSuccessStatisticOp, StatisticIterm workflowDQCFailureStatisticOp, List<NodeMapping> nodeMappings) {
        this.statisticIterms = statisticIterms;
        this.nodeTypeStatistic = nodeTypeStatistic;
        this.nodeTypeStatisticEachWorkflow = nodeTypeStatisticEachWorkflow;
        this.workflowTotalStatisticOp = workflowTotalStatisticOp;
        this.workflowSuccessStatisticOp = workflowSuccessStatisticOp;
        this.workflowFailureStatisticOp = workflowFailureStatisticOp;
        this.workflowNodeTotalStatisticOp = workflowNodeTotalStatisticOp;
        this.workflowNodeSuccessStatisticOp = workflowNodeSuccessStatisticOp;
        this.workflowNodeFailureStatisticOp = workflowNodeFailureStatisticOp;
        this.workflowNodeSkipStatisticOp = workflowNodeSkipStatisticOp;
        this.workflowNodeTempStatisticOp = workflowNodeTempStatisticOp;
        this.workflowNodeResultStatisticOp = workflowNodeResultStatisticOp;
        this.workflowResourceTotalStatisticOp = workflowResourceTotalStatisticOp;
        this.workflowResourceSuccessStatisticOp = workflowResourceSuccessStatisticOp;
        this.workflowResourceFailureStatisticOp = workflowResourceFailureStatisticOp;
        this.workflowFunTotalStatisticOp = workflowFunTotalStatisticOp;
        this.workflowFunSuccessStatisticOp = workflowFunSuccessStatisticOp;
        this.workflowFunFailureStatisticOp = workflowFunFailureStatisticOp;
        this.workflowCompTotalStatisticOp = workflowCompTotalStatisticOp;
        this.workflowCompSuccessStatisticOp = workflowCompSuccessStatisticOp;
        this.workflowCompFailureStatisticOp = workflowCompFailureStatisticOp;
        this.workflowTableTotalStatisticOp = workflowTableTotalStatisticOp;
        this.workflowTableSuccessStatisticOp = workflowTableSuccessStatisticOp;
        this.workflowTableFailureStatisticOp = workflowTableFailureStatisticOp;
        this.workflowDataSocTotalStatisticOp = workflowDataSocTotalStatisticOp;
        this.workflowDataSocSuccessStatisticOp = workflowDataSocSuccessStatisticOp;
        this.workflowDataSocFailureStatisticOp = workflowDataSocFailureStatisticOp;
        this.workflowAdHocTotalStatisticOp = workflowAdHocTotalStatisticOp;
        this.workflowAdHocSuccessStatisticOp = workflowAdHocSuccessStatisticOp;
        this.workflowAdHocFailureStatisticOp = workflowAdHocFailureStatisticOp;
        this.workflowDataSvcTotalStatisticOp = workflowDataSvcTotalStatisticOp;
        this.workflowDataSvcSuccessStatisticOp = workflowDataSvcSuccessStatisticOp;
        this.workflowDataSvcFailureStatisticOp = workflowDataSvcFailureStatisticOp;
        this.workflowDQCTotalStatisticOp = workflowDQCTotalStatisticOp;
        this.workflowDQCSuccessStatisticOp = workflowDQCSuccessStatisticOp;
        this.workflowDQCFailureStatisticOp = workflowDQCFailureStatisticOp;
        this.nodeMappings = nodeMappings;
    }

    public static class StatisticIterm {
        private AtomicInteger atomicInteger;
        private StatisticType statisticType;
        private StatisticItemEnum statisticItem;
        private List<Pair<String, String>> itermAndMsgs = new ArrayList<Pair<String, String>>();

        public StatisticIterm(StatisticType statisticType, StatisticItemEnum statisticItem) {
            this.statisticItem = statisticItem;
            this.statisticType = statisticType;
            this.atomicInteger = new AtomicInteger(0);
        }

        public void increment(int incr) {
            this.atomicInteger.addAndGet(incr);
        }

        public void incrementOne(String iterm) {
            this.atomicInteger.incrementAndGet();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{iterm})) {
                this.itermAndMsgs.add((Pair<String, String>)Pair.of((Object)iterm, null));
            }
        }

        public void incrementFailedOne(String iterm, String msg) {
            this.atomicInteger.incrementAndGet();
            this.itermAndMsgs.add((Pair<String, String>)Pair.of((Object)iterm, (Object)msg));
        }

        public void incrementDetailOne(String iterm) {
            this.atomicInteger.incrementAndGet();
            this.itermAndMsgs.add((Pair<String, String>)Pair.of((Object)iterm, null));
        }

        public void justAddOneMsgLog(String iterm, String msg) {
            this.itermAndMsgs.add((Pair<String, String>)Pair.of((Object)iterm, (Object)msg));
        }

        public static StatisticItermBuilder builder() {
            return new StatisticItermBuilder();
        }

        public AtomicInteger getAtomicInteger() {
            return this.atomicInteger;
        }

        public StatisticType getStatisticType() {
            return this.statisticType;
        }

        public StatisticItemEnum getStatisticItem() {
            return this.statisticItem;
        }

        public List<Pair<String, String>> getItermAndMsgs() {
            return this.itermAndMsgs;
        }

        public void setAtomicInteger(AtomicInteger atomicInteger) {
            this.atomicInteger = atomicInteger;
        }

        public void setStatisticType(StatisticType statisticType) {
            this.statisticType = statisticType;
        }

        public void setStatisticItem(StatisticItemEnum statisticItem) {
            this.statisticItem = statisticItem;
        }

        public void setItermAndMsgs(List<Pair<String, String>> itermAndMsgs) {
            this.itermAndMsgs = itermAndMsgs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatisticIterm)) {
                return false;
            }
            StatisticIterm other = (StatisticIterm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtomicInteger this$atomicInteger = this.getAtomicInteger();
            AtomicInteger other$atomicInteger = other.getAtomicInteger();
            if (this$atomicInteger == null ? other$atomicInteger != null : !this$atomicInteger.equals(other$atomicInteger)) {
                return false;
            }
            StatisticType this$statisticType = this.getStatisticType();
            StatisticType other$statisticType = other.getStatisticType();
            if (this$statisticType == null ? other$statisticType != null : !((Object)((Object)this$statisticType)).equals((Object)other$statisticType)) {
                return false;
            }
            StatisticItemEnum this$statisticItem = this.getStatisticItem();
            StatisticItemEnum other$statisticItem = other.getStatisticItem();
            if (this$statisticItem == null ? other$statisticItem != null : !((Object)((Object)this$statisticItem)).equals((Object)other$statisticItem)) {
                return false;
            }
            List<Pair<String, String>> this$itermAndMsgs = this.getItermAndMsgs();
            List<Pair<String, String>> other$itermAndMsgs = other.getItermAndMsgs();
            return !(this$itermAndMsgs == null ? other$itermAndMsgs != null : !((Object)this$itermAndMsgs).equals(other$itermAndMsgs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StatisticIterm;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicInteger $atomicInteger = this.getAtomicInteger();
            result = result * 59 + ($atomicInteger == null ? 43 : $atomicInteger.hashCode());
            StatisticType $statisticType = this.getStatisticType();
            result = result * 59 + ($statisticType == null ? 43 : ((Object)((Object)$statisticType)).hashCode());
            StatisticItemEnum $statisticItem = this.getStatisticItem();
            result = result * 59 + ($statisticItem == null ? 43 : ((Object)((Object)$statisticItem)).hashCode());
            List<Pair<String, String>> $itermAndMsgs = this.getItermAndMsgs();
            result = result * 59 + ($itermAndMsgs == null ? 43 : ((Object)$itermAndMsgs).hashCode());
            return result;
        }

        public String toString() {
            return "StatisticOp.StatisticIterm(atomicInteger=" + this.getAtomicInteger() + ", statisticType=" + this.getStatisticType() + ", statisticItem=" + this.getStatisticItem() + ", itermAndMsgs=" + this.getItermAndMsgs() + ")";
        }

        public StatisticIterm() {
        }

        public StatisticIterm(AtomicInteger atomicInteger, StatisticType statisticType, StatisticItemEnum statisticItem, List<Pair<String, String>> itermAndMsgs) {
            this.atomicInteger = atomicInteger;
            this.statisticType = statisticType;
            this.statisticItem = statisticItem;
            this.itermAndMsgs = itermAndMsgs;
        }

        public static class StatisticItermBuilder {
            private AtomicInteger atomicInteger;
            private StatisticType statisticType;
            private StatisticItemEnum statisticItem;
            private List<Pair<String, String>> itermAndMsgs;

            StatisticItermBuilder() {
            }

            public StatisticItermBuilder atomicInteger(AtomicInteger atomicInteger) {
                this.atomicInteger = atomicInteger;
                return this;
            }

            public StatisticItermBuilder statisticType(StatisticType statisticType) {
                this.statisticType = statisticType;
                return this;
            }

            public StatisticItermBuilder statisticItem(StatisticItemEnum statisticItem) {
                this.statisticItem = statisticItem;
                return this;
            }

            public StatisticItermBuilder itermAndMsgs(List<Pair<String, String>> itermAndMsgs) {
                this.itermAndMsgs = itermAndMsgs;
                return this;
            }

            public StatisticIterm build() {
                return new StatisticIterm(this.atomicInteger, this.statisticType, this.statisticItem, this.itermAndMsgs);
            }

            public String toString() {
                return "StatisticOp.StatisticIterm.StatisticItermBuilder(atomicInteger=" + this.atomicInteger + ", statisticType=" + this.statisticType + ", statisticItem=" + this.statisticItem + ", itermAndMsgs=" + this.itermAndMsgs + ")";
            }
        }
    }

    public static enum StatisticType {
        WORKFLOW,
        WORKFLOWNODE,
        RESOURCE,
        FUNCTION,
        COMPONENT,
        TABLE,
        DATASOURCE,
        AD_HOC_QUERY,
        DATA_SERVICE,
        DQC;

    }

    public static enum StatisticItemEnum {
        TOTAL,
        SUCCESS,
        FAILURE,
        SKIP,
        TEMP,
        RESULT;

    }

    public static class StatisticOpBuilder {
        private List<StatisticIterm> statisticIterms;
        private Map<String, Integer> nodeTypeStatistic;
        private Map<String, Map<String, Integer>> nodeTypeStatisticEachWorkflow;
        private StatisticIterm workflowTotalStatisticOp;
        private StatisticIterm workflowSuccessStatisticOp;
        private StatisticIterm workflowFailureStatisticOp;
        private StatisticIterm workflowNodeTotalStatisticOp;
        private StatisticIterm workflowNodeSuccessStatisticOp;
        private StatisticIterm workflowNodeFailureStatisticOp;
        private StatisticIterm workflowNodeSkipStatisticOp;
        private StatisticIterm workflowNodeTempStatisticOp;
        private StatisticIterm workflowNodeResultStatisticOp;
        private StatisticIterm workflowResourceTotalStatisticOp;
        private StatisticIterm workflowResourceSuccessStatisticOp;
        private StatisticIterm workflowResourceFailureStatisticOp;
        private StatisticIterm workflowFunTotalStatisticOp;
        private StatisticIterm workflowFunSuccessStatisticOp;
        private StatisticIterm workflowFunFailureStatisticOp;
        private StatisticIterm workflowCompTotalStatisticOp;
        private StatisticIterm workflowCompSuccessStatisticOp;
        private StatisticIterm workflowCompFailureStatisticOp;
        private StatisticIterm workflowTableTotalStatisticOp;
        private StatisticIterm workflowTableSuccessStatisticOp;
        private StatisticIterm workflowTableFailureStatisticOp;
        private StatisticIterm workflowDataSocTotalStatisticOp;
        private StatisticIterm workflowDataSocSuccessStatisticOp;
        private StatisticIterm workflowDataSocFailureStatisticOp;
        private StatisticIterm workflowAdHocTotalStatisticOp;
        private StatisticIterm workflowAdHocSuccessStatisticOp;
        private StatisticIterm workflowAdHocFailureStatisticOp;
        private StatisticIterm workflowDataSvcTotalStatisticOp;
        private StatisticIterm workflowDataSvcSuccessStatisticOp;
        private StatisticIterm workflowDataSvcFailureStatisticOp;
        private StatisticIterm workflowDQCTotalStatisticOp;
        private StatisticIterm workflowDQCSuccessStatisticOp;
        private StatisticIterm workflowDQCFailureStatisticOp;
        private List<NodeMapping> nodeMappings;

        StatisticOpBuilder() {
        }

        public StatisticOpBuilder statisticIterms(List<StatisticIterm> statisticIterms) {
            this.statisticIterms = statisticIterms;
            return this;
        }

        public StatisticOpBuilder nodeTypeStatistic(Map<String, Integer> nodeTypeStatistic) {
            this.nodeTypeStatistic = nodeTypeStatistic;
            return this;
        }

        public StatisticOpBuilder nodeTypeStatisticEachWorkflow(Map<String, Map<String, Integer>> nodeTypeStatisticEachWorkflow) {
            this.nodeTypeStatisticEachWorkflow = nodeTypeStatisticEachWorkflow;
            return this;
        }

        public StatisticOpBuilder workflowTotalStatisticOp(StatisticIterm workflowTotalStatisticOp) {
            this.workflowTotalStatisticOp = workflowTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowSuccessStatisticOp(StatisticIterm workflowSuccessStatisticOp) {
            this.workflowSuccessStatisticOp = workflowSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowFailureStatisticOp(StatisticIterm workflowFailureStatisticOp) {
            this.workflowFailureStatisticOp = workflowFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowNodeTotalStatisticOp(StatisticIterm workflowNodeTotalStatisticOp) {
            this.workflowNodeTotalStatisticOp = workflowNodeTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowNodeSuccessStatisticOp(StatisticIterm workflowNodeSuccessStatisticOp) {
            this.workflowNodeSuccessStatisticOp = workflowNodeSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowNodeFailureStatisticOp(StatisticIterm workflowNodeFailureStatisticOp) {
            this.workflowNodeFailureStatisticOp = workflowNodeFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowNodeSkipStatisticOp(StatisticIterm workflowNodeSkipStatisticOp) {
            this.workflowNodeSkipStatisticOp = workflowNodeSkipStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowNodeTempStatisticOp(StatisticIterm workflowNodeTempStatisticOp) {
            this.workflowNodeTempStatisticOp = workflowNodeTempStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowNodeResultStatisticOp(StatisticIterm workflowNodeResultStatisticOp) {
            this.workflowNodeResultStatisticOp = workflowNodeResultStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowResourceTotalStatisticOp(StatisticIterm workflowResourceTotalStatisticOp) {
            this.workflowResourceTotalStatisticOp = workflowResourceTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowResourceSuccessStatisticOp(StatisticIterm workflowResourceSuccessStatisticOp) {
            this.workflowResourceSuccessStatisticOp = workflowResourceSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowResourceFailureStatisticOp(StatisticIterm workflowResourceFailureStatisticOp) {
            this.workflowResourceFailureStatisticOp = workflowResourceFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowFunTotalStatisticOp(StatisticIterm workflowFunTotalStatisticOp) {
            this.workflowFunTotalStatisticOp = workflowFunTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowFunSuccessStatisticOp(StatisticIterm workflowFunSuccessStatisticOp) {
            this.workflowFunSuccessStatisticOp = workflowFunSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowFunFailureStatisticOp(StatisticIterm workflowFunFailureStatisticOp) {
            this.workflowFunFailureStatisticOp = workflowFunFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowCompTotalStatisticOp(StatisticIterm workflowCompTotalStatisticOp) {
            this.workflowCompTotalStatisticOp = workflowCompTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowCompSuccessStatisticOp(StatisticIterm workflowCompSuccessStatisticOp) {
            this.workflowCompSuccessStatisticOp = workflowCompSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowCompFailureStatisticOp(StatisticIterm workflowCompFailureStatisticOp) {
            this.workflowCompFailureStatisticOp = workflowCompFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowTableTotalStatisticOp(StatisticIterm workflowTableTotalStatisticOp) {
            this.workflowTableTotalStatisticOp = workflowTableTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowTableSuccessStatisticOp(StatisticIterm workflowTableSuccessStatisticOp) {
            this.workflowTableSuccessStatisticOp = workflowTableSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowTableFailureStatisticOp(StatisticIterm workflowTableFailureStatisticOp) {
            this.workflowTableFailureStatisticOp = workflowTableFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDataSocTotalStatisticOp(StatisticIterm workflowDataSocTotalStatisticOp) {
            this.workflowDataSocTotalStatisticOp = workflowDataSocTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDataSocSuccessStatisticOp(StatisticIterm workflowDataSocSuccessStatisticOp) {
            this.workflowDataSocSuccessStatisticOp = workflowDataSocSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDataSocFailureStatisticOp(StatisticIterm workflowDataSocFailureStatisticOp) {
            this.workflowDataSocFailureStatisticOp = workflowDataSocFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowAdHocTotalStatisticOp(StatisticIterm workflowAdHocTotalStatisticOp) {
            this.workflowAdHocTotalStatisticOp = workflowAdHocTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowAdHocSuccessStatisticOp(StatisticIterm workflowAdHocSuccessStatisticOp) {
            this.workflowAdHocSuccessStatisticOp = workflowAdHocSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowAdHocFailureStatisticOp(StatisticIterm workflowAdHocFailureStatisticOp) {
            this.workflowAdHocFailureStatisticOp = workflowAdHocFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDataSvcTotalStatisticOp(StatisticIterm workflowDataSvcTotalStatisticOp) {
            this.workflowDataSvcTotalStatisticOp = workflowDataSvcTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDataSvcSuccessStatisticOp(StatisticIterm workflowDataSvcSuccessStatisticOp) {
            this.workflowDataSvcSuccessStatisticOp = workflowDataSvcSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDataSvcFailureStatisticOp(StatisticIterm workflowDataSvcFailureStatisticOp) {
            this.workflowDataSvcFailureStatisticOp = workflowDataSvcFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDQCTotalStatisticOp(StatisticIterm workflowDQCTotalStatisticOp) {
            this.workflowDQCTotalStatisticOp = workflowDQCTotalStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDQCSuccessStatisticOp(StatisticIterm workflowDQCSuccessStatisticOp) {
            this.workflowDQCSuccessStatisticOp = workflowDQCSuccessStatisticOp;
            return this;
        }

        public StatisticOpBuilder workflowDQCFailureStatisticOp(StatisticIterm workflowDQCFailureStatisticOp) {
            this.workflowDQCFailureStatisticOp = workflowDQCFailureStatisticOp;
            return this;
        }

        public StatisticOpBuilder nodeMappings(List<NodeMapping> nodeMappings) {
            this.nodeMappings = nodeMappings;
            return this;
        }

        public StatisticOp build() {
            return new StatisticOp(this.statisticIterms, this.nodeTypeStatistic, this.nodeTypeStatisticEachWorkflow, this.workflowTotalStatisticOp, this.workflowSuccessStatisticOp, this.workflowFailureStatisticOp, this.workflowNodeTotalStatisticOp, this.workflowNodeSuccessStatisticOp, this.workflowNodeFailureStatisticOp, this.workflowNodeSkipStatisticOp, this.workflowNodeTempStatisticOp, this.workflowNodeResultStatisticOp, this.workflowResourceTotalStatisticOp, this.workflowResourceSuccessStatisticOp, this.workflowResourceFailureStatisticOp, this.workflowFunTotalStatisticOp, this.workflowFunSuccessStatisticOp, this.workflowFunFailureStatisticOp, this.workflowCompTotalStatisticOp, this.workflowCompSuccessStatisticOp, this.workflowCompFailureStatisticOp, this.workflowTableTotalStatisticOp, this.workflowTableSuccessStatisticOp, this.workflowTableFailureStatisticOp, this.workflowDataSocTotalStatisticOp, this.workflowDataSocSuccessStatisticOp, this.workflowDataSocFailureStatisticOp, this.workflowAdHocTotalStatisticOp, this.workflowAdHocSuccessStatisticOp, this.workflowAdHocFailureStatisticOp, this.workflowDataSvcTotalStatisticOp, this.workflowDataSvcSuccessStatisticOp, this.workflowDataSvcFailureStatisticOp, this.workflowDQCTotalStatisticOp, this.workflowDQCSuccessStatisticOp, this.workflowDQCFailureStatisticOp, this.nodeMappings);
        }

        public String toString() {
            return "StatisticOp.StatisticOpBuilder(statisticIterms=" + this.statisticIterms + ", nodeTypeStatistic=" + this.nodeTypeStatistic + ", nodeTypeStatisticEachWorkflow=" + this.nodeTypeStatisticEachWorkflow + ", workflowTotalStatisticOp=" + this.workflowTotalStatisticOp + ", workflowSuccessStatisticOp=" + this.workflowSuccessStatisticOp + ", workflowFailureStatisticOp=" + this.workflowFailureStatisticOp + ", workflowNodeTotalStatisticOp=" + this.workflowNodeTotalStatisticOp + ", workflowNodeSuccessStatisticOp=" + this.workflowNodeSuccessStatisticOp + ", workflowNodeFailureStatisticOp=" + this.workflowNodeFailureStatisticOp + ", workflowNodeSkipStatisticOp=" + this.workflowNodeSkipStatisticOp + ", workflowNodeTempStatisticOp=" + this.workflowNodeTempStatisticOp + ", workflowNodeResultStatisticOp=" + this.workflowNodeResultStatisticOp + ", workflowResourceTotalStatisticOp=" + this.workflowResourceTotalStatisticOp + ", workflowResourceSuccessStatisticOp=" + this.workflowResourceSuccessStatisticOp + ", workflowResourceFailureStatisticOp=" + this.workflowResourceFailureStatisticOp + ", workflowFunTotalStatisticOp=" + this.workflowFunTotalStatisticOp + ", workflowFunSuccessStatisticOp=" + this.workflowFunSuccessStatisticOp + ", workflowFunFailureStatisticOp=" + this.workflowFunFailureStatisticOp + ", workflowCompTotalStatisticOp=" + this.workflowCompTotalStatisticOp + ", workflowCompSuccessStatisticOp=" + this.workflowCompSuccessStatisticOp + ", workflowCompFailureStatisticOp=" + this.workflowCompFailureStatisticOp + ", workflowTableTotalStatisticOp=" + this.workflowTableTotalStatisticOp + ", workflowTableSuccessStatisticOp=" + this.workflowTableSuccessStatisticOp + ", workflowTableFailureStatisticOp=" + this.workflowTableFailureStatisticOp + ", workflowDataSocTotalStatisticOp=" + this.workflowDataSocTotalStatisticOp + ", workflowDataSocSuccessStatisticOp=" + this.workflowDataSocSuccessStatisticOp + ", workflowDataSocFailureStatisticOp=" + this.workflowDataSocFailureStatisticOp + ", workflowAdHocTotalStatisticOp=" + this.workflowAdHocTotalStatisticOp + ", workflowAdHocSuccessStatisticOp=" + this.workflowAdHocSuccessStatisticOp + ", workflowAdHocFailureStatisticOp=" + this.workflowAdHocFailureStatisticOp + ", workflowDataSvcTotalStatisticOp=" + this.workflowDataSvcTotalStatisticOp + ", workflowDataSvcSuccessStatisticOp=" + this.workflowDataSvcSuccessStatisticOp + ", workflowDataSvcFailureStatisticOp=" + this.workflowDataSvcFailureStatisticOp + ", workflowDQCTotalStatisticOp=" + this.workflowDQCTotalStatisticOp + ", workflowDQCSuccessStatisticOp=" + this.workflowDQCSuccessStatisticOp + ", workflowDQCFailureStatisticOp=" + this.workflowDQCFailureStatisticOp + ", nodeMappings=" + this.nodeMappings + ")";
        }
    }

    public static class NodeMapping {
        private String projectName;
        private String workflowName;
        private String srcNodeId;
        private String srcNodeName;
        private String tgtNodeId;
        private String tgtNodeName;

        public static NodeMappingBuilder builder() {
            return new NodeMappingBuilder();
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public String getSrcNodeId() {
            return this.srcNodeId;
        }

        public String getSrcNodeName() {
            return this.srcNodeName;
        }

        public String getTgtNodeId() {
            return this.tgtNodeId;
        }

        public String getTgtNodeName() {
            return this.tgtNodeName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        public void setSrcNodeId(String srcNodeId) {
            this.srcNodeId = srcNodeId;
        }

        public void setSrcNodeName(String srcNodeName) {
            this.srcNodeName = srcNodeName;
        }

        public void setTgtNodeId(String tgtNodeId) {
            this.tgtNodeId = tgtNodeId;
        }

        public void setTgtNodeName(String tgtNodeName) {
            this.tgtNodeName = tgtNodeName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeMapping)) {
                return false;
            }
            NodeMapping other = (NodeMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            String this$workflowName = this.getWorkflowName();
            String other$workflowName = other.getWorkflowName();
            if (this$workflowName == null ? other$workflowName != null : !this$workflowName.equals(other$workflowName)) {
                return false;
            }
            String this$srcNodeId = this.getSrcNodeId();
            String other$srcNodeId = other.getSrcNodeId();
            if (this$srcNodeId == null ? other$srcNodeId != null : !this$srcNodeId.equals(other$srcNodeId)) {
                return false;
            }
            String this$srcNodeName = this.getSrcNodeName();
            String other$srcNodeName = other.getSrcNodeName();
            if (this$srcNodeName == null ? other$srcNodeName != null : !this$srcNodeName.equals(other$srcNodeName)) {
                return false;
            }
            String this$tgtNodeId = this.getTgtNodeId();
            String other$tgtNodeId = other.getTgtNodeId();
            if (this$tgtNodeId == null ? other$tgtNodeId != null : !this$tgtNodeId.equals(other$tgtNodeId)) {
                return false;
            }
            String this$tgtNodeName = this.getTgtNodeName();
            String other$tgtNodeName = other.getTgtNodeName();
            return !(this$tgtNodeName == null ? other$tgtNodeName != null : !this$tgtNodeName.equals(other$tgtNodeName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NodeMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            String $workflowName = this.getWorkflowName();
            result = result * 59 + ($workflowName == null ? 43 : $workflowName.hashCode());
            String $srcNodeId = this.getSrcNodeId();
            result = result * 59 + ($srcNodeId == null ? 43 : $srcNodeId.hashCode());
            String $srcNodeName = this.getSrcNodeName();
            result = result * 59 + ($srcNodeName == null ? 43 : $srcNodeName.hashCode());
            String $tgtNodeId = this.getTgtNodeId();
            result = result * 59 + ($tgtNodeId == null ? 43 : $tgtNodeId.hashCode());
            String $tgtNodeName = this.getTgtNodeName();
            result = result * 59 + ($tgtNodeName == null ? 43 : $tgtNodeName.hashCode());
            return result;
        }

        public String toString() {
            return "StatisticOp.NodeMapping(projectName=" + this.getProjectName() + ", workflowName=" + this.getWorkflowName() + ", srcNodeId=" + this.getSrcNodeId() + ", srcNodeName=" + this.getSrcNodeName() + ", tgtNodeId=" + this.getTgtNodeId() + ", tgtNodeName=" + this.getTgtNodeName() + ")";
        }

        public NodeMapping() {
        }

        public NodeMapping(String projectName, String workflowName, String srcNodeId, String srcNodeName, String tgtNodeId, String tgtNodeName) {
            this.projectName = projectName;
            this.workflowName = workflowName;
            this.srcNodeId = srcNodeId;
            this.srcNodeName = srcNodeName;
            this.tgtNodeId = tgtNodeId;
            this.tgtNodeName = tgtNodeName;
        }

        public static class NodeMappingBuilder {
            private String projectName;
            private String workflowName;
            private String srcNodeId;
            private String srcNodeName;
            private String tgtNodeId;
            private String tgtNodeName;

            NodeMappingBuilder() {
            }

            public NodeMappingBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public NodeMappingBuilder workflowName(String workflowName) {
                this.workflowName = workflowName;
                return this;
            }

            public NodeMappingBuilder srcNodeId(String srcNodeId) {
                this.srcNodeId = srcNodeId;
                return this;
            }

            public NodeMappingBuilder srcNodeName(String srcNodeName) {
                this.srcNodeName = srcNodeName;
                return this;
            }

            public NodeMappingBuilder tgtNodeId(String tgtNodeId) {
                this.tgtNodeId = tgtNodeId;
                return this;
            }

            public NodeMappingBuilder tgtNodeName(String tgtNodeName) {
                this.tgtNodeName = tgtNodeName;
                return this;
            }

            public NodeMapping build() {
                return new NodeMapping(this.projectName, this.workflowName, this.srcNodeId, this.srcNodeName, this.tgtNodeId, this.tgtNodeName);
            }

            public String toString() {
                return "StatisticOp.NodeMapping.NodeMappingBuilder(projectName=" + this.projectName + ", workflowName=" + this.workflowName + ", srcNodeId=" + this.srcNodeId + ", srcNodeName=" + this.srcNodeName + ", tgtNodeId=" + this.tgtNodeId + ", tgtNodeName=" + this.tgtNodeName + ")";
            }
        }
    }
}

