/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowResourceSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowResourceSheetProperties.class);
    private Map<WorkflowResourceSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowResourceSheetColumn, Integer>();
    private Map<WorkflowResourceSheetColumn, Object> propertyValueMap = new HashMap<WorkflowResourceSheetColumn, Object>();

    public WorkflowResourceSheetProperties() {
        for (WorkflowResourceSheetColumn column : WorkflowResourceSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowResourceSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowResourceSheetColumn column = WorkflowResourceSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowResourceSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowResourceSheetColumn column = WorkflowResourceSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowResourceSheetColumn::getIsForExcel).map(WorkflowResourceSheetColumn::getDescription).collect(Collectors.toList());
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowResourceSheetColumn::getIsForExcel).map(WorkflowResourceSheetColumn::getCanModify).collect(Collectors.toList());
    }

    @Override
    public List<String> getValuesForExcel() {
        ArrayList<String> values = new ArrayList<String>();
        this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowResourceSheetColumn::getIsForExcel).forEach(property -> {
            if (ObjectUtils.isEmpty((Object)this.propertyValueMap.get(property))) {
                values.add("");
            } else {
                values.add(String.valueOf(this.propertyValueMap.get(property)));
            }
        });
        return values;
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public Integer getPropertyIndex(WorkflowResourceSheetColumn column) {
        if (this.propertyIndexMap.containsKey((Object)column)) {
            return this.propertyIndexMap.get((Object)column);
        }
        return null;
    }

    public Object getPropertyValue(WorkflowResourceSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column)) {
            return this.propertyValueMap.get((Object)column);
        }
        return null;
    }

    public Boolean isPropertyValueValid(WorkflowResourceSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.isEmpty((Object)this.propertyValueMap.get((Object)column)) && !ObjectUtils.equals((Object)this.propertyValueMap.get((Object)column), (Object)StatisticsReportConstant.DO_NOT_MODIFY)) {
            return true;
        }
        return false;
    }

    public void setPropertyValue(Map<WorkflowResourceSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowResourceSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(WorkflowFileResource file) {
        this.propertyValueMap.put(WorkflowResourceSheetColumn.PROJECT_ID, file.getProjectId());
        this.propertyValueMap.put(WorkflowResourceSheetColumn.FILE_ID, file.getFileId());
        this.propertyValueMap.put(WorkflowResourceSheetColumn.NAME, file.getName());
        this.propertyValueMap.put(WorkflowResourceSheetColumn.ENGINE, null);
        this.propertyValueMap.put(WorkflowResourceSheetColumn.CATEGORY_VALUE, file.getFolder() != null ? StatisticsReportConstant.FOLDER_PATH_DELIMITER + file.getFolder() : StatisticsReportConstant.FOLDER_PATH_DELIMITER);
        this.propertyValueMap.put(WorkflowResourceSheetColumn.FILE_TYPE, file.getFileType());
        this.propertyValueMap.put(WorkflowResourceSheetColumn.PATH, file.getPath());
        this.propertyValueMap.put(WorkflowResourceSheetColumn.DESCRIPTION, file.getDescription());
    }

    public void setPropertyValue(List<String> propertyValueList) {
        for (WorkflowResourceSheetColumn column : this.propertyIndexMap.keySet()) {
            Integer sheetIndex = this.propertyIndexMap.get((Object)column);
            if (sheetIndex >= propertyValueList.size()) {
                this.propertyValueMap.put(column, null);
                continue;
            }
            this.propertyValueMap.put(column, propertyValueList.get(sheetIndex));
        }
    }

    public static enum WorkflowResourceSheetColumn {
        PROJECT_ID("\u9879\u76ee\u7a7a\u95f4ID", false, false, true),
        FILE_ID("ID", false, true, true),
        NAME("\u540d\u79f0", false, true, true),
        ENGINE("\u5f15\u64ce", false, false, true),
        FILE_TYPE("\u7c7b\u578b", false, true, true),
        CATEGORY_VALUE("\u8c03\u5ea6\u5f15\u64ce\u76ee\u5f55", false, true, true),
        PATH("\u5728\u5305\u5185\u7684\u76f8\u5bf9\u5b58\u50a8\u4f4d\u7f6e", false, false, true),
        DESCRIPTION("\u5907\u6ce8", false, true, true),
        EXTRA("\u6269\u5c55\u4fe1\u606f", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowResourceSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowResourceSheetColumn of(String colName) {
            for (WorkflowResourceSheetColumn column : WorkflowResourceSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

