/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRelationSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowRelationSheetProperties.class);
    private Map<WorkflowRelationSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowRelationSheetColumn, Integer>();
    private Map<WorkflowRelationSheetColumn, Object> propertyValueMap = new HashMap<WorkflowRelationSheetColumn, Object>();

    public WorkflowRelationSheetProperties() {
        for (WorkflowRelationSheetColumn column : WorkflowRelationSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowRelationSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowRelationSheetColumn column = WorkflowRelationSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowRelationSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowRelationSheetColumn column = WorkflowRelationSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return List.of();
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return List.of();
    }

    @Override
    public List<String> getValuesForExcel() {
        return List.of();
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public void setPropertyValue(Map<WorkflowRelationSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowRelationSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(Workflow wf, RelationPackage relation) {
        this.setPropertyValue(WorkflowRelationSheetColumn.PROJECT_ID, wf.getProjectId());
        this.setPropertyValue(WorkflowRelationSheetColumn.WORKFLOW_ID, wf.getWorkflowId());
        this.setPropertyValue(WorkflowRelationSheetColumn.RELATION_TYPE, relation.getReType().name());
        this.setPropertyValue(WorkflowRelationSheetColumn.CHILD_ID, relation.getTo());
        this.setPropertyValue(WorkflowRelationSheetColumn.PARENT_ID, relation.getFrom());
    }

    public static enum WorkflowRelationSheetColumn {
        PROJECT_ID("\u9879\u76ee\u7a7a\u95f4ID", false, false, true),
        WORKFLOW_ID("\u5de5\u4f5c\u6d41ID", false, false, true),
        RELATION_TYPE("\u5173\u7cfb\u7c7b\u578b", false, false, true),
        CHILD_ID("\u5b50\u5143\u7d20ID", false, false, true),
        PARENT_ID("\u7236\u5143\u7d20ID", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowRelationSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowRelationSheetColumn of(String colName) {
            for (WorkflowRelationSheetColumn column : WorkflowRelationSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

