/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowFunctionSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowFunctionSheetProperties.class);
    private Map<WorkflowFunctionSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowFunctionSheetColumn, Integer>();
    private Map<WorkflowFunctionSheetColumn, Object> propertyValueMap = new HashMap<WorkflowFunctionSheetColumn, Object>();

    public WorkflowFunctionSheetProperties() {
        for (WorkflowFunctionSheetColumn column : WorkflowFunctionSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowFunctionSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowFunctionSheetColumn column = WorkflowFunctionSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowFunctionSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowFunctionSheetColumn column = WorkflowFunctionSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowFunctionSheetColumn::getIsForExcel).map(WorkflowFunctionSheetColumn::getDescription).collect(Collectors.toList());
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowFunctionSheetColumn::getIsForExcel).map(WorkflowFunctionSheetColumn::getCanModify).collect(Collectors.toList());
    }

    @Override
    public List<String> getValuesForExcel() {
        ArrayList<String> values = new ArrayList<String>();
        this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowFunctionSheetColumn::getIsForExcel).forEach(property -> {
            if (ObjectUtils.isEmpty((Object)this.propertyValueMap.get(property))) {
                values.add("");
            } else {
                values.add(String.valueOf(this.propertyValueMap.get(property)));
            }
        });
        return values;
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public Integer getPropertyIndex(WorkflowFunctionSheetColumn column) {
        if (this.propertyIndexMap.containsKey((Object)column)) {
            return this.propertyIndexMap.get((Object)column);
        }
        return null;
    }

    public Object getPropertyValue(WorkflowFunctionSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column)) {
            return this.propertyValueMap.get((Object)column);
        }
        return null;
    }

    public Boolean isPropertyValueValid(WorkflowFunctionSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.isEmpty((Object)this.propertyValueMap.get((Object)column)) && !ObjectUtils.equals((Object)this.propertyValueMap.get((Object)column), (Object)StatisticsReportConstant.DO_NOT_MODIFY)) {
            return true;
        }
        return false;
    }

    public void setPropertyValue(Map<WorkflowFunctionSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowFunctionSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(WorkflowFunctionResource func) {
        this.setPropertyValue(WorkflowFunctionSheetColumn.FUNCTION_ID, func.getFunctionId());
        this.setPropertyValue(WorkflowFunctionSheetColumn.PROJECT_ID, func.getProjectId());
        this.setPropertyValue(WorkflowFunctionSheetColumn.NAME, func.getName());
        this.setPropertyValue(WorkflowFunctionSheetColumn.SCRIPT, func.getScript());
        this.setPropertyValue(WorkflowFunctionSheetColumn.TYPE, func.getType());
        this.setPropertyValue(WorkflowFunctionSheetColumn.CLASS_NAME, func.getClassName());
        this.setPropertyValue(WorkflowFunctionSheetColumn.RUNTIME_RESOURCE, func.getRuntimeResource());
        this.setPropertyValue(WorkflowFunctionSheetColumn.FILE_RESOURCES, func.getFileResources());
        this.setPropertyValue(WorkflowFunctionSheetColumn.ARM_RESOURCE, func.getArmResource());
        this.setPropertyValue(WorkflowFunctionSheetColumn.USAGE_DESCRIPTION, func.getUsageDescription());
        this.setPropertyValue(WorkflowFunctionSheetColumn.ARGUMENTS_DESCRIPTION, func.getArgumentsDescription());
        this.setPropertyValue(WorkflowFunctionSheetColumn.RETURN_VALUE_DESCRIPTION, func.getReturnValueDescription());
        this.setPropertyValue(WorkflowFunctionSheetColumn.USAGE_EXAMPLE, func.getUsageExample());
        this.setPropertyValue(WorkflowFunctionSheetColumn.EMBEDDED_CODE_TYPE, func.getEmbeddedCodeType());
        this.setPropertyValue(WorkflowFunctionSheetColumn.EMBEDDED_RESOURCE_TYPE, func.getEmbeddedResourceType());
        this.setPropertyValue(WorkflowFunctionSheetColumn.EMBEDDED_CODE, func.getEmbeddedCode());
        this.setPropertyValue(WorkflowFunctionSheetColumn.ENGINE, null);
        this.setPropertyValue(WorkflowFunctionSheetColumn.CATEGORY_VALUE, null);
    }

    public void setPropertyValue(List<String> propertyValueList) {
        for (WorkflowFunctionSheetColumn column : this.propertyIndexMap.keySet()) {
            Integer sheetIndex = this.propertyIndexMap.get((Object)column);
            if (sheetIndex >= propertyValueList.size()) {
                this.propertyValueMap.put(column, null);
                continue;
            }
            this.propertyValueMap.put(column, propertyValueList.get(sheetIndex));
        }
    }

    public static enum WorkflowFunctionSheetColumn {
        FUNCTION_ID("ID", false, true, true),
        PROJECT_ID("\u9879\u76ee\u7a7a\u95f4ID", false, false, true),
        NAME("\u540d\u79f0", false, true, true),
        SCRIPT("\u811a\u672c", false, false, true),
        TYPE("\u7c7b\u578b", false, true, true),
        CLASS_NAME("\u7c7b\u540d", false, false, true),
        RUNTIME_RESOURCE("\u8fd0\u884c\u65f6Resource", false, false, true),
        FILE_RESOURCES("\u6587\u4ef6Resource", false, false, true),
        ARM_RESOURCE("ARM Resource", false, false, true),
        USAGE_DESCRIPTION("\u4f7f\u7528\u8bf4\u660e", false, false, true),
        ARGUMENTS_DESCRIPTION("\u53c2\u6570\u8bf4\u660e", false, false, true),
        RETURN_VALUE_DESCRIPTION("\u8fd4\u56de\u503c\u8bf4\u660e", false, false, true),
        USAGE_EXAMPLE("\u4f7f\u7528\u793a\u4f8b", false, false, true),
        EMBEDDED_CODE_TYPE("\u5185\u5d4c\u4ee3\u7801\u7c7b\u578b", false, false, true),
        EMBEDDED_RESOURCE_TYPE("\u5185\u5d4cResource\u7c7b\u578b", false, false, true),
        EMBEDDED_CODE("\u5185\u5d4c\u4ee3\u7801", false, false, true),
        ENGINE("\u5f15\u64ce", false, false, true),
        CATEGORY_VALUE("\u76ee\u5f55", false, false, true),
        EXTRA("\u6269\u5c55\u4fe1\u606f", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowFunctionSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowFunctionSheetColumn of(String colName) {
            for (WorkflowFunctionSheetColumn column : WorkflowFunctionSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

