/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.api.constant.report;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowDatasourceSheetProperties
extends AbstractSheetProperties {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDatasourceSheetProperties.class);
    private Map<WorkflowDatasourceSheetColumn, Integer> propertyIndexMap = new HashMap<WorkflowDatasourceSheetColumn, Integer>();
    private Map<WorkflowDatasourceSheetColumn, Object> propertyValueMap = new HashMap<WorkflowDatasourceSheetColumn, Object>();

    public WorkflowDatasourceSheetProperties() {
        for (WorkflowDatasourceSheetColumn column : WorkflowDatasourceSheetColumn.values()) {
            this.propertyIndexMap.put(column, column.ordinal());
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowDatasourceSheetProperties(List<String> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            WorkflowDatasourceSheetColumn column = WorkflowDatasourceSheetColumn.of(propertyList.get(i));
            if (column == null) {
                log.warn("pass column: {}", (Object)propertyList.get(i));
                continue;
            }
            this.propertyIndexMap.put(column, i);
            this.propertyValueMap.put(column, null);
        }
    }

    public WorkflowDatasourceSheetProperties(Map<String, Integer> propertyMap) {
        for (String columnName : propertyMap.keySet()) {
            WorkflowDatasourceSheetColumn column = WorkflowDatasourceSheetColumn.of(columnName);
            if (column == null) {
                log.warn("pass column: {}", (Object)columnName);
                continue;
            }
            this.propertyIndexMap.put(column, propertyMap.get(columnName));
            this.propertyValueMap.put(column, null);
        }
    }

    @Override
    public List<String> getHeadersForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowDatasourceSheetColumn::getIsForExcel).map(WorkflowDatasourceSheetColumn::getDescription).collect(Collectors.toList());
    }

    @Override
    public List<Boolean> getColumnsCanModifyForExcel() {
        return this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowDatasourceSheetColumn::getIsForExcel).map(WorkflowDatasourceSheetColumn::getCanModify).collect(Collectors.toList());
    }

    @Override
    public List<String> getValuesForExcel() {
        ArrayList<String> values = new ArrayList<String>();
        this.propertyIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).filter(WorkflowDatasourceSheetColumn::getIsForExcel).forEach(property -> {
            if (ObjectUtils.isEmpty((Object)this.propertyValueMap.get(property))) {
                values.add("");
            } else {
                values.add(String.valueOf(this.propertyValueMap.get(property)));
            }
        });
        return values;
    }

    @Override
    protected JSONObject getValuesToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.propertyValueMap.forEach((k, v) -> {
            if (k.getIsForSR().booleanValue()) {
                jsonObject.put((Object)k.name().toLowerCase(), v);
            }
        });
        return jsonObject;
    }

    public Integer getPropertyIndex(WorkflowDatasourceSheetColumn column) {
        if (this.propertyIndexMap.containsKey((Object)column)) {
            return this.propertyIndexMap.get((Object)column);
        }
        return null;
    }

    public Object getPropertyValue(WorkflowDatasourceSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column)) {
            return this.propertyValueMap.get((Object)column);
        }
        return null;
    }

    public Boolean isPropertyValueValid(WorkflowDatasourceSheetColumn column) {
        if (this.propertyValueMap.containsKey((Object)column) && !ObjectUtils.isEmpty((Object)this.propertyValueMap.get((Object)column)) && !ObjectUtils.equals((Object)this.propertyValueMap.get((Object)column), (Object)StatisticsReportConstant.DO_NOT_MODIFY)) {
            return true;
        }
        return false;
    }

    public void setPropertyValue(Map<WorkflowDatasourceSheetColumn, Object> propertyValueMap) {
        this.propertyValueMap = propertyValueMap;
    }

    public void setPropertyValue(WorkflowDatasourceSheetColumn column, Object value) {
        this.propertyValueMap.put(column, value);
    }

    public void setPropertyValue(WorkflowDatasource ds) {
        this.setPropertyValue(WorkflowDatasourceSheetColumn.DATASOURCE_ID, ds.getDatasourceId());
        this.setPropertyValue(WorkflowDatasourceSheetColumn.NAME, ds.getName());
        this.setPropertyValue(WorkflowDatasourceSheetColumn.TYPE, ds.getType());
        this.setPropertyValue(WorkflowDatasourceSheetColumn.VERSION, ds.getVersion());
        this.setPropertyValue(WorkflowDatasourceSheetColumn.PROPERTIES, JSONObject.toJSONString((Object)ds.getCustomProperties(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        this.setPropertyValue(WorkflowDatasourceSheetColumn.DESCRIPTION, null);
    }

    public void setPropertyValue(List<String> propertyValueList) {
        for (WorkflowDatasourceSheetColumn column : this.propertyIndexMap.keySet()) {
            Integer sheetIndex = this.propertyIndexMap.get((Object)column);
            if (sheetIndex >= propertyValueList.size()) {
                this.propertyValueMap.put(column, null);
                continue;
            }
            this.propertyValueMap.put(column, propertyValueList.get(sheetIndex));
        }
    }

    public static enum WorkflowDatasourceSheetColumn {
        DATASOURCE_ID("ID", false, true, true),
        NAME("\u540d\u79f0", false, true, true),
        TYPE("\u7c7b\u578b", false, true, true),
        VERSION("\u7248\u672c", false, true, true),
        PROPERTIES("\u5c5e\u6027", false, true, true),
        DESCRIPTION("\u5907\u6ce8", false, true, false),
        EXTRA("\u6269\u5c55\u4fe1\u606f", false, false, true);

        private String description;
        private Boolean canModify;
        private Boolean isForExcel;
        private Boolean isForSR;

        private WorkflowDatasourceSheetColumn(String description, Boolean canModify, Boolean isForExcel, Boolean isForSR) {
            this.description = description;
            this.canModify = canModify;
            this.isForExcel = isForExcel;
            this.isForSR = isForSR;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getCanModify() {
            return this.canModify;
        }

        public Boolean getIsForExcel() {
            return this.isForExcel;
        }

        public Boolean getIsForSR() {
            return this.isForSR;
        }

        public static WorkflowDatasourceSheetColumn of(String colName) {
            for (WorkflowDatasourceSheetColumn column : WorkflowDatasourceSheetColumn.values()) {
                if (column.getDescription().equals(colName)) {
                    return column;
                }
                if (!column.name().equals(colName)) continue;
                return column;
            }
            return null;
        }
    }
}

