import { View, WebView } from '@tarojs/components';
import Taro from '@tarojs/taro';
import './AliyunCaptcha.scss';

export default function Index() {
  const webViewSrc = 'https://your-captcha-page/index.html';

  const handleWebViewMessage = (event) => {
    const captchaVerifyParam = event.detail.data;
    // 通过事件通道，触发在业务页面中监听的'getCaptchaVerifyParam'事件，并把验证参数发送至业务页面
    const eventChannel = Taro.getCurrentInstance().page.getOpenerEventChannel();
    eventChannel && eventChannel.emit('getCaptchaVerifyParam', captchaVerifyParam);
  };

  return <View>{webViewSrc && <WebView src={webViewSrc} onMessage={handleWebViewMessage} />}</View>;
}
