/*
 * Decompiled with CFR 0.152.
 */
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.Vector;
import org.apache.log4j.Logger;

public class jTPCCTData {
    protected int numWarehouses = 0;
    public static final int TT_NEW_ORDER = 0;
    public static final int TT_PAYMENT = 1;
    public static final int TT_ORDER_STATUS = 2;
    public static final int TT_STOCK_LEVEL = 3;
    public static final int TT_DELIVERY = 4;
    public static final int TT_DELIVERY_BG = 5;
    public static final int TT_NONE = 6;
    public static final int TT_DONE = 7;
    public static final String[] transTypeNames = new String[]{"NEW_ORDER", "PAYMENT", "ORDER_STATUS", "STOCK_LEVEL", "DELIVERY", "DELIVERY_BG", "NONE", "DONE"};
    public int sched_code;
    public long sched_fuzz;
    public jTPCCTData term_left;
    public jTPCCTData term_right;
    public int tree_height;
    private int transType;
    private long transDue;
    private long transStart;
    private long transEnd;
    private boolean transRbk;
    private String transError;
    private int terminalWarehouse = 0;
    private int terminalDistrict = 0;
    private NewOrderData newOrder = null;
    private PaymentData payment = null;
    private OrderStatusData orderStatus = null;
    private StockLevelData stockLevel = null;
    private DeliveryData delivery = null;
    private DeliveryBGData deliveryBG = null;
    private static Object traceLock = new Object();
    private StringBuffer resultSB = new StringBuffer();
    private Formatter resultFmt = new Formatter(this.resultSB);

    public void setNumWarehouses(int num) {
        this.numWarehouses = num;
    }

    public void setWarehouse(int warehouse) {
        this.terminalWarehouse = warehouse;
    }

    public int getWarehouse() {
        return this.terminalWarehouse;
    }

    public void setDistrict(int district) {
        this.terminalDistrict = district;
    }

    public int getDistrict() {
        return this.terminalDistrict;
    }

    public void execute(Logger log, jTPCCConnection db) throws Exception {
        this.transStart = System.currentTimeMillis();
        if (this.transDue == 0L) {
            this.transDue = this.transStart;
        }
        switch (this.transType) {
            case 0: {
                this.executeNewOrder(log, db);
                break;
            }
            case 1: {
                this.executePayment(log, db);
                break;
            }
            case 2: {
                this.executeOrderStatus(log, db);
                break;
            }
            case 3: {
                this.executeStockLevel(log, db);
                break;
            }
            case 4: {
                this.executeDelivery(log, db);
                break;
            }
            case 5: {
                this.executeDeliveryBG(log, db);
                break;
            }
            default: {
                throw new Exception("Unknown transType " + this.transType);
            }
        }
        this.transEnd = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceScreen(Logger log) throws Exception {
        StringBuffer sb = new StringBuffer();
        Formatter fmt = new Formatter(sb);
        StringBuffer[] screenSb = new StringBuffer[23];
        Formatter[] screenFmt = new Formatter[23];
        for (int i = 0; i < 23; ++i) {
            screenSb[i] = new StringBuffer();
            screenFmt[i] = new Formatter(screenSb[i]);
        }
        if (!log.isTraceEnabled()) {
            return;
        }
        if (this.transType < 0 || this.transType > 7) {
            throw new Exception("Unknown transType " + this.transType);
        }
        Object object = traceLock;
        synchronized (object) {
            fmt.format("==== %s %s ==== Terminal %d,%d =================================================", transTypeNames[this.transType], this.transEnd == 0L ? "INPUT" : "OUTPUT", this.terminalWarehouse, this.terminalDistrict);
            sb.setLength(79);
            log.trace((Object)sb.toString());
            sb.setLength(0);
            fmt.format("---- Due:   %s", this.transDue == 0L ? "N/A" : new Timestamp(this.transDue).toString());
            log.trace((Object)sb.toString());
            sb.setLength(0);
            fmt.format("---- Start: %s", this.transStart == 0L ? "N/A" : new Timestamp(this.transStart).toString());
            log.trace((Object)sb.toString());
            sb.setLength(0);
            fmt.format("---- End:   %s", this.transEnd == 0L ? "N/A" : new Timestamp(this.transEnd).toString());
            log.trace((Object)sb.toString());
            sb.setLength(0);
            if (this.transError != null) {
                fmt.format("#### ERROR: %s", this.transError);
                log.trace((Object)sb.toString());
                sb.setLength(0);
            }
            log.trace((Object)"-------------------------------------------------------------------------------");
            switch (this.transType) {
                case 0: {
                    this.traceNewOrder(log, screenFmt);
                    break;
                }
                case 1: {
                    this.tracePayment(log, screenFmt);
                    break;
                }
                case 2: {
                    this.traceOrderStatus(log, screenFmt);
                    break;
                }
                case 3: {
                    this.traceStockLevel(log, screenFmt);
                    break;
                }
                case 4: {
                    this.traceDelivery(log, screenFmt);
                    break;
                }
                case 5: {
                    this.traceDeliveryBG(log, screenFmt);
                    break;
                }
                default: {
                    throw new Exception("Unknown transType " + this.transType);
                }
            }
            for (int i = 0; i < 23; ++i) {
                if (screenSb[i].length() > 79) {
                    screenSb[i].setLength(79);
                }
                log.trace((Object)screenSb[i].toString());
            }
            log.trace((Object)"-------------------------------------------------------------------------------");
            log.trace((Object)"");
        }
    }

    public String resultLine(long sessionStart) {
        this.resultFmt.format("%d,%d,%d,%s,%d,%d,%d\n", this.transEnd - sessionStart, this.transEnd - this.transDue, this.transEnd - this.transStart, transTypeNames[this.transType], this.transRbk ? 1 : 0, this.transType == 5 ? this.getSkippedDeliveries() : 0, this.transError == null ? 0 : 1);
        String line = this.resultSB.toString();
        this.resultSB.setLength(0);
        return line;
    }

    public void generateNewOrder(Logger log, jTPCCRandom rnd, long due) {
        int i;
        this.transType = 0;
        this.transDue = due;
        this.transStart = 0L;
        this.transEnd = 0L;
        this.transRbk = false;
        this.transError = null;
        this.newOrder = new NewOrderData();
        this.payment = null;
        this.orderStatus = null;
        this.stockLevel = null;
        this.delivery = null;
        this.deliveryBG = null;
        this.newOrder.w_id = this.terminalWarehouse;
        this.newOrder.d_id = rnd.nextInt(1, 10);
        this.newOrder.c_id = rnd.getCustomerID();
        int o_ol_cnt = rnd.nextInt(5, 15);
        for (i = 0; i < o_ol_cnt; ++i) {
            this.newOrder.ol_i_id[i] = rnd.getItemID();
            this.newOrder.ol_supply_w_id[i] = rnd.nextInt(1, 100) <= 99 ? this.terminalWarehouse : rnd.nextInt(1, this.numWarehouses);
            this.newOrder.ol_quantity[i] = rnd.nextInt(1, 10);
        }
        if (rnd.nextInt(1, 100) == 1) {
            int n = i - 1;
            this.newOrder.ol_i_id[n] = this.newOrder.ol_i_id[n] + rnd.nextInt(1, 9) * 1000000;
            this.transRbk = true;
        }
        while (i < 15) {
            this.newOrder.ol_i_id[i] = 0;
            this.newOrder.ol_supply_w_id[i] = 0;
            this.newOrder.ol_quantity[i] = 0;
            ++i;
        }
    }

    private void executeNewOrder(Logger log, jTPCCConnection db) throws Exception {
        int ol_cnt;
        int o_all_local = 1;
        double total_amount = 0.0;
        int[] ol_seq = new int[15];
        long o_entry_d = System.currentTimeMillis();
        this.newOrder.o_entry_d = new Timestamp(o_entry_d).toString();
        for (ol_cnt = 0; ol_cnt < 15 && this.newOrder.ol_i_id[ol_cnt] != 0; ++ol_cnt) {
            ol_seq[ol_cnt] = ol_cnt;
            if (this.newOrder.ol_supply_w_id[ol_cnt] == this.newOrder.w_id) continue;
            o_all_local = 0;
        }
        for (int x = 0; x < ol_cnt - 1; ++x) {
            for (int y = x + 1; y < ol_cnt; ++y) {
                int tmp;
                if (this.newOrder.ol_supply_w_id[ol_seq[y]] < this.newOrder.ol_supply_w_id[ol_seq[x]]) {
                    tmp = ol_seq[x];
                    ol_seq[x] = ol_seq[y];
                    ol_seq[y] = tmp;
                    continue;
                }
                if (this.newOrder.ol_supply_w_id[ol_seq[y]] != this.newOrder.ol_supply_w_id[ol_seq[x]] || this.newOrder.ol_i_id[ol_seq[y]] >= this.newOrder.ol_i_id[ol_seq[x]]) continue;
                tmp = ol_seq[x];
                ol_seq[x] = ol_seq[y];
                ol_seq[y] = tmp;
            }
        }
        this.newOrder.o_ol_cnt = ol_cnt;
        try {
            PreparedStatement stmt = db.stmtNewOrderSelectDist;
            stmt.setInt(1, this.newOrder.w_id);
            stmt.setInt(2, this.newOrder.d_id);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                throw new SQLException("District for W_ID=" + this.newOrder.w_id + " D_ID=" + this.newOrder.d_id + " not found");
            }
            this.newOrder.d_tax = rs.getDouble("d_tax");
            int o_id = this.newOrder.o_id = rs.getInt("d_next_o_id");
            rs.close();
            stmt = db.stmtNewOrderSelectWhseCust;
            stmt.setInt(1, this.newOrder.w_id);
            stmt.setInt(2, this.newOrder.d_id);
            stmt.setInt(3, this.newOrder.c_id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                throw new SQLException("Warehouse or Customer for W_ID=" + this.newOrder.w_id + " D_ID=" + this.newOrder.d_id + " C_ID=" + this.newOrder.c_id + " not found");
            }
            this.newOrder.w_tax = rs.getDouble("w_tax");
            this.newOrder.c_last = rs.getString("c_last");
            this.newOrder.c_credit = rs.getString("c_credit");
            this.newOrder.c_discount = rs.getDouble("c_discount");
            rs.close();
            stmt = db.stmtNewOrderUpdateDist;
            stmt.setInt(1, this.newOrder.w_id);
            stmt.setInt(2, this.newOrder.d_id);
            stmt.executeUpdate();
            stmt = db.stmtNewOrderInsertOrder;
            stmt.setInt(1, o_id);
            stmt.setInt(2, this.newOrder.d_id);
            stmt.setInt(3, this.newOrder.w_id);
            stmt.setInt(4, this.newOrder.c_id);
            stmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            stmt.setInt(6, ol_cnt);
            stmt.setInt(7, o_all_local);
            stmt.executeUpdate();
            stmt = db.stmtNewOrderInsertNewOrder;
            stmt.setInt(1, o_id);
            stmt.setInt(2, this.newOrder.d_id);
            stmt.setInt(3, this.newOrder.w_id);
            stmt.executeUpdate();
            PreparedStatement insertOrderLineBatch = db.stmtNewOrderInsertOrderLine;
            PreparedStatement updateStockBatch = db.stmtNewOrderUpdateStock;
            for (int i = 0; i < ol_cnt; ++i) {
                int ol_number = i + 1;
                int seq = ol_seq[i];
                stmt = db.stmtNewOrderSelectItem;
                stmt.setInt(1, this.newOrder.ol_i_id[seq]);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    if (this.transRbk && (this.newOrder.ol_i_id[seq] < 1 || this.newOrder.ol_i_id[seq] > 100000)) {
                        insertOrderLineBatch.executeBatch();
                        insertOrderLineBatch.clearBatch();
                        updateStockBatch.executeBatch();
                        updateStockBatch.clearBatch();
                        db.rollback();
                        this.newOrder.total_amount = total_amount;
                        this.newOrder.execution_status = new String("Item number is not valid");
                        return;
                    }
                    throw new Exception("ITEM " + this.newOrder.ol_i_id[seq] + " not fount");
                }
                this.newOrder.i_name[seq] = rs.getString("i_name");
                this.newOrder.i_price[seq] = rs.getDouble("i_price");
                String i_data = rs.getString("i_data");
                rs.close();
                stmt = db.stmtNewOrderSelectStock;
                stmt.setInt(1, this.newOrder.ol_supply_w_id[seq]);
                stmt.setInt(2, this.newOrder.ol_i_id[seq]);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new Exception("STOCK with S_W_ID=" + this.newOrder.ol_supply_w_id[seq] + " S_I_ID=" + this.newOrder.ol_i_id[seq] + " not fount");
                }
                this.newOrder.s_quantity[seq] = rs.getInt("s_quantity");
                this.newOrder.ol_amount[seq] = this.newOrder.i_price[seq] * (double)this.newOrder.ol_quantity[seq];
                this.newOrder.brand_generic[seq] = i_data.contains("ORIGINAL") && rs.getString("s_data").contains("ORIGINAL") ? new String("B") : new String("G");
                total_amount += this.newOrder.ol_amount[seq] * (1.0 - this.newOrder.c_discount) * (1.0 + this.newOrder.w_tax + this.newOrder.d_tax);
                if (this.newOrder.s_quantity[seq] >= this.newOrder.ol_quantity[seq] + 10) {
                    updateStockBatch.setInt(1, this.newOrder.s_quantity[seq] - this.newOrder.ol_quantity[seq]);
                } else {
                    updateStockBatch.setInt(1, this.newOrder.s_quantity[seq] + 91);
                }
                updateStockBatch.setInt(2, this.newOrder.ol_quantity[seq]);
                if (this.newOrder.ol_supply_w_id[seq] == this.newOrder.w_id) {
                    updateStockBatch.setInt(3, 0);
                } else {
                    updateStockBatch.setInt(3, 1);
                }
                updateStockBatch.setInt(4, this.newOrder.ol_supply_w_id[seq]);
                updateStockBatch.setInt(5, this.newOrder.ol_i_id[seq]);
                updateStockBatch.addBatch();
                insertOrderLineBatch.setInt(1, o_id);
                insertOrderLineBatch.setInt(2, this.newOrder.d_id);
                insertOrderLineBatch.setInt(3, this.newOrder.w_id);
                insertOrderLineBatch.setInt(4, ol_number);
                insertOrderLineBatch.setInt(5, this.newOrder.ol_i_id[seq]);
                insertOrderLineBatch.setInt(6, this.newOrder.ol_supply_w_id[seq]);
                insertOrderLineBatch.setInt(7, this.newOrder.ol_quantity[seq]);
                insertOrderLineBatch.setDouble(8, this.newOrder.ol_amount[seq]);
                switch (this.newOrder.d_id) {
                    case 1: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_01"));
                        break;
                    }
                    case 2: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_02"));
                        break;
                    }
                    case 3: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_03"));
                        break;
                    }
                    case 4: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_04"));
                        break;
                    }
                    case 5: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_05"));
                        break;
                    }
                    case 6: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_06"));
                        break;
                    }
                    case 7: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_07"));
                        break;
                    }
                    case 8: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_08"));
                        break;
                    }
                    case 9: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_09"));
                        break;
                    }
                    case 10: {
                        insertOrderLineBatch.setString(9, rs.getString("s_dist_10"));
                    }
                }
                insertOrderLineBatch.addBatch();
            }
            rs.close();
            updateStockBatch.executeBatch();
            updateStockBatch.clearBatch();
            insertOrderLineBatch.executeBatch();
            insertOrderLineBatch.clearBatch();
            this.newOrder.execution_status = new String("Order placed");
            this.newOrder.total_amount = total_amount;
            db.commit();
        }
        catch (SQLException se) {
            log.error((Object)"Unexpected SQLException in NEW_ORDER");
            for (SQLException x = se; x != null; x = x.getNextException()) {
                log.error((Object)x.getMessage());
            }
            se.printStackTrace();
            try {
                db.stmtNewOrderUpdateStock.clearBatch();
                db.stmtNewOrderInsertOrderLine.clearBatch();
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
        }
        catch (Exception e) {
            try {
                db.stmtNewOrderUpdateStock.clearBatch();
                db.stmtNewOrderInsertOrderLine.clearBatch();
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
            throw e;
        }
    }

    private void traceNewOrder(Logger log, Formatter[] fmt) {
        fmt[0].format("                                    New Order", new Object[0]);
        if (this.transEnd == 0L) {
            fmt[1].format("Warehouse: %6d  District: %2d                       Date:", this.newOrder.w_id, this.newOrder.d_id);
            fmt[2].format("Customer:    %4d  Name:                    Credit:      %%Disc:", this.newOrder.c_id);
            fmt[3].format("Order Number:            Number of Lines:           W_tax:         D_tax:", new Object[0]);
            fmt[5].format("Supp_W   Item_Id  Item Name                  Qty  Stock  B/G  Price    Amount", new Object[0]);
            for (int i = 0; i < 15; ++i) {
                if (this.newOrder.ol_i_id[i] != 0) {
                    fmt[6 + i].format("%6d   %6d                              %2d", this.newOrder.ol_supply_w_id[i], this.newOrder.ol_i_id[i], this.newOrder.ol_quantity[i]);
                    continue;
                }
                fmt[6 + i].format("______   ______                              __", new Object[0]);
            }
            fmt[21].format("Execution Status:                                             Total:  $", new Object[0]);
        } else {
            fmt[1].format("Warehouse: %6d  District: %2d                       Date: %19.19s", this.newOrder.w_id, this.newOrder.d_id, this.newOrder.o_entry_d);
            fmt[2].format("Customer:    %4d  Name: %-16.16s   Credit: %2.2s   %%Disc: %5.2f", this.newOrder.c_id, this.newOrder.c_last, this.newOrder.c_credit, this.newOrder.c_discount * 100.0);
            fmt[3].format("Order Number:  %8d  Number of Lines: %2d        W_tax: %5.2f   D_tax: %5.2f", this.newOrder.o_id, this.newOrder.o_ol_cnt, this.newOrder.w_tax * 100.0, this.newOrder.d_tax * 100.0);
            fmt[5].format("Supp_W   Item_Id  Item Name                  Qty  Stock  B/G  Price    Amount", new Object[0]);
            for (int i = 0; i < 15; ++i) {
                if (this.newOrder.ol_i_id[i] == 0) continue;
                fmt[6 + i].format("%6d   %6d   %-24.24s   %2d    %3d    %1.1s   $%6.2f  $%7.2f", this.newOrder.ol_supply_w_id[i], this.newOrder.ol_i_id[i], this.newOrder.i_name[i], this.newOrder.ol_quantity[i], this.newOrder.s_quantity[i], this.newOrder.brand_generic[i], this.newOrder.i_price[i], this.newOrder.ol_amount[i]);
            }
            fmt[21].format("Execution Status: %-24.24s                    Total:  $%8.2f", this.newOrder.execution_status, this.newOrder.total_amount);
        }
    }

    public void generatePayment(Logger log, jTPCCRandom rnd, long due) {
        this.transType = 1;
        this.transDue = due;
        this.transStart = 0L;
        this.transEnd = 0L;
        this.transRbk = false;
        this.transError = null;
        this.newOrder = null;
        this.payment = new PaymentData();
        this.orderStatus = null;
        this.stockLevel = null;
        this.delivery = null;
        this.deliveryBG = null;
        this.payment.w_id = this.terminalWarehouse;
        this.payment.d_id = rnd.nextInt(1, 10);
        this.payment.c_w_id = this.payment.w_id;
        this.payment.c_d_id = this.payment.d_id;
        if (rnd.nextInt(1, 100) > 85) {
            this.payment.c_d_id = rnd.nextInt(1, 10);
            while (this.payment.c_w_id == this.payment.w_id && this.numWarehouses > 1) {
                this.payment.c_w_id = rnd.nextInt(1, this.numWarehouses);
            }
        }
        if (rnd.nextInt(1, 100) <= 60) {
            this.payment.c_last = rnd.getCLast();
            this.payment.c_id = 0;
        } else {
            this.payment.c_last = null;
            this.payment.c_id = rnd.getCustomerID();
        }
        this.payment.h_amount = (double)rnd.nextLong(100L, 500000L) / 100.0;
    }

    private void executePayment(Logger log, jTPCCConnection db) throws Exception {
        Vector<Integer> c_id_list = new Vector<Integer>();
        long h_date = System.currentTimeMillis();
        try {
            PreparedStatement stmt = db.stmtPaymentUpdateDistrict;
            stmt.setDouble(1, this.payment.h_amount);
            stmt.setInt(2, this.payment.w_id);
            stmt.setInt(3, this.payment.d_id);
            stmt.executeUpdate();
            stmt = db.stmtPaymentSelectDistrict;
            stmt.setInt(1, this.payment.w_id);
            stmt.setInt(2, this.payment.d_id);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                throw new Exception("District for W_ID=" + this.payment.w_id + " D_ID=" + this.payment.d_id + " not found");
            }
            this.payment.d_name = rs.getString("d_name");
            this.payment.d_street_1 = rs.getString("d_street_1");
            this.payment.d_street_2 = rs.getString("d_street_2");
            this.payment.d_city = rs.getString("d_city");
            this.payment.d_state = rs.getString("d_state");
            this.payment.d_zip = rs.getString("d_zip");
            rs.close();
            stmt = db.stmtPaymentUpdateWarehouse;
            stmt.setDouble(1, this.payment.h_amount);
            stmt.setInt(2, this.payment.w_id);
            stmt.executeUpdate();
            stmt = db.stmtPaymentSelectWarehouse;
            stmt.setInt(1, this.payment.w_id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                throw new Exception("Warehouse for W_ID=" + this.payment.w_id + " not found");
            }
            this.payment.w_name = rs.getString("w_name");
            this.payment.w_street_1 = rs.getString("w_street_1");
            this.payment.w_street_2 = rs.getString("w_street_2");
            this.payment.w_city = rs.getString("w_city");
            this.payment.w_state = rs.getString("w_state");
            this.payment.w_zip = rs.getString("w_zip");
            rs.close();
            if (this.payment.c_last != null) {
                stmt = db.stmtPaymentSelectCustomerListByLast;
                stmt.setInt(1, this.payment.c_w_id);
                stmt.setInt(2, this.payment.c_d_id);
                stmt.setString(3, this.payment.c_last);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    c_id_list.add(rs.getInt("c_id"));
                }
                rs.close();
                if (c_id_list.size() == 0) {
                    throw new Exception("Customer(s) for C_W_ID=" + this.payment.c_w_id + " C_D_ID=" + this.payment.c_d_id + " C_LAST=" + this.payment.c_last + " not found");
                }
                this.payment.c_id = (Integer)c_id_list.get((c_id_list.size() + 1) / 2 - 1);
            }
            stmt = db.stmtPaymentSelectCustomer;
            stmt.setInt(1, this.payment.c_w_id);
            stmt.setInt(2, this.payment.c_d_id);
            stmt.setInt(3, this.payment.c_id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Customer for C_W_ID=" + this.payment.c_w_id + " C_D_ID=" + this.payment.c_d_id + " C_ID=" + this.payment.c_id + " not found");
            }
            this.payment.c_first = rs.getString("c_first");
            this.payment.c_middle = rs.getString("c_middle");
            if (this.payment.c_last == null) {
                this.payment.c_last = rs.getString("c_last");
            }
            this.payment.c_street_1 = rs.getString("c_street_1");
            this.payment.c_street_2 = rs.getString("c_street_2");
            this.payment.c_city = rs.getString("c_city");
            this.payment.c_state = rs.getString("c_state");
            this.payment.c_zip = rs.getString("c_zip");
            this.payment.c_phone = rs.getString("c_phone");
            this.payment.c_since = rs.getTimestamp("c_since").toString();
            this.payment.c_credit = rs.getString("c_credit");
            this.payment.c_credit_lim = rs.getDouble("c_credit_lim");
            this.payment.c_discount = rs.getDouble("c_discount");
            this.payment.c_balance = rs.getDouble("c_balance");
            this.payment.c_data = new String("");
            rs.close();
            this.payment.c_balance -= this.payment.h_amount;
            if (this.payment.c_credit.equals("GC")) {
                stmt = db.stmtPaymentUpdateCustomer;
                stmt.setDouble(1, this.payment.h_amount);
                stmt.setDouble(2, this.payment.h_amount);
                stmt.setInt(3, this.payment.c_w_id);
                stmt.setInt(4, this.payment.c_d_id);
                stmt.setInt(5, this.payment.c_id);
                stmt.executeUpdate();
            } else {
                stmt = db.stmtPaymentSelectCustomerData;
                stmt.setInt(1, this.payment.c_w_id);
                stmt.setInt(2, this.payment.c_d_id);
                stmt.setInt(3, this.payment.c_id);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new Exception("Customer.c_data for C_W_ID=" + this.payment.c_w_id + " C_D_ID=" + this.payment.c_d_id + " C_ID=" + this.payment.c_id + " not found");
                }
                this.payment.c_data = rs.getString("c_data");
                rs.close();
                stmt = db.stmtPaymentUpdateCustomerWithData;
                stmt.setDouble(1, this.payment.h_amount);
                stmt.setDouble(2, this.payment.h_amount);
                StringBuffer sbData = new StringBuffer();
                Formatter fmtData = new Formatter(sbData);
                fmtData.format("C_ID=%d C_D_ID=%d C_W_ID=%d D_ID=%d W_ID=%d H_AMOUNT=%.2f   ", this.payment.c_id, this.payment.c_d_id, this.payment.c_w_id, this.payment.d_id, this.payment.w_id, this.payment.h_amount);
                sbData.append(this.payment.c_data);
                if (sbData.length() > 500) {
                    sbData.setLength(500);
                }
                this.payment.c_data = sbData.toString();
                stmt.setString(3, this.payment.c_data);
                stmt.setInt(4, this.payment.c_w_id);
                stmt.setInt(5, this.payment.c_d_id);
                stmt.setInt(6, this.payment.c_id);
                stmt.executeUpdate();
            }
            stmt = db.stmtPaymentInsertHistory;
            stmt.setInt(1, this.payment.c_id);
            stmt.setInt(2, this.payment.c_d_id);
            stmt.setInt(3, this.payment.c_w_id);
            stmt.setInt(4, this.payment.d_id);
            stmt.setInt(5, this.payment.w_id);
            stmt.setTimestamp(6, new Timestamp(h_date));
            stmt.setDouble(7, this.payment.h_amount);
            stmt.setString(8, this.payment.w_name + "    " + this.payment.d_name);
            stmt.executeUpdate();
            this.payment.h_date = new Timestamp(h_date).toString();
            db.commit();
        }
        catch (SQLException se) {
            log.error((Object)"Unexpected SQLException in PAYMENT");
            for (SQLException x = se; x != null; x = x.getNextException()) {
                log.error((Object)x.getMessage());
            }
            se.printStackTrace();
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
        }
        catch (Exception e) {
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
            throw e;
        }
    }

    private void tracePayment(Logger log, Formatter[] fmt) {
        fmt[0].format("                                     Payment", new Object[0]);
        if (this.transEnd == 0L) {
            fmt[1].format("Date: ", new Object[0]);
            fmt[3].format("Warehouse: %6d                         District: %2d", this.payment.w_id, this.payment.d_id);
            if (this.payment.c_last == null) {
                fmt[8].format("Customer: %4d  Cust-Warehouse: %6d  Cust-District: %2d", this.payment.c_id, this.payment.c_w_id, this.payment.c_d_id);
                fmt[9].format("Name:                       ________________       Since:", new Object[0]);
            } else {
                fmt[8].format("Customer: ____  Cust-Warehouse: %6d  Cust-District: %2d", this.payment.c_w_id, this.payment.c_d_id);
                fmt[9].format("Name:                       %-16.16s       Since:", this.payment.c_last);
            }
            fmt[10].format("                                                   Credit:", new Object[0]);
            fmt[11].format("                                                   %%Disc:", new Object[0]);
            fmt[12].format("                                                   Phone:", new Object[0]);
            fmt[14].format("Amount Paid:          $%7.2f        New Cust-Balance:", this.payment.h_amount);
            fmt[15].format("Credit Limit:", new Object[0]);
            fmt[17].format("Cust-Data:", new Object[0]);
        } else {
            fmt[1].format("Date: %-19.19s", this.payment.h_date);
            fmt[3].format("Warehouse: %6d                         District: %2d", this.payment.w_id, this.payment.d_id);
            fmt[4].format("%-20.20s                      %-20.20s", this.payment.w_street_1, this.payment.d_street_1);
            fmt[5].format("%-20.20s                      %-20.20s", this.payment.w_street_2, this.payment.d_street_2);
            fmt[6].format("%-20.20s %2.2s %5.5s-%4.4s        %-20.20s %2.2s %5.5s-%4.4s", this.payment.w_city, this.payment.w_state, this.payment.w_zip.substring(0, 5), this.payment.w_zip.substring(5, 9), this.payment.d_city, this.payment.d_state, this.payment.d_zip.substring(0, 5), this.payment.d_zip.substring(5, 9));
            log.trace((Object)("w_zip=" + this.payment.w_zip + " d_zip=" + this.payment.d_zip));
            fmt[8].format("Customer: %4d  Cust-Warehouse: %6d  Cust-District: %2d", this.payment.c_id, this.payment.c_w_id, this.payment.c_d_id);
            fmt[9].format("Name:   %-16.16s %2.2s %-16.16s       Since:  %-10.10s", this.payment.c_first, this.payment.c_middle, this.payment.c_last, this.payment.c_since);
            fmt[10].format("        %-20.20s                       Credit: %2s", this.payment.c_street_1, this.payment.c_credit);
            fmt[11].format("        %-20.20s                       %%Disc:  %5.2f", this.payment.c_street_2, this.payment.c_discount * 100.0);
            fmt[12].format("        %-20.20s %2.2s %5.5s-%4.4s         Phone:  %6.6s-%3.3s-%3.3s-%4.4s", this.payment.c_city, this.payment.c_state, this.payment.c_zip.substring(0, 5), this.payment.c_zip.substring(5, 9), this.payment.c_phone.substring(0, 6), this.payment.c_phone.substring(6, 9), this.payment.c_phone.substring(9, 12), this.payment.c_phone.substring(12, 16));
            fmt[14].format("Amount Paid:          $%7.2f        New Cust-Balance: $%14.2f", this.payment.h_amount, this.payment.c_balance);
            fmt[15].format("Credit Limit:   $%13.2f", this.payment.c_credit_lim);
            if (this.payment.c_data.length() >= 200) {
                fmt[17].format("Cust-Data: %-50.50s", this.payment.c_data.substring(0, 50));
                fmt[18].format("           %-50.50s", this.payment.c_data.substring(50, 100));
                fmt[19].format("           %-50.50s", this.payment.c_data.substring(100, 150));
                fmt[20].format("           %-50.50s", this.payment.c_data.substring(150, 200));
            } else {
                fmt[17].format("Cust-Data:", new Object[0]);
            }
        }
    }

    public void generateOrderStatus(Logger log, jTPCCRandom rnd, long due) {
        this.transType = 2;
        this.transDue = due;
        this.transStart = 0L;
        this.transEnd = 0L;
        this.transRbk = false;
        this.transError = null;
        this.newOrder = null;
        this.payment = null;
        this.orderStatus = new OrderStatusData();
        this.stockLevel = null;
        this.delivery = null;
        this.deliveryBG = null;
        this.orderStatus.w_id = this.terminalWarehouse;
        this.orderStatus.d_id = rnd.nextInt(1, 10);
        if (rnd.nextInt(1, 100) <= 60) {
            this.orderStatus.c_id = 0;
            this.orderStatus.c_last = rnd.getCLast();
        } else {
            this.orderStatus.c_id = rnd.getCustomerID();
            this.orderStatus.c_last = null;
        }
    }

    private void executeOrderStatus(Logger log, jTPCCConnection db) throws Exception {
        Vector<Integer> c_id_list = new Vector<Integer>();
        int ol_idx = 0;
        try {
            ResultSet rs;
            PreparedStatement stmt;
            if (this.orderStatus.c_last != null) {
                stmt = db.stmtOrderStatusSelectCustomerListByLast;
                stmt.setInt(1, this.orderStatus.w_id);
                stmt.setInt(2, this.orderStatus.d_id);
                stmt.setString(3, this.orderStatus.c_last);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    c_id_list.add(rs.getInt("c_id"));
                }
                rs.close();
                if (c_id_list.size() == 0) {
                    throw new Exception("Customer(s) for C_W_ID=" + this.orderStatus.w_id + " C_D_ID=" + this.orderStatus.d_id + " C_LAST=" + this.orderStatus.c_last + " not found");
                }
                this.orderStatus.c_id = (Integer)c_id_list.get((c_id_list.size() + 1) / 2 - 1);
            }
            stmt = db.stmtOrderStatusSelectCustomer;
            stmt.setInt(1, this.orderStatus.w_id);
            stmt.setInt(2, this.orderStatus.d_id);
            stmt.setInt(3, this.orderStatus.c_id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Customer for C_W_ID=" + this.orderStatus.w_id + " C_D_ID=" + this.orderStatus.d_id + " C_ID=" + this.orderStatus.c_id + " not found");
            }
            this.orderStatus.c_first = rs.getString("c_first");
            this.orderStatus.c_middle = rs.getString("c_middle");
            if (this.orderStatus.c_last == null) {
                this.orderStatus.c_last = rs.getString("c_last");
            }
            this.orderStatus.c_balance = rs.getDouble("c_balance");
            rs.close();
            stmt = db.stmtOrderStatusSelectLastOrder;
            stmt.setInt(1, this.orderStatus.w_id);
            stmt.setInt(2, this.orderStatus.d_id);
            stmt.setInt(3, this.orderStatus.c_id);
            stmt.setInt(4, this.orderStatus.w_id);
            stmt.setInt(5, this.orderStatus.d_id);
            stmt.setInt(6, this.orderStatus.c_id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Last Order for W_ID=" + this.orderStatus.w_id + " D_ID=" + this.orderStatus.d_id + " C_ID=" + this.orderStatus.c_id + " not found");
            }
            this.orderStatus.o_id = rs.getInt("o_id");
            this.orderStatus.o_entry_d = rs.getTimestamp("o_entry_d").toString();
            this.orderStatus.o_carrier_id = rs.getInt("o_carrier_id");
            if (rs.wasNull()) {
                this.orderStatus.o_carrier_id = -1;
            }
            rs.close();
            stmt = db.stmtOrderStatusSelectOrderLine;
            stmt.setInt(1, this.orderStatus.w_id);
            stmt.setInt(2, this.orderStatus.d_id);
            stmt.setInt(3, this.orderStatus.o_id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.orderStatus.ol_i_id[ol_idx] = rs.getInt("ol_i_id");
                this.orderStatus.ol_supply_w_id[ol_idx] = rs.getInt("ol_supply_w_id");
                this.orderStatus.ol_quantity[ol_idx] = rs.getInt("ol_quantity");
                this.orderStatus.ol_amount[ol_idx] = rs.getDouble("ol_amount");
                Timestamp ol_delivery_d = rs.getTimestamp("ol_delivery_d");
                this.orderStatus.ol_delivery_d[ol_idx] = ol_delivery_d != null ? ol_delivery_d.toString() : null;
                ++ol_idx;
            }
            rs.close();
            while (ol_idx < 15) {
                this.orderStatus.ol_i_id[ol_idx] = 0;
                this.orderStatus.ol_supply_w_id[ol_idx] = 0;
                this.orderStatus.ol_quantity[ol_idx] = 0;
                this.orderStatus.ol_amount[ol_idx] = 0.0;
                this.orderStatus.ol_delivery_d[ol_idx] = null;
                ++ol_idx;
            }
            db.rollback();
        }
        catch (SQLException se) {
            log.error((Object)"Unexpected SQLException in ORDER_STATUS");
            for (SQLException x = se; x != null; x = x.getNextException()) {
                log.error((Object)x.getMessage());
            }
            se.printStackTrace();
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
        }
        catch (Exception e) {
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
            throw e;
        }
    }

    private void traceOrderStatus(Logger log, Formatter[] fmt) {
        fmt[0].format("                                  Order Status", new Object[0]);
        if (this.transEnd == 0L) {
            fmt[1].format("Warehouse: %6d   District: %2d", this.orderStatus.w_id, this.orderStatus.d_id);
            if (this.orderStatus.c_last == null) {
                fmt[2].format("Customer: %4d   Name:                     ________________", this.orderStatus.c_id);
            } else {
                fmt[2].format("Customer: ____   Name:                     %-16.16s", this.orderStatus.c_last);
            }
            fmt[3].format("Cust-Balance:", new Object[0]);
            fmt[5].format("Order-Number:            Entry-Date:                       Carrier-Number:", new Object[0]);
            fmt[6].format("Suppy-W      Item-Id     Qty    Amount        Delivery-Date", new Object[0]);
        } else {
            fmt[1].format("Warehouse: %6d   District: %2d", this.orderStatus.w_id, this.orderStatus.d_id);
            fmt[2].format("Customer: %4d   Name: %-16.16s %2.2s %-16.16s", this.orderStatus.c_id, this.orderStatus.c_first, this.orderStatus.c_middle, this.orderStatus.c_last);
            fmt[3].format("Cust-Balance: $%13.2f", this.orderStatus.c_balance);
            if (this.orderStatus.o_carrier_id >= 0) {
                fmt[5].format("Order-Number: %8d   Entry-Date: %-19.19s   Carrier-Number: %2d", this.orderStatus.o_id, this.orderStatus.o_entry_d, this.orderStatus.o_carrier_id);
            } else {
                fmt[5].format("Order-Number: %8d   Entry-Date: %-19.19s   Carrier-Number:", this.orderStatus.o_id, this.orderStatus.o_entry_d);
            }
            fmt[6].format("Suppy-W      Item-Id     Qty    Amount        Delivery-Date", new Object[0]);
            for (int i = 0; i < 15 && this.orderStatus.ol_i_id[i] > 0; ++i) {
                fmt[7 + i].format(" %6d      %6d     %3d     $%8.2f     %-10.10s", this.orderStatus.ol_supply_w_id[i], this.orderStatus.ol_i_id[i], this.orderStatus.ol_quantity[i], this.orderStatus.ol_amount[i], this.orderStatus.ol_delivery_d[i] == null ? "" : this.orderStatus.ol_delivery_d[i]);
            }
        }
    }

    public void generateStockLevel(Logger log, jTPCCRandom rnd, long due) {
        this.transType = 3;
        this.transDue = due;
        this.transStart = 0L;
        this.transEnd = 0L;
        this.transRbk = false;
        this.transError = null;
        this.newOrder = null;
        this.payment = null;
        this.orderStatus = null;
        this.stockLevel = new StockLevelData();
        this.delivery = null;
        this.deliveryBG = null;
        this.stockLevel.w_id = this.terminalWarehouse;
        this.stockLevel.d_id = this.terminalDistrict;
        this.stockLevel.threshold = rnd.nextInt(10, 20);
    }

    private void executeStockLevel(Logger log, jTPCCConnection db) throws Exception {
        try {
            PreparedStatement stmt = db.stmtStockLevelSelectLow;
            stmt.setInt(1, this.stockLevel.w_id);
            stmt.setInt(2, this.stockLevel.threshold);
            stmt.setInt(3, this.stockLevel.w_id);
            stmt.setInt(4, this.stockLevel.d_id);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Failed to get low-stock for W_ID=" + this.stockLevel.w_id + " D_ID=" + this.stockLevel.d_id);
            }
            this.stockLevel.low_stock = rs.getInt("low_stock");
            rs.close();
            db.rollback();
        }
        catch (SQLException se) {
            log.error((Object)"Unexpected SQLException in STOCK_LEVEL");
            for (SQLException x = se; x != null; x = x.getNextException()) {
                log.error((Object)x.getMessage());
            }
            se.printStackTrace();
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
        }
        catch (Exception e) {
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
            throw e;
        }
    }

    private void traceStockLevel(Logger log, Formatter[] fmt) {
        fmt[0].format("                                  Stock-Level", new Object[0]);
        fmt[1].format("Warehouse: %6d   District: %2d", this.stockLevel.w_id, this.stockLevel.d_id);
        fmt[3].format("Stock Level Threshold: %2d", this.stockLevel.threshold);
        if (this.transEnd == 0L) {
            fmt[5].format("Low Stock:", new Object[0]);
        } else {
            fmt[5].format("Low Stock: %3d", this.stockLevel.low_stock);
        }
    }

    public void generateDelivery(Logger log, jTPCCRandom rnd, long due) {
        this.transType = 4;
        this.transDue = due;
        this.transStart = 0L;
        this.transEnd = 0L;
        this.transRbk = false;
        this.transError = null;
        this.newOrder = null;
        this.payment = null;
        this.orderStatus = null;
        this.stockLevel = null;
        this.delivery = new DeliveryData();
        this.deliveryBG = null;
        this.delivery.w_id = this.terminalWarehouse;
        this.delivery.o_carrier_id = rnd.nextInt(1, 10);
        this.delivery.execution_status = null;
        this.delivery.deliveryBG = null;
    }

    private void executeDelivery(Logger log, jTPCCConnection db) {
        long now = System.currentTimeMillis();
        this.delivery.deliveryBG = new jTPCCTData();
        this.delivery.deliveryBG.generateDeliveryBG(this.delivery.w_id, now, new Timestamp(now).toString(), this);
        this.delivery.execution_status = new String("Delivery has been queued");
    }

    private void traceDelivery(Logger log, Formatter[] fmt) {
        fmt[0].format("                                     Delivery", new Object[0]);
        fmt[1].format("Warehouse: %6d", this.delivery.w_id);
        fmt[3].format("Carrier Number: %2d", this.delivery.o_carrier_id);
        if (this.transEnd == 0L) {
            fmt[5].format("Execution Status: ", new Object[0]);
        } else {
            fmt[5].format("Execution Status: %s", this.delivery.execution_status);
        }
    }

    public jTPCCTData getDeliveryBG() throws Exception {
        if (this.transType != 4) {
            throw new Exception("Not a DELIVERY");
        }
        if (this.delivery.deliveryBG == null) {
            throw new Exception("DELIVERY foreground not executed yet or background part already consumed");
        }
        jTPCCTData result = this.delivery.deliveryBG;
        this.delivery.deliveryBG = null;
        return result;
    }

    private void generateDeliveryBG(int w_id, long due, String ol_delivery_d, jTPCCTData parent) {
        this.numWarehouses = parent.numWarehouses;
        this.terminalWarehouse = parent.terminalWarehouse;
        this.terminalDistrict = parent.terminalDistrict;
        this.transType = 5;
        this.transDue = due;
        this.transStart = 0L;
        this.transEnd = 0L;
        this.transRbk = false;
        this.transError = null;
        this.newOrder = null;
        this.payment = null;
        this.orderStatus = null;
        this.stockLevel = null;
        this.delivery = null;
        this.deliveryBG = new DeliveryBGData();
        this.deliveryBG.w_id = parent.delivery.w_id;
        this.deliveryBG.o_carrier_id = parent.delivery.o_carrier_id;
        this.deliveryBG.ol_delivery_d = ol_delivery_d;
        this.deliveryBG.delivered_o_id = new int[10];
        for (int i = 0; i < 10; ++i) {
            this.deliveryBG.delivered_o_id[i] = -1;
        }
    }

    private void executeDeliveryBG(Logger log, jTPCCConnection db) throws Exception {
        long now = System.currentTimeMillis();
        try {
            for (int d_id = 1; d_id <= 10; ++d_id) {
                ResultSet rs;
                int o_id = -1;
                PreparedStatement stmt1 = db.stmtDeliveryBGSelectOldestNewOrder;
                PreparedStatement stmt2 = db.stmtDeliveryBGDeleteOldestNewOrder;
                while (o_id < 0) {
                    stmt1.setInt(1, this.deliveryBG.w_id);
                    stmt1.setInt(2, d_id);
                    rs = stmt1.executeQuery();
                    if (!rs.next()) {
                        rs.close();
                        break;
                    }
                    o_id = rs.getInt("no_o_id");
                    rs.close();
                    stmt2.setInt(1, this.deliveryBG.w_id);
                    stmt2.setInt(2, d_id);
                    stmt2.setInt(3, o_id);
                    int rc = stmt2.executeUpdate();
                    if (rc != 0) continue;
                    o_id = -1;
                    log.debug((Object)"Order is deleted by concurrent threads. Restart this transaction");
                    break;
                }
                if (o_id < 0) {
                    db.rollback();
                    continue;
                }
                stmt1 = db.stmtDeliveryBGUpdateOrder;
                stmt1.setInt(1, this.deliveryBG.o_carrier_id);
                stmt1.setInt(2, this.deliveryBG.w_id);
                stmt1.setInt(3, d_id);
                stmt1.setInt(4, o_id);
                stmt1.executeUpdate();
                stmt1 = db.stmtDeliveryBGSelectOrder;
                stmt1.setInt(1, this.deliveryBG.w_id);
                stmt1.setInt(2, d_id);
                stmt1.setInt(3, o_id);
                rs = stmt1.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    throw new Exception("ORDER in DELIVERY_BG for O_W_ID=" + this.deliveryBG.w_id + " O_D_ID=" + d_id + " O_ID=" + o_id + " not found");
                }
                int c_id = rs.getInt("o_c_id");
                rs.close();
                stmt1 = db.stmtDeliveryBGUpdateOrderLine;
                stmt1.setTimestamp(1, new Timestamp(now));
                stmt1.setInt(2, this.deliveryBG.w_id);
                stmt1.setInt(3, d_id);
                stmt1.setInt(4, o_id);
                stmt1.executeUpdate();
                stmt1 = db.stmtDeliveryBGSelectSumOLAmount;
                stmt1.setInt(1, this.deliveryBG.w_id);
                stmt1.setInt(2, d_id);
                stmt1.setInt(3, o_id);
                rs = stmt1.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    throw new Exception("sum(OL_AMOUNT) for ORDER_LINEs with  OL_W_ID=" + this.deliveryBG.w_id + " OL_D_ID=" + d_id + " OL_O_ID=" + o_id + " not found");
                }
                double sum_ol_amount = rs.getDouble("sum_ol_amount");
                rs.close();
                stmt1 = db.stmtDeliveryBGUpdateCustomer;
                stmt1.setDouble(1, sum_ol_amount);
                stmt1.setInt(2, this.deliveryBG.w_id);
                stmt1.setInt(3, d_id);
                stmt1.setInt(4, c_id);
                stmt1.executeUpdate();
                this.deliveryBG.delivered_o_id[d_id - 1] = o_id;
            }
            db.commit();
        }
        catch (SQLException se) {
            log.error((Object)"Unexpected SQLException in DELIVERY_BG");
            for (SQLException x = se; x != null; x = x.getNextException()) {
                log.error((Object)x.getMessage());
            }
            se.printStackTrace();
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
        }
        catch (Exception e) {
            try {
                db.rollback();
            }
            catch (SQLException se2) {
                throw new Exception("Unexpected SQLException on rollback: " + se2.getMessage());
            }
            throw e;
        }
    }

    private void traceDeliveryBG(Logger log, Formatter[] fmt) {
        fmt[0].format("                                    DeliveryBG", new Object[0]);
        fmt[1].format("Warehouse: %6d", this.deliveryBG.w_id);
        fmt[2].format("Carrier Number: %2d", this.deliveryBG.o_carrier_id);
        fmt[3].format("Delivery Date: %-19.19s", this.deliveryBG.ol_delivery_d);
        if (this.transEnd != 0L) {
            for (int d_id = 1; d_id <= 10; ++d_id) {
                fmt[4 + d_id].format("District %02d: delivered O_ID: %8d", d_id, this.deliveryBG.delivered_o_id[d_id - 1]);
            }
        }
    }

    public int[] getDeliveredOrderIDs() {
        return this.deliveryBG.delivered_o_id;
    }

    public int getSkippedDeliveries() {
        int numSkipped = 0;
        for (int i = 0; i < 10; ++i) {
            if (this.deliveryBG.delivered_o_id[i] >= 0) continue;
            ++numSkipped;
        }
        return numSkipped;
    }

    private class DeliveryBGData {
        public int w_id;
        public int o_carrier_id;
        public String ol_delivery_d;
        public int[] delivered_o_id;

        private DeliveryBGData() {
        }
    }

    private class DeliveryData {
        public int w_id;
        public int o_carrier_id;
        public String execution_status;
        public jTPCCTData deliveryBG;

        private DeliveryData() {
        }
    }

    private class StockLevelData {
        public int w_id;
        public int d_id;
        public int threshold;
        public int low_stock;

        private StockLevelData() {
        }
    }

    private class OrderStatusData {
        public int w_id;
        public int d_id;
        public int c_id;
        public String c_last;
        public String c_first;
        public String c_middle;
        public double c_balance;
        public int o_id;
        public String o_entry_d;
        public int o_carrier_id;
        public int[] ol_supply_w_id = new int[15];
        public int[] ol_i_id = new int[15];
        public int[] ol_quantity = new int[15];
        public double[] ol_amount = new double[15];
        public String[] ol_delivery_d = new String[15];

        private OrderStatusData() {
        }
    }

    private class PaymentData {
        public int w_id;
        public int d_id;
        public int c_id;
        public int c_d_id;
        public int c_w_id;
        public String c_last;
        public double h_amount;
        public String w_name;
        public String w_street_1;
        public String w_street_2;
        public String w_city;
        public String w_state;
        public String w_zip;
        public String d_name;
        public String d_street_1;
        public String d_street_2;
        public String d_city;
        public String d_state;
        public String d_zip;
        public String c_first;
        public String c_middle;
        public String c_street_1;
        public String c_street_2;
        public String c_city;
        public String c_state;
        public String c_zip;
        public String c_phone;
        public String c_since;
        public String c_credit;
        public double c_credit_lim;
        public double c_discount;
        public double c_balance;
        public String c_data;
        public String h_date;

        private PaymentData() {
        }
    }

    private class NewOrderData {
        public int w_id;
        public int d_id;
        public int c_id;
        public int[] ol_supply_w_id = new int[15];
        public int[] ol_i_id = new int[15];
        public int[] ol_quantity = new int[15];
        public String c_last;
        public String c_credit;
        public double c_discount;
        public double w_tax;
        public double d_tax;
        public int o_ol_cnt;
        public int o_id;
        public String o_entry_d;
        public double total_amount;
        public String execution_status;
        public String[] i_name = new String[15];
        public int[] s_quantity = new int[15];
        public String[] brand_generic = new String[15];
        public double[] i_price = new double[15];
        public double[] ol_amount = new double[15];

        private NewOrderData() {
        }
    }
}

