/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.assigner.state;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.cdc.connectors.base.source.assigner.AssignerStatus;
import org.apache.flink.cdc.connectors.base.source.assigner.state.ChunkSplitterState;
import org.apache.flink.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SchemalessSnapshotSplit;

public class SnapshotPendingSplitsState
extends PendingSplitsState {
    private final List<TableId> remainingTables;
    private final List<TableId> alreadyProcessedTables;
    private final List<SchemalessSnapshotSplit> remainingSplits;
    private final Map<String, SchemalessSnapshotSplit> assignedSplits;
    private final Map<String, Offset> splitFinishedOffsets;
    private final AssignerStatus assignerStatus;
    private final boolean isTableIdCaseSensitive;
    private final boolean isRemainingTablesCheckpointed;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    private final Map<String, Long> splitFinishedCheckpointIds;
    private final ChunkSplitterState chunkSplitterState;

    public SnapshotPendingSplitsState(List<TableId> alreadyProcessedTables, List<SchemalessSnapshotSplit> remainingSplits, Map<String, SchemalessSnapshotSplit> assignedSplits, Map<TableId, TableChanges.TableChange> tableSchemas, Map<String, Offset> splitFinishedOffsets, AssignerStatus assignerStatus, List<TableId> remainingTables, boolean isTableIdCaseSensitive, boolean isRemainingTablesCheckpointed, Map<String, Long> splitFinishedCheckpointIds, ChunkSplitterState chunkSplitterState) {
        this.alreadyProcessedTables = alreadyProcessedTables;
        this.remainingSplits = remainingSplits;
        this.assignedSplits = assignedSplits;
        this.splitFinishedOffsets = splitFinishedOffsets;
        this.assignerStatus = assignerStatus;
        this.remainingTables = remainingTables;
        this.isTableIdCaseSensitive = isTableIdCaseSensitive;
        this.isRemainingTablesCheckpointed = isRemainingTablesCheckpointed;
        this.tableSchemas = tableSchemas;
        this.chunkSplitterState = chunkSplitterState;
        this.splitFinishedCheckpointIds = splitFinishedCheckpointIds;
    }

    public Map<String, Long> getSplitFinishedCheckpointIds() {
        return this.splitFinishedCheckpointIds;
    }

    public List<TableId> getAlreadyProcessedTables() {
        return this.alreadyProcessedTables;
    }

    public List<SchemalessSnapshotSplit> getRemainingSplits() {
        return this.remainingSplits;
    }

    public Map<String, SchemalessSnapshotSplit> getAssignedSplits() {
        return this.assignedSplits;
    }

    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public Map<String, Offset> getSplitFinishedOffsets() {
        return this.splitFinishedOffsets;
    }

    public AssignerStatus getSnapshotAssignerStatus() {
        return this.assignerStatus;
    }

    public List<TableId> getRemainingTables() {
        return this.remainingTables;
    }

    public boolean isTableIdCaseSensitive() {
        return this.isTableIdCaseSensitive;
    }

    public boolean isRemainingTablesCheckpointed() {
        return this.isRemainingTablesCheckpointed;
    }

    public ChunkSplitterState getChunkSplitterState() {
        return this.chunkSplitterState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SnapshotPendingSplitsState)) {
            return false;
        }
        SnapshotPendingSplitsState that = (SnapshotPendingSplitsState)o;
        return Objects.equals((Object)this.assignerStatus, (Object)that.assignerStatus) && this.isTableIdCaseSensitive == that.isTableIdCaseSensitive && this.isRemainingTablesCheckpointed == that.isRemainingTablesCheckpointed && Objects.equals(this.remainingTables, that.remainingTables) && Objects.equals(this.alreadyProcessedTables, that.alreadyProcessedTables) && Objects.equals(this.remainingSplits, that.remainingSplits) && Objects.equals(this.assignedSplits, that.assignedSplits) && Objects.equals(this.splitFinishedOffsets, that.splitFinishedOffsets) && Objects.equals(this.splitFinishedCheckpointIds, that.splitFinishedCheckpointIds) && Objects.equals(this.chunkSplitterState, that.chunkSplitterState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.remainingTables, this.alreadyProcessedTables, this.remainingSplits, this.assignedSplits, this.splitFinishedOffsets, this.assignerStatus, this.isTableIdCaseSensitive, this.isRemainingTablesCheckpointed, this.splitFinishedCheckpointIds, this.chunkSplitterState});
    }

    public String toString() {
        return "SnapshotPendingSplitsState{remainingTables=" + this.remainingTables + ", alreadyProcessedTables=" + this.alreadyProcessedTables + ", remainingSplits=" + this.remainingSplits + ", assignedSplits=" + this.assignedSplits + ", splitFinishedOffsets=" + this.splitFinishedOffsets + ", assignerStatus=" + this.assignerStatus + ", isTableIdCaseSensitive=" + this.isTableIdCaseSensitive + ", isRemainingTablesCheckpointed=" + this.isRemainingTablesCheckpointed + ", splitFinishedCheckpointIds=" + this.splitFinishedCheckpointIds + ", chunkSplitterState=" + this.chunkSplitterState + "}";
    }
}

