/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.mysql.msgio;

import com.aliyun.encdb.common.json.JSON;
import com.aliyun.encdb.common.json.JSONObject;
import com.aliyun.encdb.common.msgio.MsgIO;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLMsgIO
implements MsgIO {
    private static Logger logger = LoggerFactory.getLogger(MySQLMsgIO.class);
    private final Connection mysqlConn;
    static int cmdCnt = 0;

    public MySQLMsgIO(Connection c) {
        this.mysqlConn = c;
    }

    @Override
    public void send(byte[] msg) {
    }

    @Override
    public byte[] recv() {
        return null;
    }

    @Override
    public byte[] send_recv(byte[] packedMsg) throws SQLException {
        return this.mysql_msg_send_recv(packedMsg);
    }

    private byte[] mysql_msg_send_recv(byte[] packedMsg) throws SQLException {
        String msgStr = new String(packedMsg, StandardCharsets.UTF_8);
        String sqlCmd = "/*encoding_key*/select encdb_process_message(?)";
        PreparedStatement pstmt = this.mysqlConn.prepareStatement(sqlCmd);
        pstmt.setString(1, msgStr);
        logger.debug(sqlCmd + " with param " + msgStr);
        ResultSet rs = pstmt.executeQuery();
        if (!rs.next()) {
            logger.error("empty result from encdb_process_message");
            throw new SQLException("empty result from encdb_process_message");
        }
        String retStr = rs.getString(1);
        byte[] retBytes = Base64.getDecoder().decode(retStr);
        String jsonStr = new String(retBytes, StandardCharsets.UTF_8);
        logger.debug("mysql return: {}", (Object)jsonStr);
        JSONObject jsonRetMsg = JSON.parseObject(jsonStr);
        int retStatus = jsonRetMsg.getIntValue("status");
        if (retStatus != 0) {
            logger.error(jsonRetMsg.toJSONString());
            throw new SQLException(jsonRetMsg.getString("body"), String.valueOf(retStatus));
        }
        String retBody = jsonRetMsg.getString("body");
        return retBody.getBytes(StandardCharsets.UTF_8);
    }
}

