/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.mysql.jdbc;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.encdb.mysql.jdbc.external.com.google.gson.Gson;
import com.aliyun.encdb.mysql.jdbc.external.com.google.gson.JsonObject;
import com.aliyun.encdb.mysql.jdbc.external.com.google.gson.JsonParser;
import com.aliyun.sdk.service.kms20160120.AsyncClient;
import com.aliyun.sdk.service.kms20160120.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.kms20160120.models.GetSecretValueRequest;
import com.aliyun.sdk.service.kms20160120.models.GetSecretValueResponse;
import darabonba.core.client.ClientOverrideConfiguration;
import java.util.concurrent.CompletableFuture;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSConnector {
    private static Logger logger = LoggerFactory.getLogger(KMSConnector.class);

    public static String getMekFromKMS(String sts, String ak, String sk, String region, String secretName, String secretVersion) throws Exception {
        if (ak == null || sk == null || region == null || secretName == null) {
            throw new RuntimeException("You should provide Alibabacloud AK/SK, KMS region ID and KMS secret name at the same time!");
        }
        String mek = null;
        StaticCredentialProvider provider = null;
        provider = sts == null ? StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(ak).accessKeySecret(sk).build()) : StaticCredentialProvider.create((Credential)Credential.builder().securityToken(sts).accessKeyId(ak).accessKeySecret(sk).build());
        AsyncClient client = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().region(region)).credentialsProvider((ICredentialProvider)provider)).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride("kms." + region + ".aliyuncs.com"))).build();
        GetSecretValueRequest getSecretValueRequest = secretVersion == null || secretVersion.isEmpty() ? GetSecretValueRequest.builder().secretName(secretName).build() : GetSecretValueRequest.builder().secretName(secretName).versionId(secretVersion).build();
        CompletableFuture response = client.getSecretValue(getSecretValueRequest);
        GetSecretValueResponse resp = (GetSecretValueResponse)response.get();
        JsonObject jsonObject = JsonParser.parseString(new Gson().toJson(resp.getBody())).getAsJsonObject();
        client.close();
        mek = jsonObject.get("secretData").getAsString();
        byte[] mekBytes = Hex.decode((String)mek);
        if (mekBytes.length != 16) {
            throw new RuntimeException("Invalid mek read from Aliyun KMS: " + mek);
        }
        return mek;
    }
}

