/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.mysql.jdbc;

import com.aliyun.encdb.mysql.crypto.Cryptor;
import com.aliyun.encdb.mysql.jdbc.EncResultSetManager;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.MysqlType;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.MysqlTypeConverter;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.jdbc.result.ResultSetImpl;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.protocol.ColumnDefinition;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.protocol.ResultsetRows;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.protocol.a.result.BinaryBufferRow;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.protocol.a.result.ResultsetRowsCursor;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.protocol.a.result.TextBufferRow;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.protocol.result.EncdbByteRow;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.result.Row;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncResultSetManagerImpl
implements EncResultSetManager {
    private static Logger logger = LoggerFactory.getLogger(EncResultSetManagerImpl.class);

    @Override
    public ResultSet decryptResultSet(Cryptor cryptor, ResultSet encryptedResultSet) throws SQLException {
        return EncResultSetManagerImpl.doDecryptResultSet(cryptor, encryptedResultSet);
    }

    private static void decryptListRows(Cryptor cryptor, List<Row> rows, int cols, ResultSetMetaData meta, ColumnDefinition columnDefinition) throws SQLException {
        if (rows.isEmpty()) {
            return;
        }
        boolean[] needDcypt = new boolean[cols];
        Row firstRow = rows.get(0);
        for (int j = 0; j < cols; ++j) {
            try {
                byte[] possibleCipher = firstRow.getBytes(j);
                if (possibleCipher != null) {
                    possibleCipher = Base64.getDecoder().decode(possibleCipher);
                    byte[] plaintext = cryptor.decrypt(possibleCipher);
                    int type = cryptor.getType(possibleCipher);
                    columnDefinition.getFields()[j].setMysqlTypeId(type);
                    MysqlType mysqlType = MysqlTypeConverter.fromInt(type);
                    if (mysqlType == null) {
                        needDcypt[j] = false;
                        continue;
                    }
                    columnDefinition.getFields()[j].setMysqlType(mysqlType);
                    firstRow.setBytes(j, plaintext);
                    needDcypt[j] = true;
                    continue;
                }
                needDcypt[j] = true;
                continue;
            }
            catch (Exception e) {
                needDcypt[j] = false;
            }
        }
        int listSize = rows.size();
        for (int i = 1; i < listSize; ++i) {
            Row row = rows.get(i);
            for (int j = 0; j < cols; ++j) {
                try {
                    byte[] ciphertext = row.getBytes(j);
                    if (!needDcypt[j] || ciphertext == null) continue;
                    ciphertext = Base64.getDecoder().decode(ciphertext);
                    byte[] plaintext = cryptor.decrypt(ciphertext);
                    row.setBytes(j, plaintext);
                    continue;
                }
                catch (Exception e) {
                    logger.debug("tried to decrypt an invalid cipher fail, leave the original value unchanged.");
                }
            }
        }
    }

    private static void transformListRows(List<Row> rows, int cols) {
        if (rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                int j;
                byte[][] data;
                Row row = rows.get(i);
                if (row instanceof TextBufferRow) {
                    TextBufferRow textBufferRow = (TextBufferRow)row;
                    data = new byte[cols][];
                    for (j = 0; j < cols; ++j) {
                        data[j] = textBufferRow.getBytes(j);
                    }
                    rows.set(i, new EncdbByteRow((byte[][])data, textBufferRow));
                    continue;
                }
                if (!(row instanceof BinaryBufferRow)) continue;
                BinaryBufferRow binaryBufferRow = (BinaryBufferRow)row;
                data = new byte[cols][];
                for (j = 0; j < cols; ++j) {
                    data[j] = binaryBufferRow.getBytes(j);
                }
                rows.set(i, new EncdbByteRow((byte[][])data, binaryBufferRow));
            }
        } else {
            return;
        }
    }

    public static void decryptResultsetRows(Cryptor cryptor, ResultsetRows resultsetRows, int columns, ResultSetMetaData meta, ColumnDefinition columnDefinition) throws SQLException {
        if (resultsetRows instanceof ResultsetRowsCursor) {
            ResultsetRowsCursor resultsetRowsCursor = (ResultsetRowsCursor)resultsetRows;
            try {
                Field fetchedRowsField = ResultsetRowsCursor.class.getDeclaredField("fetchedRows");
                fetchedRowsField.setAccessible(true);
                List fetchedRows = (List)fetchedRowsField.get(resultsetRowsCursor);
                EncResultSetManagerImpl.transformListRows(fetchedRows, columns);
                EncResultSetManagerImpl.decryptListRows(cryptor, fetchedRows, columns, meta, columnDefinition);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.error("failure", (Throwable)e);
                throw new SQLException(e.getStackTrace().toString());
            }
        } else if (resultsetRows instanceof ResultsetRowsStatic) {
            ResultsetRowsStatic resultsetRowsStatic = (ResultsetRowsStatic)resultsetRows;
            try {
                Field rowsField = ResultsetRowsStatic.class.getDeclaredField("rows");
                rowsField.setAccessible(true);
                List fetchedRows = (List)rowsField.get(resultsetRowsStatic);
                EncResultSetManagerImpl.transformListRows(fetchedRows, columns);
                EncResultSetManagerImpl.decryptListRows(cryptor, fetchedRows, columns, meta, columnDefinition);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                logger.error("failure", (Throwable)e);
                throw new SQLException(e.getStackTrace().toString());
            }
        } else {
            throw new SQLException("ResultsetRows with class " + resultsetRows.getClass().getName() + " is not supported");
        }
    }

    private static ResultSet doDecryptResultSet(Cryptor cryptor, ResultSet rs) throws SQLException {
        ResultSetImpl rsImpl = null;
        if (!(rs instanceof ResultSetImpl)) {
            throw new SQLException("ResultSet with class " + rs.getClass().getName() + " is not supported");
        }
        rsImpl = (ResultSetImpl)rs;
        ResultSetMetaData meta = rsImpl.getMetaData();
        int columns = meta.getColumnCount();
        ResultsetRows resultsetRows = rsImpl.getRows();
        ColumnDefinition colDef = rsImpl.getColumnDefinition();
        EncResultSetManagerImpl.decryptResultsetRows(cryptor, resultsetRows, columns, meta, colDef);
        return rs;
    }
}

