/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.mysql.jdbc;

import com.aliyun.encdb.common.common.Constants;
import com.aliyun.encdb.common.exception.EncdbCheckedException;
import com.aliyun.encdb.mysql.crypto.Cryptor;
import com.aliyun.encdb.mysql.jdbc.EncMysqlConnection;
import com.aliyun.encdb.mysql.jdbc.EncResultSetManagerImpl;
import com.aliyun.encdb.mysql.jdbc.KMSConnector;
import com.aliyun.encdb.mysql.jdbc.external.com.mysql.cj.jdbc.Driver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncDriver
extends Driver
implements java.sql.Driver {
    private static final String jdbcUrlPrefix = "jdbc:mysql:encdb:";
    private static final String ENCJDBC_CONF = "encJdbcConfigFile";
    private static final String DEFAULT_ENCJDBC_CONF_FILE = "encjdbc.conf";
    private static final String MEK = "MEK";
    private static final String ENC_ALGO = "ENC_ALGO";
    private static final String ALIYUN_AK = "ALIBABA_CLOUD_ACCESS_KEY_ID";
    private static final String ALIYUN_SK = "ALIBABA_CLOUD_ACCESS_KEY_SECRET";
    private static final String ALIYUN_STS_TOKEN = "ALIBABA_CLOUD_STS_TOKEN";
    private static final String KMS_SECRET_NAME = "KMS_SECRET_NAME";
    private static final String KMS_SECRET_VERSION = "KMS_SECRET_VERSION";
    private static final String KMS_REGION_ID = "KMS_REGION_ID";
    private static String artifactId;
    private static String version;
    private static final Logger logger;
    private static final HashMap<String, String> kmsMekMap;

    private Constants.EncAlgo getEncAlg(String enc_algo) {
        if (enc_algo != null) {
            return Arrays.stream(Constants.EncAlgo.values()).filter(e -> e.name().equalsIgnoreCase(enc_algo)).findAny().orElseThrow(() -> new IllegalArgumentException("invalid algo name"));
        }
        return null;
    }

    public static Properties parseURL(String url) {
        String[] args;
        Properties urlProps = new Properties();
        String urlArgs = "";
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlArgs = url.substring(qPos + 1);
        }
        for (String token : args = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, pos), token.substring(pos + 1));
        }
        return urlProps;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!url.startsWith(jdbcUrlPrefix)) {
            return false;
        }
        String mysqlUrl = "jdbc:mysql:" + url.substring(jdbcUrlPrefix.length());
        return super.acceptsURL(mysqlUrl);
    }

    private static String combineStringsWithSpace(String s1, String s2, String s3, String s4, String s5, String s6) {
        return s1 + " " + s2 + " " + s3 + " " + s4 + " " + s5 + " " + s6;
    }

    private static String combineStringsWithSpace(String s1, String s2) {
        return s1 + " " + s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMekFromKMS(String sts_token, String ak, String sk, String region, String secretName, String secretVersion) throws Exception {
        String key = EncDriver.combineStringsWithSpace(sts_token, ak, sk, region, secretName, secretVersion);
        HashMap<String, String> hashMap = kmsMekMap;
        synchronized (hashMap) {
            if (kmsMekMap.containsKey(key)) {
                return kmsMekMap.get(key);
            }
            String mek = KMSConnector.getMekFromKMS(sts_token, ak, sk, region, secretName, secretVersion);
            if (mek != null) {
                kmsMekMap.put(key, mek);
            }
            return mek;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        EncDriver.logger.info(EncDriver.artifactId + " version " + EncDriver.version);
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!url.startsWith("jdbc:mysql:encdb:")) {
            return null;
        }
        mysqlUrl = "jdbc:mysql:" + url.substring("jdbc:mysql:encdb:".length());
        mek = null;
        enc_algo = null;
        aliyun_ak = null;
        aliyun_sk = null;
        aliyun_sts_token = null;
        aliyun_kms_region = null;
        aliyun_kms_secret = null;
        aliyun_kms_secret_version = null;
        mek = info.getProperty("MEK");
        info.remove("MEK");
        enc_algo = info.getProperty("ENC_ALGO");
        info.remove("ENC_ALGO");
        aliyun_sts_token = info.getProperty("ALIBABA_CLOUD_STS_TOKEN");
        info.remove("ALIBABA_CLOUD_STS_TOKEN");
        aliyun_ak = info.getProperty("ALIBABA_CLOUD_ACCESS_KEY_ID");
        info.remove("ALIBABA_CLOUD_ACCESS_KEY_ID");
        aliyun_sk = info.getProperty("ALIBABA_CLOUD_ACCESS_KEY_SECRET");
        info.remove("ALIBABA_CLOUD_ACCESS_KEY_SECRET");
        aliyun_kms_region = info.getProperty("KMS_REGION_ID");
        info.remove("KMS_REGION_ID");
        aliyun_kms_secret = info.getProperty("KMS_SECRET_NAME");
        info.remove("KMS_SECRET_NAME");
        aliyun_kms_secret_version = info.getProperty("KMS_SECRET_VERSION");
        info.remove("KMS_SECRET_VERSION");
        confFileName = info.getProperty("encJdbcConfigFile");
        confFileName = confFileName == null ? "encjdbc.conf" : confFileName;
        fileProps = new Properties();
        try {
            fis = this.getClass().getClassLoader().getResourceAsStream(confFileName);
            if (fis == null) {
                fis = new FileInputStream(confFileName);
            }
            fileProps.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fnf) {
            EncDriver.logger.error("file {} not found", (Object)confFileName);
        }
        catch (IOException ie) {
            EncDriver.logger.error("file {} io error", (Object)confFileName, (Object)ie);
            throw new SQLException(ie.getMessage());
        }
        if (fileProps.containsKey("MEK") && mek == null) {
            mek = fileProps.getProperty("MEK");
        }
        if (fileProps.containsKey("ENC_ALGO") && enc_algo == null) {
            enc_algo = fileProps.getProperty("ENC_ALGO");
        }
        if (fileProps.containsKey("ALIBABA_CLOUD_STS_TOKEN") && aliyun_sts_token == null) {
            aliyun_sts_token = fileProps.getProperty("ALIBABA_CLOUD_STS_TOKEN");
        }
        if (fileProps.containsKey("ALIBABA_CLOUD_ACCESS_KEY_ID") && aliyun_ak == null) {
            aliyun_ak = fileProps.getProperty("ALIBABA_CLOUD_ACCESS_KEY_ID");
        }
        if (fileProps.containsKey("ALIBABA_CLOUD_ACCESS_KEY_SECRET") && aliyun_sk == null) {
            aliyun_sk = fileProps.getProperty("ALIBABA_CLOUD_ACCESS_KEY_SECRET");
        }
        if (fileProps.containsKey("KMS_REGION_ID") && aliyun_kms_region == null) {
            aliyun_kms_region = fileProps.getProperty("KMS_REGION_ID");
        }
        if (fileProps.containsKey("KMS_SECRET_NAME") && aliyun_kms_secret == null) {
            aliyun_kms_secret = fileProps.getProperty("KMS_SECRET_NAME");
        }
        if (fileProps.containsKey("KMS_SECRET_VERSION") && aliyun_kms_secret_version == null) {
            aliyun_kms_secret_version = fileProps.getProperty("KMS_SECRET_VERSION");
        }
        if (!(urlProps = EncDriver.parseURL(mysqlUrl)).isEmpty()) {
            if (urlProps.containsKey("MEK") && mek == null) {
                mek = urlProps.getProperty("MEK");
            }
            if (urlProps.containsKey("ENC_ALGO") && enc_algo == null) {
                enc_algo = urlProps.getProperty("ENC_ALGO");
            }
            if (urlProps.containsKey("ALIBABA_CLOUD_STS_TOKEN") && aliyun_sts_token == null) {
                aliyun_sts_token = urlProps.getProperty("ALIBABA_CLOUD_STS_TOKEN");
            }
            if (urlProps.containsKey("ALIBABA_CLOUD_ACCESS_KEY_ID") && aliyun_ak == null) {
                aliyun_ak = urlProps.getProperty("ALIBABA_CLOUD_ACCESS_KEY_ID");
            }
            if (urlProps.containsKey("ALIBABA_CLOUD_ACCESS_KEY_SECRET") && aliyun_sk == null) {
                aliyun_sk = urlProps.getProperty("ALIBABA_CLOUD_ACCESS_KEY_SECRET");
            }
            if (urlProps.containsKey("KMS_REGION_ID") && aliyun_kms_region == null) {
                aliyun_kms_region = urlProps.getProperty("KMS_REGION_ID");
            }
            if (urlProps.containsKey("KMS_SECRET_NAME") && aliyun_kms_secret == null) {
                aliyun_kms_secret = urlProps.getProperty("KMS_SECRET_NAME");
            }
            if (urlProps.containsKey("KMS_SECRET_VERSION") && aliyun_kms_secret_version == null) {
                aliyun_kms_secret_version = urlProps.getProperty("KMS_SECRET_VERSION");
            }
            urlProps.remove("MEK");
            urlProps.remove("ENC_ALGO");
            urlProps.remove("ALIBABA_CLOUD_STS_TOKEN");
            urlProps.remove("ALIBABA_CLOUD_ACCESS_KEY_ID");
            urlProps.remove("ALIBABA_CLOUD_ACCESS_KEY_SECRET");
            urlProps.remove("KMS_REGION_ID");
            urlProps.remove("KMS_SECRET_NAME");
            urlProps.remove("KMS_SECRET_VERSION");
            first = true;
            mysqlUrlBuilder = new StringBuilder(mysqlUrl.substring(0, mysqlUrl.indexOf("?")));
            for (Object o : urlProps.keySet()) {
                key = (String)o;
                value = urlProps.getProperty(key);
                if (value == null) continue;
                if (first) {
                    first = false;
                    mysqlUrlBuilder.append("?").append(key).append("=").append(value);
                    continue;
                }
                mysqlUrlBuilder.append("&").append(key).append("=").append(value);
            }
            mysqlUrl = mysqlUrlBuilder.toString();
        }
        if (mek == null) {
            try {
                tmp = this.getMekFromKMS(aliyun_sts_token, aliyun_ak, aliyun_sk, aliyun_kms_region, aliyun_kms_secret, aliyun_kms_secret_version);
                if (tmp == null) ** GOTO lbl130
                mek = tmp;
            }
            catch (Exception e) {
                EncDriver.logger.error("Failed to read MEK from KMS", (Throwable)e);
                throw new SQLException("Failed to read MEK from KMS");
            }
        } else if (aliyun_sts_token != null || aliyun_ak != null || aliyun_sk != null || aliyun_kms_region != null || aliyun_kms_secret != null || aliyun_kms_secret_version != null) {
            throw new SQLException("Wrong configuration. If you have set MEK directly, do not set variables for Aliyun KMS.");
        }
lbl130:
        // 4 sources

        mysqlConn = super.connect(mysqlUrl, info);
        cryptor = new Cryptor(mysqlConn);
        try {
            cryptor.setMek(mek, this.getEncAlg(enc_algo));
        }
        catch (EncdbCheckedException e) {
            EncDriver.logger.warn("MEK set failed", (Throwable)e);
        }
        return new EncMysqlConnection(cryptor, mysqlConn, new EncResultSetManagerImpl());
    }

    static {
        logger = LoggerFactory.getLogger(EncDriver.class);
        kmsMekMap = new HashMap();
        try {
            Properties props = new Properties();
            InputStream stream = EncDriver.class.getClassLoader().getResourceAsStream("project.properties");
            props.load(stream);
            artifactId = props.getProperty("artifactId");
            version = props.getProperty("version");
        }
        catch (Exception props) {
            // empty catch block
        }
        try {
            DriverManager.registerDriver(new EncDriver());
        }
        catch (SQLException E) {
            throw new RuntimeException("Can't register driver!");
        }
    }
}

