/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.mysql.crypto;

import com.aliyun.encdb.common.cipher.Envelope;
import com.aliyun.encdb.common.common.Constants;
import com.aliyun.encdb.common.common.ServerInfo;
import com.aliyun.encdb.common.common.Utils;
import com.aliyun.encdb.common.crypto.CipherSuite;
import com.aliyun.encdb.common.crypto.HKDF;
import com.aliyun.encdb.common.crypto.HashAlgo;
import com.aliyun.encdb.common.crypto.Symmetric;
import com.aliyun.encdb.common.exception.EncdbCheckedException;
import com.aliyun.encdb.common.exception.EncdbRuntimeException;
import com.aliyun.encdb.common.json.JSONObject;
import com.aliyun.encdb.mysql.cipher.CipherForMySQL;
import com.aliyun.encdb.mysql.jdbc.external.com.google.gson.JsonObject;
import com.aliyun.encdb.mysql.msgio.MySQLMsgIO;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.zip.DataFormatException;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cryptor {
    private static final Logger logger = LoggerFactory.getLogger(Cryptor.class);
    private byte[] cachedMek = null;
    private byte[] cachedNonce = null;
    private byte[] cachedDek = null;
    private final ServerInfo serverInfo;
    private final CipherSuite cipherSuite;
    private final String username;
    private final Connection dbConnection;
    private final MySQLMsgIO msgio;
    private final boolean isDuplicate;

    protected Cryptor(Cryptor cryptor) {
        this.cachedMek = cryptor.cachedMek == null ? null : Arrays.copyOf((byte[])cryptor.cachedMek, (int)cryptor.cachedMek.length);
        this.cachedNonce = cryptor.cachedNonce == null ? null : Arrays.copyOf((byte[])cryptor.cachedNonce, (int)cryptor.cachedNonce.length);
        this.cachedDek = cryptor.cachedDek == null ? null : Arrays.copyOf((byte[])cryptor.cachedDek, (int)cryptor.cachedDek.length);
        this.cipherSuite = cryptor.cipherSuite;
        this.username = cryptor.username;
        this.serverInfo = cryptor.serverInfo;
        this.msgio = null;
        this.dbConnection = null;
        this.isDuplicate = true;
    }

    public Cryptor getDuplicate() {
        return new Cryptor(this);
    }

    public Cryptor(Connection conn) {
        this.serverInfo = ServerInfo.requestServerInfo(conn, Constants.KeyMgmtType.MySQL);
        this.cipherSuite = this.serverInfo.getCipherSuite();
        this.dbConnection = conn;
        this.msgio = new MySQLMsgIO(conn);
        this.username = this.getCurrentUsername();
        this.isDuplicate = false;
    }

    public byte[] decrypt(byte[] val) throws EncdbCheckedException {
        if (this.cachedMek == null) {
            throw new EncdbCheckedException("MEK not set");
        }
        CipherForMySQL c = CipherForMySQL.buildCipher(val);
        if (this.cachedDek == null || !c.checkNonce(this.cachedNonce)) {
            this.cachedNonce = c.getNonce();
            if (this.cipherSuite.getHashAlgo() == HashAlgo.SM3) {
                this.cachedDek = HKDF.deriveWithSM3(Symmetric.Params.SM4_128_KEY_SIZE.getVal(), this.cachedMek, this.cachedNonce, null);
            } else if (this.cipherSuite.getHashAlgo() == HashAlgo.SHA256) {
                this.cachedDek = HKDF.deriveWithSHA256(Symmetric.Params.AES_128_KEY_SIZE.getVal(), this.cachedMek, this.cachedNonce, null);
            } else {
                throw new InvalidParameterException("Invalid Hash Alg");
            }
        }
        try {
            return c.decrypt(this.cachedDek);
        }
        catch (Exception e) {
            logger.debug("decrypt failed", (Throwable)e);
            throw new EncdbCheckedException("decrypt failed");
        }
    }

    public int getType(byte[] val) throws EncdbCheckedException {
        CipherForMySQL c = CipherForMySQL.buildCipher(val);
        return c.getEncType();
    }

    public void setMek(String mek, Constants.EncAlgo algo) throws EncdbCheckedException {
        byte[] mekBytes = Hex.decode((String)mek);
        if (mekBytes == null || mekBytes.length != 16) {
            throw new EncdbRuntimeException("Invalid MEK [" + mek + "]");
        }
        this.setMek(mekBytes, algo);
    }

    public void setMek(byte[] mek, Constants.EncAlgo algo) throws EncdbCheckedException {
        if (mek == null || mek.length != 16) {
            throw new EncdbRuntimeException("Invalid MEK [" + (mek == null ? "null" : Hex.toHexString((byte[])mek)) + "]");
        }
        this.cachedMek = mek;
        if (this.isDuplicate) {
            return;
        }
        try {
            JSONObject req = this.getEnvelopSealedMekObj(mek, null, algo);
            req.put("username", this.username);
            this.msgio.send_recv(req.toJSONString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new EncdbCheckedException("failed to provision mek", e);
        }
    }

    public void updateMek(String oldMek, String newMek, Constants.EncAlgo algo) throws EncdbCheckedException {
        byte[] oldMekBytes = Hex.decode((String)oldMek);
        byte[] newMekBytes = Hex.decode((String)newMek);
        if (oldMekBytes == null || oldMekBytes.length != 16) {
            throw new EncdbRuntimeException("Invalid old MEK [" + oldMek + "]");
        }
        if (newMekBytes == null || newMekBytes.length != 16) {
            throw new EncdbRuntimeException("Invalid new MEK [" + newMek + "]");
        }
        this.updateMek(oldMekBytes, newMekBytes, algo);
    }

    public void updateMek(byte[] oldMek, byte[] newMek, Constants.EncAlgo algo) throws EncdbCheckedException {
        if (oldMek == null || oldMek.length != 16) {
            throw new EncdbRuntimeException("Invalid oldMek [" + (oldMek == null ? "null" : Hex.toHexString((byte[])oldMek)) + "]");
        }
        if (newMek == null || newMek.length != 16) {
            throw new EncdbRuntimeException("Invalid newMek [" + (newMek == null ? "null" : Hex.toHexString((byte[])newMek)) + "]");
        }
        this.cachedMek = newMek;
        if (this.isDuplicate) {
            return;
        }
        try {
            JSONObject req = this.getEnvelopSealedMekObj(newMek, oldMek, algo);
            req.put("username", this.username);
            this.msgio.send_recv(req.toJSONString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new EncdbCheckedException("failed to update mek", e);
        }
    }

    private String getEnvelopeString(byte[] mek, byte[] oldMek) throws IOException, CryptoException, DataFormatException {
        JSONObject envObj = new JSONObject();
        if (mek != null) {
            envObj.put("mek", Utils.bytesTobase64(mek));
        }
        if (oldMek != null) {
            envObj.put("old_mek", Utils.bytesTobase64(oldMek));
        }
        byte[] rawData = envObj.toJSONString().getBytes(StandardCharsets.UTF_8);
        Envelope env = new Envelope(rawData);
        env.setCiperSuite(this.cipherSuite);
        return Utils.bytesTobase64(env.seal(this.serverInfo.getPublicKey()).getBytes());
    }

    private JSONObject getEnvelopSealedMekObj(byte[] mek, byte[] oldMek, Constants.EncAlgo algo) throws CryptoException, DataFormatException, IOException {
        JSONObject req = new JSONObject();
        if (oldMek != null) {
            req.put("request_type", 49);
        } else {
            req.put("request_type", 48);
        }
        if (algo != null) {
            req.put("algorithm", algo);
        }
        req.put("envelope", this.getEnvelopeString(mek, oldMek));
        req.put("public_key_hash", this.serverInfo.getPublicKeyHash());
        return req;
    }

    public void setEncRule(String rule) throws EncdbCheckedException {
        if (rule == null) {
            throw new EncdbRuntimeException("wrong configuration, enc rule not set");
        }
        if (this.isDuplicate) {
            return;
        }
        try {
            JsonObject reqObject = new JsonObject();
            reqObject.addProperty("request_type", 160);
            reqObject.addProperty("enc_rule", Base64.getEncoder().encodeToString(rule.getBytes(StandardCharsets.UTF_8)));
            reqObject.addProperty("username", this.username);
            this.msgio.send_recv(reqObject.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new EncdbCheckedException("import enc rule failed", e);
        }
    }

    private String getCurrentUsername() {
        try {
            String sqlCmd = "select current_user()";
            ResultSet rs = this.dbConnection.createStatement().executeQuery(sqlCmd);
            rs.next();
            String ret = rs.getString(1);
            return ret.split("@")[0];
        }
        catch (SQLException throwables) {
            throw new EncdbRuntimeException("not able to get connection username", throwables);
        }
    }
}

