/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.mysql.cipher;

import com.aliyun.encdb.common.common.Constants;
import com.aliyun.encdb.common.crypto.SymCrypto;
import com.aliyun.encdb.common.exception.EncdbCheckedException;
import com.aliyun.encdb.common.exception.EncdbException;
import com.aliyun.encdb.mysql.jdbc.external.com.google.common.primitives.Bytes;
import java.nio.BufferUnderflowException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.DataFormatException;
import org.bouncycastle.crypto.CryptoException;

public class CipherForMySQL {
    private final byte[] data;
    private final int type;
    private final Constants.EncAlgo algo;
    private final int nonce_start_inclu;
    private final int nonce_end_exclu;
    private final int body_start_inclu;
    private final int body_end_exclu;

    public static CipherForMySQL buildCipher(byte[] data) throws EncdbCheckedException {
        return new CipherForMySQL(data);
    }

    public static boolean verifyCheckCode(List<Byte> data, byte expected) {
        byte computed = CipherForMySQL.xorArray(data);
        return computed == expected;
    }

    public static boolean verifyCheckCode(byte[] data, int start, int end, byte expected) {
        byte computed = CipherForMySQL.xorArray(data, start, end);
        return computed == expected;
    }

    private CipherForMySQL(byte[] data) throws EncdbCheckedException {
        if (data.length < 11) {
            throw new EncdbCheckedException("cipher cannot be " + data.length + " bytes");
        }
        this.data = data;
        byte checkCode = data[0];
        byte version = data[1];
        if (version == 64) {
            if (data.length < 12) {
                throw new EncdbCheckedException("cipher cannot be " + data.length + " bytes");
            }
            if (!CipherForMySQL.verifyCheckCode(data, 1, data.length, checkCode)) {
                throw new EncdbCheckedException("cipher data check code verify failed");
            }
            this.type = data[2] & 0xFF;
            this.algo = Constants.EncAlgo.from(data[3] & 0xFF);
            this.nonce_start_inclu = 4;
            this.nonce_end_exclu = 12;
            this.body_start_inclu = 12;
            this.body_end_exclu = data.length;
        } else {
            if (!CipherForMySQL.verifyCheckCode(data, 1, data.length - 8, checkCode)) {
                throw new EncdbCheckedException("cipher data check code verify failed");
            }
            this.type = data[1] & 0xFF;
            this.algo = Constants.EncAlgo.from(data[2] & 0xF);
            this.nonce_start_inclu = data.length - 8;
            this.nonce_end_exclu = data.length;
            this.body_start_inclu = 3;
            this.body_end_exclu = data.length - 8;
        }
    }

    public byte[] getNonce() {
        return Arrays.copyOfRange(this.data, this.nonce_start_inclu, this.nonce_end_exclu);
    }

    public boolean checkNonce(byte[] nonce) {
        if (nonce == null || nonce.length != this.nonce_end_exclu - this.nonce_start_inclu) {
            return false;
        }
        for (int i = 0; i < nonce.length; ++i) {
            if (nonce[i] == this.data[this.nonce_start_inclu + i]) continue;
            return false;
        }
        return true;
    }

    private static List<Byte> swapBytesByPivot(byte[] tmpResult, int index) {
        assert (index < tmpResult.length);
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int i = 0; i < tmpResult.length; ++i) {
            result.add(tmpResult[index++ % tmpResult.length]);
        }
        return result;
    }

    public byte[] decrypt(byte[] key) throws NoSuchAlgorithmException, CryptoException, DataFormatException {
        byte[] tmpData = null;
        try {
            switch (this.algo) {
                case AES_128_GCM: {
                    byte[] ivSub = Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_start_inclu + 12);
                    byte[] dataSub = Bytes.toArray(CipherForMySQL.swapBytesByPivot(Arrays.copyOfRange(this.data, this.body_start_inclu + 12, this.body_end_exclu), 16));
                    tmpData = SymCrypto.aesGcmDecrypt(key, dataSub, ivSub);
                    break;
                }
                case SM4_128_GCM: {
                    byte[] ivSub = Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_start_inclu + 12);
                    byte[] dataSub = Bytes.toArray(CipherForMySQL.swapBytesByPivot(Arrays.copyOfRange(this.data, this.body_start_inclu + 12, this.body_end_exclu), 16));
                    tmpData = SymCrypto.sm4GcmDecrypt(key, dataSub, ivSub);
                    break;
                }
                case AES_128_CBC: {
                    byte[] ivSub = Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_start_inclu + 16);
                    byte[] dataSub = Arrays.copyOfRange(this.data, this.body_start_inclu + 16, this.body_end_exclu);
                    tmpData = SymCrypto.aesCBCDecrypt(key, dataSub, ivSub);
                    break;
                }
                case AES_128_ECB: {
                    tmpData = SymCrypto.aesECBDecrypt(key, Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_end_exclu));
                    break;
                }
                case SM4_128_CBC: {
                    byte[] ivSub = Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_start_inclu + 16);
                    byte[] dataSub = Arrays.copyOfRange(this.data, this.body_start_inclu + 16, this.body_end_exclu);
                    tmpData = SymCrypto.sm4CBCDecrypt(key, dataSub, ivSub);
                    break;
                }
                case SM4_128_ECB: {
                    tmpData = SymCrypto.sm4ECBDecrypt(key, Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_end_exclu));
                    break;
                }
                case AES_128_CTR: {
                    byte[] ivSub = Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_start_inclu + 16);
                    byte[] dataSub = Arrays.copyOfRange(this.data, this.body_start_inclu + 16, this.body_end_exclu);
                    tmpData = SymCrypto.aesCTRDecrypt(key, dataSub, ivSub);
                    break;
                }
                case SM4_128_CTR: {
                    byte[] ivSub = Arrays.copyOfRange(this.data, this.body_start_inclu, this.body_start_inclu + 16);
                    byte[] dataSub = Arrays.copyOfRange(this.data, this.body_start_inclu + 16, this.body_end_exclu);
                    tmpData = SymCrypto.sm4CTRDecrypt(key, dataSub, ivSub);
                    break;
                }
            }
            if (tmpData == null) {
                throw new EncdbException("decrypt failed");
            }
        }
        catch (BufferUnderflowException e) {
            throw new DataFormatException("Wrong encdb cipher bytes");
        }
        if (!CipherForMySQL.verifyCheckCode(tmpData, 0, tmpData.length - 1, tmpData[tmpData.length - 1])) {
            throw new EncdbException("plain data check code verify failed");
        }
        return Arrays.copyOfRange(tmpData, 0, tmpData.length - 1);
    }

    public static byte xorArray(List<Byte> data) {
        byte ret = 0;
        for (Byte datum : data) {
            ret = (byte)(ret ^ datum);
        }
        return ret;
    }

    public static byte xorArray(byte[] data, int start, int end) {
        byte ret = 0;
        for (int i = start; i < end; ++i) {
            ret = (byte)(ret ^ data[i]);
        }
        return ret;
    }

    public int getEncType() {
        return this.type;
    }

    public Constants.EncAlgo getEncAlgo() {
        return this.algo;
    }
}

