/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.json;

import com.aliyun.encdb.common.json.JSONArray;
import com.aliyun.encdb.mysql.jdbc.external.com.google.gson.JsonElement;
import com.aliyun.encdb.mysql.jdbc.external.com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;

public class JSONObject {
    protected final JsonObject internalGsonObject;

    public JSONObject(JsonObject jsonObject) {
        this.internalGsonObject = jsonObject;
    }

    public JSONObject() {
        this.internalGsonObject = new JsonObject();
    }

    public void put(String key, String value) {
        this.internalGsonObject.addProperty(key, value);
    }

    public void put(String key, Number value) {
        this.internalGsonObject.addProperty(key, value);
    }

    public void put(String key, byte[] value) {
        this.internalGsonObject.addProperty(key, new String(value, StandardCharsets.UTF_8));
    }

    public void put(String key, Object value) {
        this.internalGsonObject.addProperty(key, value.toString());
    }

    public void put(String key, JSONObject value) {
        this.internalGsonObject.add(key, value.internalGsonObject);
    }

    public void put(String key, Boolean value) {
        this.internalGsonObject.addProperty(key, value);
    }

    public void put(String key, JSONArray value) {
        this.internalGsonObject.add(key, value.internalGsonArray);
    }

    public JSONObject fluentPut(String key, String value) {
        this.put(key, value);
        return this;
    }

    public JSONObject fluentPut(String key, Number value) {
        this.put(key, value);
        return this;
    }

    public JSONObject fluentPut(String key, byte[] value) {
        this.put(key, value);
        return this;
    }

    public JSONObject fluentPut(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public int getIntValue(String key) {
        Integer ret = this.getInteger(key);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    public Integer getInteger(String key) {
        JsonElement e = this.internalGsonObject.get(key);
        return e == null || e.isJsonNull() ? null : Integer.valueOf(e.getAsInt());
    }

    public long getLongValue(String key) {
        Long ret = this.getLong(key);
        if (ret == null) {
            return 0L;
        }
        return ret;
    }

    public Long getLong(String key) {
        JsonElement e = this.internalGsonObject.get(key);
        return e == null || e.isJsonNull() ? null : Long.valueOf(e.getAsLong());
    }

    public boolean getBooleanValue(String key) {
        Boolean ret = this.getBoolean(key);
        if (ret == null) {
            return false;
        }
        return ret;
    }

    public Boolean getBoolean(String key) {
        JsonElement e = this.internalGsonObject.get(key);
        return e == null || e.isJsonNull() ? null : Boolean.valueOf(e.getAsBoolean());
    }

    public double getDoubleValue(String key) {
        Double ret = this.getDouble(key);
        if (ret == null) {
            return 0.0;
        }
        return ret;
    }

    public Double getDouble(String key) {
        JsonElement e = this.internalGsonObject.get(key);
        return e == null || e.isJsonNull() ? null : Double.valueOf(e.getAsDouble());
    }

    public JSONObject getJSONObject(String key) {
        JsonElement e = this.internalGsonObject.get(key);
        return e == null || e.isJsonNull() ? null : new JSONObject(e.getAsJsonObject());
    }

    public String getString(String key) {
        JsonElement e = this.internalGsonObject.get(key);
        return e == null || e.isJsonNull() ? null : e.getAsString();
    }

    public boolean containsKey(String key) {
        return this.internalGsonObject.has(key);
    }

    public String toJSONString() {
        return this.internalGsonObject.toString();
    }

    public String get(String id) {
        return this.internalGsonObject.get(id).getAsString();
    }

    public int size() {
        return this.internalGsonObject.size();
    }

    public String toString() {
        return this.internalGsonObject.toString();
    }
}

