/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SymCrypto {
    public static final int AES_BLOCK_SIZE = 16;
    public static final int AES_128_KEY_SIZE = 16;
    public static final int SM4_BLOCK_SIZE = 16;
    public static final int SM4_KEY_SIZE = 16;
    public static final int CLWW_ORE_KEY_SIZE = 32;
    public static final int GCMTagLength = 16;
    public static final int GCMIVLength = 12;
    public static final int CBCIVLength = 16;
    public static final int CTRIVLength = 16;

    private static byte[] gcmEncrypt(byte[] key, byte[] data, byte[] iv, byte[] aad, String algorithm) throws CryptoException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(algorithm + "/GCM/NoPadding");
            if (iv == null) {
                throw new Exception("GCM mode IV should of length 12");
            }
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, parameterSpec);
            if (aad != null) {
                cipher.updateAAD(aad);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CryptoException("gcmEncrypt error", (Throwable)e);
        }
    }

    public static byte[] aesGcmEncrypt(byte[] key, byte[] data, byte[] iv, byte[] aad) throws CryptoException {
        return SymCrypto.gcmEncrypt(key, data, iv, aad, "AES");
    }

    public static byte[] aesGcmEncrypt(byte[] key, byte[] data, byte[] iv) throws CryptoException {
        return SymCrypto.gcmEncrypt(key, data, iv, null, "AES");
    }

    public static byte[] sm4GcmEncrypt(byte[] key, byte[] data, byte[] iv, byte[] aad) throws CryptoException {
        return SymCrypto.gcmEncrypt(key, data, iv, aad, "SM4");
    }

    public static byte[] sm4GcmEncrypt(byte[] key, byte[] data, byte[] iv) throws CryptoException {
        return SymCrypto.gcmEncrypt(key, data, iv, null, "SM4");
    }

    private static byte[] gcmDecrypt(byte[] key, byte[] cipherBytes, byte[] iv, byte[] aad, String algorithm) throws CryptoException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(algorithm + "/GCM/NoPadding");
            if (iv.length != 12) {
                throw new Exception("GCM mode IV should of length 12");
            }
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secretKey, parameterSpec);
            if (aad != null) {
                cipher.updateAAD(aad);
            }
            return cipher.doFinal(cipherBytes);
        }
        catch (Exception e) {
            throw new CryptoException("gcmDecrypt error", (Throwable)e);
        }
    }

    public static byte[] aesGcmDecrypt(byte[] key, byte[] cipherBytes, byte[] iv, byte[] aad) throws CryptoException {
        return SymCrypto.gcmDecrypt(key, cipherBytes, iv, aad, "AES");
    }

    public static byte[] aesGcmDecrypt(byte[] key, byte[] cipherBytes, byte[] iv) throws CryptoException {
        return SymCrypto.gcmDecrypt(key, cipherBytes, iv, null, "AES");
    }

    public static byte[] sm4GcmDecrypt(byte[] key, byte[] cipherBytes, byte[] iv, byte[] aad) throws CryptoException {
        return SymCrypto.gcmDecrypt(key, cipherBytes, iv, aad, "SM4");
    }

    public static byte[] sm4GcmDecrypt(byte[] key, byte[] cipherBytes, byte[] iv) throws CryptoException {
        return SymCrypto.gcmDecrypt(key, cipherBytes, iv, null, "SM4");
    }

    private static byte[] ecbPKCS7Cipher(byte[] key, byte[] data, String algorithm, boolean forEncryption) throws CryptoException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(algorithm + "/ECB/PKCS5Padding");
            cipher.init(forEncryption ? 1 : 2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            String errMsg = algorithm + " ecbPKCS7Cipher " + (forEncryption ? " encryption" : " decryption") + " error";
            throw new CryptoException(errMsg, (Throwable)e);
        }
    }

    public static byte[] aesECBEncrypt(byte[] key, byte[] data) throws CryptoException {
        return SymCrypto.ecbPKCS7Cipher(key, data, "AES", true);
    }

    public static byte[] aesECBDecrypt(byte[] key, byte[] cipherBytes) throws CryptoException {
        return SymCrypto.ecbPKCS7Cipher(key, cipherBytes, "AES", false);
    }

    public static byte[] sm4ECBEncrypt(byte[] key, byte[] data) throws CryptoException {
        return SymCrypto.ecbPKCS7Cipher(key, data, "SM4", true);
    }

    public static byte[] sm4ECBDecrypt(byte[] key, byte[] cipherBytes) throws CryptoException {
        return SymCrypto.ecbPKCS7Cipher(key, cipherBytes, "SM4", false);
    }

    private static byte[] cbcPKCS7Cipher(byte[] key, byte[] data, byte[] iv, String algorithm, boolean forEncryption) throws CryptoException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            if (iv == null && forEncryption) {
                SecureRandom secureRandom = new SecureRandom();
                iv = new byte[16];
                secureRandom.nextBytes(iv);
            }
            if (Objects.requireNonNull(iv).length != 16) {
                throw new InvalidAlgorithmParameterException("CBC mode IV should of length 16");
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(forEncryption ? 1 : 2, (Key)secretKey, ivParameterSpec);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            String errMsg = algorithm + " cbcPKCS7Cipher " + (forEncryption ? " encryption" : " decryption") + " error";
            throw new CryptoException(errMsg, (Throwable)e);
        }
    }

    public static byte[] sm4CBCEncrypt(byte[] key, byte[] data, byte[] iv) throws CryptoException {
        return SymCrypto.cbcPKCS7Cipher(key, data, iv, "SM4", true);
    }

    public static byte[] sm4CBCDecrypt(byte[] key, byte[] cipherBytes, byte[] iv) throws CryptoException {
        return SymCrypto.cbcPKCS7Cipher(key, cipherBytes, iv, "SM4", false);
    }

    public static byte[] aesCBCEncrypt(byte[] key, byte[] data, byte[] iv) throws CryptoException {
        return SymCrypto.cbcPKCS7Cipher(key, data, iv, "AES", true);
    }

    public static byte[] aesCBCDecrypt(byte[] key, byte[] cipherBytes, byte[] iv) throws CryptoException {
        return SymCrypto.cbcPKCS7Cipher(key, cipherBytes, iv, "AES", false);
    }

    private static byte[] ctrCipher(byte[] key, byte[] data, byte[] iv, String algorithm, boolean forEncryption) throws CryptoException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(algorithm + "/CTR/NoPadding");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(forEncryption ? 1 : 2, (Key)secretKey, ivSpec);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            String errMsg = algorithm + " ctr " + (forEncryption ? " encryption" : " decryption") + " error";
            throw new CryptoException(errMsg, (Throwable)e);
        }
    }

    public static byte[] aesCTRDecrypt(byte[] key, byte[] cipherBytes, byte[] iv) throws CryptoException {
        return SymCrypto.ctrCipher(key, cipherBytes, iv, "AES", false);
    }

    public static byte[] sm4CTRDecrypt(byte[] key, byte[] cipherBytes, byte[] iv) throws CryptoException {
        return SymCrypto.ctrCipher(key, cipherBytes, iv, "SM4", false);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

