/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.crypto;

import com.aliyun.encdb.common.crypto.AsymCrypto;
import com.aliyun.encdb.common.crypto.AsymmAlgo;
import com.aliyun.encdb.common.crypto.HMAC;
import com.aliyun.encdb.common.crypto.HashAlgo;
import com.aliyun.encdb.mysql.jdbc.external.com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;

public class SignUtil {
    public static boolean verifyWithSha256Ecdsa(PublicKey publicKey, byte[] message, byte[] sign) {
        return SignUtil.verify(publicKey, "SHA256withECDSA", message, sign);
    }

    public static byte[] signWithSha256Ecdsa(PrivateKey privateKey, byte[] message) {
        return SignUtil.sign(privateKey, "SHA256withECDSA", message);
    }

    public static boolean verifySha256Rsa(PublicKey publicKey, byte[] message, byte[] sign) {
        return SignUtil.verify(publicKey, "SHA256withRSA", message, sign);
    }

    public static boolean verify(PublicKey publicKey, String algorithm, byte[] message, byte[] sign) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            signature.update(message);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] signWithSha256Rsa(PrivateKey privateKey, byte[] message) {
        return SignUtil.sign(privateKey, "SHA256withRSA", message);
    }

    public static byte[] sign(PrivateKey privateKey, String algorithm, byte[] message) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] signHmac(HashAlgo alg, byte[] key, byte[] data) {
        ArrayList<Byte> result = new ArrayList<Byte>();
        result.add((byte)alg.getVal());
        byte[] sig = HMAC.hmac(alg, key, data);
        result.addAll(Bytes.asList(sig));
        return Bytes.toArray(result);
    }

    public static boolean verifyHmac(byte[] key, byte[] sigBlob, byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(sigBlob).order(ByteOrder.LITTLE_ENDIAN);
        HashAlgo alg = HashAlgo.from(bb.get());
        int sigLen = bb.remaining();
        byte[] sig = new byte[sigLen];
        bb.get(sig);
        return SignUtil.signHmac(alg, key, data) == sig;
    }

    public static byte[] sign(AsymmAlgo alg, String privateKeyPemString, byte[] data) throws RuntimeException {
        ArrayList<Byte> result = new ArrayList<Byte>();
        result.add((byte)alg.getVal());
        try {
            byte[] sig = AsymCrypto.sign(alg, privateKeyPemString, data);
            result.addAll(Bytes.asList(sig));
        }
        catch (Exception e) {
            throw new RuntimeException("Sign signature blob fail", e);
        }
        return Bytes.toArray(result);
    }

    public static boolean verify(String publicKeyPemString, byte[] sigBlob, byte[] data) throws RuntimeException {
        ByteBuffer bb = ByteBuffer.wrap(sigBlob).order(ByteOrder.LITTLE_ENDIAN);
        AsymmAlgo alg = AsymmAlgo.from(bb.get());
        int sigLen = bb.remaining();
        byte[] sig = new byte[sigLen];
        bb.get(sig);
        try {
            return AsymCrypto.verify(alg, publicKeyPemString, data, sig);
        }
        catch (Exception e) {
            throw new RuntimeException("Verify signature blob fail", e);
        }
    }
}

