/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.crypto;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class RSAUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static PublicKey getPublicKey(String base64PublicKey) {
        base64PublicKey = RSAUtil.extractPemBlock(base64PublicKey);
        PublicKey publicKey = null;
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(base64PublicKey.getBytes()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return publicKey;
    }

    public static PublicKey getPublicKeyPKCS1(String keyStr) throws IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(keyStr));){
            SubjectPublicKeyInfo pkInfo = (SubjectPublicKeyInfo)pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PublicKey publicKey = converter.getPublicKey(pkInfo);
            return publicKey;
        }
    }

    public static PrivateKey getPrivateKeyPKCS1(String base64PrivateKey) {
        PrivateKey privateKey = null;
        try {
            StringReader certReader = new StringReader(base64PrivateKey);
            BufferedReader reader = new BufferedReader(certReader);
            PEMParser pemParser = new PEMParser((Reader)reader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object object = pemParser.readObject();
            KeyPair kp = converter.getKeyPair((PEMKeyPair)object);
            privateKey = kp.getPrivate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return privateKey;
    }

    public static PrivateKey getPrivateKey(String base64PrivateKey) {
        base64PrivateKey = RSAUtil.extractPemBlock(base64PrivateKey);
        PrivateKey privateKey = null;
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(base64PrivateKey.getBytes()));
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return privateKey;
    }

    public static byte[] encrypt(String data, String publicKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
        cipher.init(1, RSAUtil.getPublicKey(publicKey));
        return cipher.doFinal(data.getBytes());
    }

    public static String decrypt(byte[] data, PrivateKey privateKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(data));
    }

    public static String extractPemBlock(String pem) {
        if (pem == null) {
            throw new IllegalArgumentException("Invalid pem(null)");
        }
        ArrayList<String> ret = new ArrayList<String>();
        String[] pemLines = pem.split("(\r\n)|(\r)|(\n)");
        boolean isInPem = false;
        for (String pemLine : pemLines) {
            if (isInPem) {
                if (pemLine.trim().startsWith("-----END ")) break;
                ret.add(pemLine.trim());
            }
            if (!pemLine.trim().startsWith("-----BEGIN ")) continue;
            isInPem = true;
        }
        return String.join((CharSequence)"", ret);
    }

    public static byte[] encrypt256(String data, String publicKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        if (!$assertionsDisabled && cipher == null) {
            throw new AssertionError();
        }
        cipher.init(1, RSAUtil.getPublicKey(publicKey));
        return cipher.doFinal(data.getBytes());
    }

    public static String decrypt(String data, String base64PrivateKey) throws IllegalBlockSizeException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        return RSAUtil.decrypt(Base64.getDecoder().decode(data.getBytes()), RSAUtil.getPrivateKey(base64PrivateKey));
    }

    public static byte[] encryptRsaOaepSha256(PublicKey publicKey, byte[] content) {
        try {
            AlgorithmParameters algp = AlgorithmParameters.getInstance("OAEP");
            OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            algp.init(paramSpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
            cipher.init(1, (Key)publicKey, algp);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException("Encrypt RSA OAEP_SHA256 failed", e);
        }
    }

    public static byte[] decryptRsaOaepSha256(PrivateKey privateKey, byte[] cipherText) {
        try {
            AlgorithmParameters algp = AlgorithmParameters.getInstance("OAEP");
            OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            algp.init(paramSpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
            cipher.init(2, (Key)privateKey, algp);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new RuntimeException("Decrypt RSA OAEP_SHA256 failed", e);
        }
    }

    public static byte[] encryptRsaOaepSha256PKCS1(PublicKey publicKey, byte[] content) {
        try {
            AlgorithmParameters algp = AlgorithmParameters.getInstance("OAEP");
            OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            algp.init(paramSpec);
            Cipher cipher = Cipher.getInstance("RSA/NONE/OAEPWithSHA-256AndMGF1Padding");
            cipher.init(1, (Key)publicKey, algp);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException("Encrypt RSA OAEP_SHA256 failed", e);
        }
    }

    public static KeyPair generateRsa2048KeyPair() {
        return RSAUtil.generateRsaKeyPair(2048);
    }

    public static KeyPair generateRsa3072KeyPair() {
        return RSAUtil.generateRsaKeyPair(3072);
    }

    public static KeyPair generateRsaKeyPair(int keySize) {
        try {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
            kpGen.initialize(keySize, new SecureRandom());
            return kpGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decryptRsaOaepSha256PKCS1(PrivateKey privateKey, byte[] cipherText) {
        try {
            AlgorithmParameters algp = AlgorithmParameters.getInstance("OAEP");
            OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            algp.init(paramSpec);
            Cipher cipher = Cipher.getInstance("RSA/NONE/OAEPWithSHA-256AndMGF1Padding");
            cipher.init(2, (Key)privateKey, algp);
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new RuntimeException("Decrypt RSA OAEP_SHA256 failed", e);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !RSAUtil.class.desiredAssertionStatus();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

