/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.crypto;

import com.aliyun.encdb.common.crypto.SymCrypto;
import org.bouncycastle.crypto.CryptoException;

public class ClwwOreCrypto {
    public static final int KEY_LENGTH = 32;
    public static final int CIPHER_LENGTH = 16;
    public static final int PLAINTEXT_LENGTH = 8;
    private static final int N_BLOCK_BYTES = 16;
    private static final int BLOCK_BITS = 6;
    private static final int TOTAL_NUM_BLOCK = 11;
    private static final long BLOCK_VALUE_MASK = 63L;

    private static int valueOfBlock(long value, int blockIdx) {
        long result = 0L;
        if (blockIdx != 0) {
            int shiftBits = 64 - blockIdx * 6;
            result = shiftBits < 0 ? value << -shiftBits & 0x3FL : value >> shiftBits & 0x3FL;
        }
        return (int)result;
    }

    private static int prfBlock(int blockValue, int blockOffset, byte[] randomBytes, int randomOffset) {
        int prefixBits = blockValue >> 6 - blockOffset;
        int prfBlockBitIdx = (1 << blockOffset) - 1 + prefixBits << 1;
        int prfByteIdx = randomOffset + prfBlockBitIdx / 8;
        int prfByteOffset = prfBlockBitIdx % 8;
        return randomBytes[prfByteIdx] >> 6 - prfByteOffset & 3;
    }

    private static byte[] encrypt(long value, byte[] key, byte[] iv) throws CryptoException {
        if (key.length != 16 || iv.length != 16) {
            throw new CryptoException("CLWW ORE encryption key/iv should have length 16");
        }
        byte[] aesInput = new byte[176];
        int pos = 0;
        for (int blockIdx = 0; blockIdx < 11; ++blockIdx) {
            int blockValue = ClwwOreCrypto.valueOfBlock(value, blockIdx);
            for (int blockOffset = 0; blockOffset < 16; ++blockOffset) {
                aesInput[pos++] = (byte)blockValue;
            }
        }
        byte[] prfRandomBytes = SymCrypto.aesCBCEncrypt(key, aesInput, iv);
        byte[] ciphertext = new byte[16];
        for (int i = 0; i < 64; ++i) {
            int byteIdx = i * 2 / 8;
            int byteOffset = i * 2 % 8;
            if (byteOffset == 0) {
                ciphertext[byteIdx] = 0;
            }
            int blockIdx = i / 6;
            int blockOffset = i % 6;
            int randomOffset = blockIdx * 16;
            int blockValue = ClwwOreCrypto.valueOfBlock(value, blockIdx + 1);
            int prfBits = ClwwOreCrypto.prfBlock(blockValue, blockOffset, prfRandomBytes, randomOffset);
            int valueBit = (int)(value >> 63 - i & 1L);
            int n = byteIdx;
            ciphertext[n] = (byte)(ciphertext[n] | (prfBits + valueBit & 3) << 6 - byteOffset);
        }
        return ciphertext;
    }

    private static long decrypt(byte[] ciphertext, byte[] key, byte[] iv) throws CryptoException {
        if (ciphertext.length != 16) {
            throw new CryptoException("CLWW ORE ciphertext should have length 16");
        }
        if (key.length != 16 || iv.length != 16) {
            throw new CryptoException("CLWW ORE decryption key/iv should have length 16");
        }
        long value = 0L;
        int blockValue = 0;
        byte[] randomBytes = iv;
        byte[] block = new byte[16];
        for (int i = 0; i < 64; ++i) {
            int byteIdx = i * 2 / 8;
            int byteOffset = i * 2 % 8;
            int blockOffset = i % 6;
            if (blockOffset == 0) {
                iv = randomBytes;
                for (int j = 0; j < block.length; ++j) {
                    block[j] = (byte)blockValue;
                }
                randomBytes = new byte[16];
                System.arraycopy(SymCrypto.aesCBCEncrypt(key, block, iv), 0, randomBytes, 0, 16);
                blockValue = 0;
            }
            int cipherBit = ciphertext[byteIdx] >> 6 - byteOffset & 3;
            int prfBits = ClwwOreCrypto.prfBlock(blockValue, blockOffset, randomBytes, 0);
            long valueBit = cipherBit + 4 - prfBits & 3;
            value |= valueBit << 63 - i;
            blockValue = (int)((long)blockValue | valueBit << 5 - blockOffset);
        }
        return value;
    }

    public static byte[] encryptLong(long value, byte[] key, byte[] iv) throws CryptoException {
        long HIGHEST_BIT = Long.MIN_VALUE;
        return ClwwOreCrypto.encrypt(value ^= Long.MIN_VALUE, key, iv);
    }

    public static byte[] encryptLong(long value, byte[] keyIv) throws CryptoException {
        if (keyIv.length != 32) {
            throw new CryptoException("CLWW ORE key-iv should have length 32");
        }
        int PART_LENGTH = 16;
        byte[] keyPart = new byte[16];
        byte[] ivPart = new byte[16];
        System.arraycopy(keyIv, 0, keyPart, 0, 16);
        System.arraycopy(keyIv, 16, ivPart, 0, 16);
        return ClwwOreCrypto.encryptLong(value, keyPart, ivPart);
    }

    public static byte[] encryptDouble(double value, byte[] key, byte[] iv) throws CryptoException {
        long longBits = Double.doubleToRawLongBits(value);
        long HIGHEST_BIT = Long.MIN_VALUE;
        long NAN_BITS = 0x7FF0000000000000L;
        if ((longBits & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            throw new CryptoException("CLWW ORE does not support encrypting nan/infinite values");
        }
        if ((longBits & Long.MIN_VALUE) == 0L) {
            longBits ^= Long.MIN_VALUE;
        } else if (longBits != Long.MIN_VALUE) {
            longBits ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return ClwwOreCrypto.encrypt(longBits, key, iv);
    }

    public static byte[] encryptDouble(double value, byte[] keyIv) throws CryptoException {
        if (keyIv.length != 32) {
            throw new CryptoException("CLWW ORE key-iv should have length 32");
        }
        int PART_LENGTH = 16;
        byte[] keyPart = new byte[16];
        byte[] ivPart = new byte[16];
        System.arraycopy(keyIv, 0, keyPart, 0, 16);
        System.arraycopy(keyIv, 16, ivPart, 0, 16);
        return ClwwOreCrypto.encryptDouble(value, keyPart, ivPart);
    }

    public static long decryptLong(byte[] ciphertext, byte[] key, byte[] iv) throws CryptoException {
        long result = ClwwOreCrypto.decrypt(ciphertext, key, iv);
        long HIGHEST_BIT = Long.MIN_VALUE;
        return result ^ Long.MIN_VALUE;
    }

    public static long decryptLong(byte[] ciphertext, byte[] keyIv) throws CryptoException {
        if (keyIv.length != 32) {
            throw new CryptoException("CLWW ORE key-iv should have length 32");
        }
        int PART_LENGTH = 16;
        byte[] keyPart = new byte[16];
        byte[] ivPart = new byte[16];
        System.arraycopy(keyIv, 0, keyPart, 0, 16);
        System.arraycopy(keyIv, 16, ivPart, 0, 16);
        return ClwwOreCrypto.decryptLong(ciphertext, keyPart, ivPart);
    }

    public static double decryptDouble(byte[] ciphertext, byte[] key, byte[] iv) throws CryptoException {
        long result = ClwwOreCrypto.decrypt(ciphertext, key, iv);
        long HIGHEST_BIT = Long.MIN_VALUE;
        result = (result & Long.MIN_VALUE) != 0L ? (result ^= Long.MIN_VALUE) : (result ^= 0xFFFFFFFFFFFFFFFFL);
        return Double.longBitsToDouble(result);
    }

    public static double decryptDouble(byte[] ciphertext, byte[] keyIv) throws CryptoException {
        if (keyIv.length != 32) {
            throw new CryptoException("CLWW ORE key-iv should have length 32");
        }
        int PART_LENGTH = 16;
        byte[] keyPart = new byte[16];
        byte[] ivPart = new byte[16];
        System.arraycopy(keyIv, 0, keyPart, 0, 16);
        System.arraycopy(keyIv, 16, ivPart, 0, 16);
        return ClwwOreCrypto.decryptDouble(ciphertext, keyPart, ivPart);
    }

    public static int compare(byte[] lval, byte[] rval) throws CryptoException {
        if (lval.length != 16 || rval.length != 16) {
            throw new CryptoException("CLWW ORE ciphertext should have length 16");
        }
        for (int i = 0; i < 64; ++i) {
            int byteIdx = i * 2 / 8;
            int byteOffset = i * 2 % 8;
            int lbits = lval[byteIdx] >> 6 - byteOffset & 3;
            int rbits = rval[byteIdx] >> 6 - byteOffset & 3;
            if (lbits == rbits) continue;
            if (lbits == (rbits + 1 & 3)) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

