/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.crypto;

import com.aliyun.encdb.common.common.Constants;
import com.aliyun.encdb.common.common.OrdinalEnum;
import com.aliyun.encdb.common.common.TeeType;
import com.aliyun.encdb.common.crypto.AsymmAlgo;
import com.aliyun.encdb.common.crypto.HashAlgo;

public class CipherSuite {
    private final Constants.EncAlgo symmAlgo;
    private final HashAlgo hashAlgo;
    private final AsymmAlgo asymmAlgo;
    final TeeType teeType;

    public TeeType getTeeType() {
        return this.teeType;
    }

    public HashAlgo getHashAlgo() {
        return this.hashAlgo;
    }

    public CipherSuite(TeeType backendTeeType, String serverInfoString) {
        this.teeType = backendTeeType;
        String[] elements = serverInfoString.split("_");
        assert (elements.length == 6);
        this.asymmAlgo = OrdinalEnum.searchEnum(AsymmAlgo.class, elements[0]);
        this.symmAlgo = OrdinalEnum.searchEnum(Constants.EncAlgo.class, elements[2] + "_" + elements[3] + "_" + elements[4]);
        this.hashAlgo = OrdinalEnum.searchEnum(HashAlgo.class, elements[5]);
    }

    public CipherSuite(TeeType backendTeeType) {
        this(backendTeeType, CipherSuite.getDefaultCipherSuiteByTeeType(backendTeeType));
    }

    public static String getDefaultCipherSuiteByTeeType(TeeType backendTeeType) {
        switch (backendTeeType) {
            case FPGA_SMX: {
                return "SM2_WITH_SM4_128_CBC_SM3";
            }
            case MOCK: {
                return "SM2_WITH_SM4_128_CBC_SM3";
            }
        }
        return "RSA_WITH_AES_128_CBC_SHA256";
    }

    public Constants.EncAlgo getSymmAlgo() {
        return this.symmAlgo;
    }

    public AsymmAlgo getAsymmAlgo() {
        return this.asymmAlgo;
    }

    public String toString() {
        return String.join((CharSequence)"_", this.asymmAlgo.toString(), "WITH", this.symmAlgo.toString(), this.hashAlgo.toString());
    }
}

