/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.crypto;

import com.aliyun.encdb.common.crypto.AsymmAlgo;
import com.aliyun.encdb.common.crypto.ConvertCipherException;
import com.aliyun.encdb.common.crypto.RSAUtil;
import com.aliyun.encdb.mysql.jdbc.external.com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.Hex;

public class AsymCrypto {
    private static final int MAX_SM2_ENCRYPTION_RETRY = 10;

    private static PrivateKey loadPrivateKey(Reader reader) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object readObject = pemParser.readObject();
            while (readObject != null) {
                PrivateKeyInfo privateKeyInfo = AsymCrypto.getPrivateKeyInfoOrNull(readObject);
                if (privateKeyInfo != null) {
                    PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                    return privateKey;
                }
                readObject = pemParser.readObject();
            }
        }
        return null;
    }

    private static PrivateKeyInfo getPrivateKeyInfoOrNull(Object pemObject) throws NoSuchAlgorithmException {
        PrivateKeyInfo privateKeyInfo = null;
        if (pemObject instanceof PEMKeyPair) {
            PEMKeyPair pemKeyPair = (PEMKeyPair)pemObject;
            privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
        } else if (pemObject instanceof PrivateKeyInfo) {
            privateKeyInfo = (PrivateKeyInfo)pemObject;
        } else {
            System.err.printf("Unknown object '{}' from PEMParser\n", pemObject);
        }
        return privateKeyInfo;
    }

    /*
     * Exception decompiling
     */
    private static PrivateKey importPrivateKey(String keypem) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PublicKey importPublicKey(String keyStr) throws IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(keyStr));){
            SubjectPublicKeyInfo pkInfo = (SubjectPublicKeyInfo)pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            PublicKey publicKey = converter.getPublicKey(pkInfo);
            return publicKey;
        }
    }

    public static byte[] rsaPKCS1EncryptPem(String pukPemString, byte[] input) throws CryptoException {
        try {
            return RSAUtil.encryptRsaOaepSha256PKCS1(RSAUtil.getPublicKeyPKCS1(pukPemString), input);
        }
        catch (Exception e) {
            throw new CryptoException("rsaEncryptPem encryption error", (Throwable)e);
        }
    }

    public static byte[] rsaPKCS1DecryptPem(String priPemString, byte[] input) throws CryptoException {
        try {
            PrivateKey privateKey = AsymCrypto.importPrivateKey(priPemString);
            return RSAUtil.decryptRsaOaepSha256PKCS1(privateKey, input);
        }
        catch (Exception e) {
            throw new CryptoException("rsaEncryptPem decryption error", (Throwable)e);
        }
    }

    @Deprecated
    public static byte[] rsaPKCS1WrapAesKey(String pukPem, byte[] key) throws CryptoException {
        try {
            PublicKey publicKey = AsymCrypto.importPublicKey(pukPem);
            Cipher c = Cipher.getInstance("RSA/None/PKCS1Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            c.init(3, publicKey);
            return c.wrap(secretKey);
        }
        catch (Exception e) {
            throw new CryptoException("rsaPKCS1WrapAesKey wrap error", (Throwable)e);
        }
    }

    @Deprecated
    public static byte[] rsaPKCS1UnwrapAesKey(String priPem, byte[] wrappedKey) throws CryptoException {
        try {
            PrivateKey privateKey = AsymCrypto.importPrivateKey(priPem);
            Cipher c = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
            c.init(4, privateKey);
            return c.unwrap(wrappedKey, "AES", 3).getEncoded();
        }
        catch (Exception e) {
            throw new CryptoException("rsaPKCS1UnwrapAesKey unwrap error", (Throwable)e);
        }
    }

    public static byte[] sm2EncryptRaw(byte[] puk, byte[] input) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(SM2Constants.MODE);
        ECPoint point = SM2Constants.CURVE.decodePoint(puk);
        ECPublicKeyParameters ecPukParam = new ECPublicKeyParameters(point, SM2Constants.DOMAIN_PARAMS);
        engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPukParam, new SecureRandom()));
        return engine.processBlock(input, 0, input.length);
    }

    public static byte[] sm2DecryptRaw(byte[] pri, byte[] input) throws InvalidCipherTextException {
        SM2Engine engine = new SM2Engine(SM2Constants.MODE);
        BigInteger d = new BigInteger(1, pri);
        ECPrivateKeyParameters ecPriparam = new ECPrivateKeyParameters(d, SM2Constants.DOMAIN_PARAMS);
        engine.init(false, (CipherParameters)ecPriparam);
        return engine.processBlock(input, 0, input.length);
    }

    public static byte[] sm2EncryptRaw(String pukString, byte[] input) throws InvalidCipherTextException {
        return AsymCrypto.sm2EncryptRaw(Hex.decode((String)pukString), input);
    }

    public static byte[] sm2DecryptRaw(String priString, byte[] input) throws InvalidCipherTextException {
        return AsymCrypto.sm2DecryptRaw(Hex.decode((String)priString), input);
    }

    private static byte[] convertSm2CipherFromAsn1Bytes(byte[] asn1Bytes) throws IOException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(asn1Bytes);
        ASN1SequenceParser asn1SequenceParser = ((ASN1Sequence)asn1InputStream.readObject()).parser();
        asn1InputStream.close();
        Byte compression = 4;
        ASN1Integer c1_x = (ASN1Integer)asn1SequenceParser.readObject().toASN1Primitive();
        ASN1Integer c1_y = (ASN1Integer)asn1SequenceParser.readObject().toASN1Primitive();
        ASN1OctetString c3 = (ASN1OctetString)asn1SequenceParser.readObject().toASN1Primitive();
        ASN1OctetString cipher = (ASN1OctetString)asn1SequenceParser.readObject().toASN1Primitive();
        ArrayList<Byte> sm2Cipher = new ArrayList<Byte>();
        sm2Cipher.add(compression);
        byte[] pointBytes = c1_x.getValue().toByteArray();
        if (pointBytes.length == 33) {
            pointBytes = Arrays.copyOfRange(pointBytes, 1, pointBytes.length);
        }
        sm2Cipher.addAll(Bytes.asList(pointBytes));
        pointBytes = c1_y.getValue().toByteArray();
        if (pointBytes.length == 33) {
            pointBytes = Arrays.copyOfRange(pointBytes, 1, pointBytes.length);
        }
        sm2Cipher.addAll(Bytes.asList(pointBytes));
        sm2Cipher.addAll(Bytes.asList(c3.getOctets()));
        sm2Cipher.addAll(Bytes.asList(cipher.getOctets()));
        return Bytes.toArray(sm2Cipher);
    }

    private static byte[] convertSm2CipherToAsn1Bytes(byte[] data, boolean compression) throws IOException, ConvertCipherException {
        byte[] uncompressedBytes = data;
        if (compression) {
            uncompressedBytes = Arrays.copyOfRange(data, 1, data.length);
        }
        BigInteger c1_x = new BigInteger(Arrays.copyOfRange(uncompressedBytes, 0, 32));
        BigInteger c1_y = new BigInteger(Arrays.copyOfRange(uncompressedBytes, 32, 64));
        if (c1_x.toByteArray().length != 32) {
            throw new ConvertCipherException("convert c1_x to BigInteger fail:\nc1_x=" + Hex.toHexString((byte[])c1_x.toByteArray()) + "\nfrom=" + Hex.toHexString((byte[])Arrays.copyOfRange(uncompressedBytes, 0, 32)));
        }
        if (c1_y.toByteArray().length != 32) {
            throw new ConvertCipherException("convert c1_y to BigInteger fail:\nc1_y=" + Hex.toHexString((byte[])c1_y.toByteArray()) + "\nfrom=" + Hex.toHexString((byte[])Arrays.copyOfRange(uncompressedBytes, 32, 64)));
        }
        BEROctetString c3 = new BEROctetString(Arrays.copyOfRange(uncompressedBytes, 64, 96));
        BEROctetString cipher = new BEROctetString(Arrays.copyOfRange(uncompressedBytes, 96, uncompressedBytes.length));
        ASN1EncodableVector encodableVector = new ASN1EncodableVector();
        encodableVector.add((ASN1Encodable)new ASN1Integer(c1_x));
        encodableVector.add((ASN1Encodable)new ASN1Integer(c1_y));
        encodableVector.add((ASN1Encodable)c3);
        encodableVector.add((ASN1Encodable)cipher);
        byte[] asn1Bytes = new DERSequence(encodableVector).getEncoded();
        return asn1Bytes;
    }

    public static byte[] sm2EncryptPem(String pubPemString, byte[] input) throws IOException, InvalidCipherTextException {
        PublicKey sm2PublicKey = AsymCrypto.importPublicKey(pubPemString);
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(((BCECPublicKey)sm2PublicKey).getQ(), SM2Constants.DOMAIN_PARAMS);
        SM2Engine engine = new SM2Engine(SM2Constants.MODE);
        int i = 10;
        String exceptionMsg = "";
        while (i-- > 0) {
            try {
                engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
                byte[] output = engine.processBlock(input, 0, input.length);
                boolean compression = (output.length - input.length) % 2 != 0;
                return AsymCrypto.convertSm2CipherToAsn1Bytes(output, compression);
            }
            catch (ConvertCipherException e) {
                exceptionMsg = e.getMessage();
            }
        }
        throw new InvalidCipherTextException(exceptionMsg);
    }

    public static byte[] sm2DecryptPem(String priPemString, byte[] input) throws InvalidCipherTextException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        PrivateKey sm2PrivateKey = AsymCrypto.importPrivateKey(priPemString);
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(((BCECPrivateKey)sm2PrivateKey).getD(), SM2Constants.DOMAIN_PARAMS);
        SM2Engine engine = new SM2Engine(SM2Constants.MODE);
        engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        byte[] decoded = AsymCrypto.convertSm2CipherFromAsn1Bytes(input);
        return engine.processBlock(decoded, 0, decoded.length);
    }

    public static byte[] signRsaWithSha256(String priPemString, byte[] input) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException, InvalidKeySpecException, IOException, InvalidAlgorithmParameterException {
        PrivateKey privateKey = AsymCrypto.importPrivateKey(priPemString);
        Signature signature = Signature.getInstance("SHA256withRSA/PSS", "BC");
        signature.setParameter(new PSSParameterSpec("SHA256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
        signature.initSign(privateKey);
        signature.update(input);
        return signature.sign();
    }

    public static boolean verifyRsaWithSha256(String pukPemString, byte[] input, byte[] sig) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException, InvalidAlgorithmParameterException {
        PublicKey publicKey = AsymCrypto.importPublicKey(pukPemString);
        Signature signature = Signature.getInstance("SHA256withRSA/PSS", "BC");
        signature.setParameter(new PSSParameterSpec("SHA256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
        signature.initVerify(publicKey);
        signature.update(input);
        return signature.verify(sig);
    }

    public static byte[] sm2SignPem(String priPemString, byte[] input) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchProviderException, InvalidKeyException, SignatureException, CryptoException {
        PrivateKey sm2PrivateKey = AsymCrypto.importPrivateKey(priPemString);
        Signature signature = Signature.getInstance("SM3withSM2", "BC");
        signature.initSign(sm2PrivateKey);
        signature.update(input);
        return signature.sign();
    }

    public static boolean sm2VerifyPem(String pubPemString, byte[] input, byte[] sig) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        PublicKey sm2PublicKey = AsymCrypto.importPublicKey(pubPemString);
        Signature signature = Signature.getInstance("SM3withSM2", "BC");
        signature.initVerify(sm2PublicKey);
        signature.update(input);
        return signature.verify(sig);
    }

    public static byte[] sm2SignRaw(byte[] pri, byte[] input) throws CryptoException {
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(new BigInteger(1, pri), SM2Constants.DOMAIN_PARAMS);
        SM2Signer signer = new SM2Signer();
        signer.init(true, (CipherParameters)privateKeyParameters);
        signer.update(input, 0, input.length);
        return signer.generateSignature();
    }

    public static boolean sm2VerifyRaw(byte[] puk, byte[] input, byte[] sig) {
        ECPoint ecPoint = SM2Constants.CURVE.decodePoint(puk);
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(ecPoint, SM2Constants.DOMAIN_PARAMS);
        SM2Signer signer = new SM2Signer();
        signer.init(false, (CipherParameters)ecPublicKeyParameters);
        signer.update(input, 0, input.length);
        return signer.verifySignature(sig);
    }

    public static byte[] sign(AsymmAlgo alg, String priPemString, byte[] input) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeySpecException, InvalidAlgorithmParameterException, IOException, CryptoException {
        switch (alg) {
            case RSA: {
                return AsymCrypto.signRsaWithSha256(priPemString, input);
            }
            case SM2: {
                return AsymCrypto.sm2SignPem(priPemString, input);
            }
        }
        throw new RuntimeException("Panic! Not support signature algorithm");
    }

    public static boolean verify(AsymmAlgo alg, String pubPemString, byte[] input, byte[] sig) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, InvalidAlgorithmParameterException, IOException {
        switch (alg) {
            case RSA: {
                return AsymCrypto.verifyRsaWithSha256(pubPemString, input, sig);
            }
            case SM2: {
                return AsymCrypto.sm2VerifyPem(pubPemString, input, sig);
            }
        }
        throw new RuntimeException("Panic! Not support signature algorithm");
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static class SM2Constants {
        public static final SM2P256V1Curve CURVE = new SM2P256V1Curve();
        public static final BigInteger SM2_ECC_P = CURVE.getQ();
        public static final BigInteger SM2_ECC_A = CURVE.getA().toBigInteger();
        public static final BigInteger SM2_ECC_B = CURVE.getB().toBigInteger();
        public static final BigInteger SM2_ECC_N = CURVE.getOrder();
        public static final BigInteger SM2_ECC_H = CURVE.getCofactor();
        public static final BigInteger SM2_ECC_GX = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        public static final BigInteger SM2_ECC_GY = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        public static final ECPoint G_POINT = CURVE.createPoint(SM2_ECC_GX, SM2_ECC_GY);
        public static final ECDomainParameters DOMAIN_PARAMS = new ECDomainParameters((ECCurve)CURVE, G_POINT, SM2_ECC_N, SM2_ECC_H);
        public static final SM2Engine.Mode MODE = SM2Engine.Mode.C1C3C2;
    }
}

