/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.common;

import com.aliyun.encdb.common.common.Constants;
import com.aliyun.encdb.common.common.OrdinalEnum;
import com.aliyun.encdb.common.common.TeeType;
import com.aliyun.encdb.common.common.Utils;
import com.aliyun.encdb.common.crypto.CipherSuite;
import com.aliyun.encdb.common.exception.EncdbException;
import com.aliyun.encdb.common.exception.EncdbRuntimeException;
import com.aliyun.encdb.common.json.JSON;
import com.aliyun.encdb.common.json.JSONObject;
import com.aliyun.encdb.mysql.msgio.MySQLMsgIO;
import com.aliyun.encdb.pg.msgio.SqlMsgIO;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfo {
    private static Logger logger = LoggerFactory.getLogger(ServerInfo.class);
    CipherSuite cipherSuite;
    String mrenclave;
    long mekId;
    String version;
    TeeType teeType;
    String publicKeyHash;
    String publicKey;
    public static HashMap<String, String> sdkMinCompatibleServerVer = new HashMap();
    public static HashMap<String, String> sdkSuitableCompatibleServerVer = new HashMap();

    public static ServerInfo requestServerInfo(Connection conn) {
        JSONObject request = new JSONObject();
        request.put("request_type", 0);
        request.put("version", Utils.getSDKVersion());
        try {
            byte[] recvBytes = new SqlMsgIO(conn).send_recv(request.toJSONString().getBytes(StandardCharsets.UTF_8));
            return new ServerInfo(JSON.parseObject(recvBytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EncdbException("get server info failed \n" + request.toJSONString());
        }
    }

    public static ServerInfo requestServerInfo(Connection conn, Constants.KeyMgmtType type) {
        if (type == Constants.KeyMgmtType.PG) {
            return ServerInfo.requestServerInfo(conn);
        }
        JSONObject request = new JSONObject();
        request.put("request_type", 0);
        try {
            byte[] recvBytes = new MySQLMsgIO(conn).send_recv(request.toJSONString().getBytes(StandardCharsets.UTF_8));
            return new ServerInfo(JSON.parseObject(recvBytes));
        }
        catch (Exception e) {
            logger.error("get server info failed", (Throwable)e);
            throw new EncdbRuntimeException("fatal error: get server info failed", e);
        }
    }

    public static String getServerNonce(Connection conn) {
        JSONObject request = new JSONObject();
        request.put("request_type", 1);
        try {
            byte[] recvBytes = new SqlMsgIO(conn).send_recv(request.toJSONString().getBytes(StandardCharsets.UTF_8));
            return JSON.parseObject(recvBytes).getString("nonce");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EncdbException("get server nonce failed \n" + request.toJSONString(), e);
        }
    }

    private ServerInfo(JSONObject serverInfo) throws Exception {
        if (!serverInfo.containsKey("server_info")) {
            throw new IllegalStateException("get server info failed");
        }
        if (serverInfo.containsKey("mekid")) {
            this.mekId = serverInfo.getLong("mekid");
        }
        JSONObject serverInfoDetail = serverInfo.getJSONObject("server_info");
        this.version = serverInfoDetail.getString("version");
        this.teeType = OrdinalEnum.searchEnum(TeeType.class, serverInfoDetail.getString("tee_type"));
        if (this.teeType == null) {
            throw new IllegalStateException("backend Tee type unknown=>" + serverInfoDetail.getString("tee_type"));
        }
        this.cipherSuite = new CipherSuite(this.teeType, serverInfoDetail.getString("cipher_suite"));
        if (this.teeType != TeeType.NO_TEE) {
            this.publicKey = serverInfoDetail.getString("public_key");
            this.publicKeyHash = serverInfoDetail.getString("public_key_hash");
            this.mrenclave = serverInfoDetail.getString("mrenclave");
        }
        String currentServerVer = serverInfoDetail.getString("version");
        String currentSdkVer = Utils.getSDKVersion();
        StringBuilder errMsg = new StringBuilder();
        if (!errMsg.toString().isEmpty()) {
            logger.error(errMsg.toString());
        }
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public String getMrenclave() {
        return this.mrenclave;
    }

    public long getMekId() {
        return this.mekId;
    }

    public String getVersion() {
        return this.version;
    }

    public TeeType getTeeType() {
        return this.teeType;
    }

    public String getPublicKeyHash() {
        return this.publicKeyHash;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String toString() {
        return JSON.toJSON(this).toString();
    }

    static {
        sdkMinCompatibleServerVer.put("1.2.4", "1.1.6");
        sdkMinCompatibleServerVer.put("1.2.5", "1.1.7");
        sdkMinCompatibleServerVer.put("1.2.6", "1.1.7");
        sdkMinCompatibleServerVer.put("1.2.8", "1.1.11");
        sdkMinCompatibleServerVer.put("1.2.9", "1.1.11");
        sdkMinCompatibleServerVer.put("1.2.10", "1.1.11");
        sdkMinCompatibleServerVer.put("1.2.11", "1.1.11");
        sdkMinCompatibleServerVer.put("1.2.12", "1.1.11");
        sdkMinCompatibleServerVer.put("1.2.13", "1.1.11");
        sdkMinCompatibleServerVer.put("1.2.14", "1.1.11");
        sdkSuitableCompatibleServerVer.put("1.2.8", "1.1.11");
        sdkSuitableCompatibleServerVer.put("1.2.9", "1.1.12");
        sdkSuitableCompatibleServerVer.put("1.2.10", "1.1.12");
        sdkSuitableCompatibleServerVer.put("1.2.11", "1.1.13");
        sdkSuitableCompatibleServerVer.put("1.2.12", "1.1.13");
        sdkSuitableCompatibleServerVer.put("1.2.13", "1.1.13");
        sdkSuitableCompatibleServerVer.put("1.2.14", "1.1.13");
    }
}

