/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.common;

import com.aliyun.encdb.common.common.OrdinalEnum;
import java.util.Arrays;

public class Constants {
    public static boolean VERBOSE = false;
    public static boolean SHOW_RA_LOG = false;
    public static boolean BYPASS_RA = false;
    public static final String ROOT_KEY_ACL = "ACL";
    public static final String ACL_KEY_ALLOW_ENTRIES = "allow entries";
    public static final String ACL_KEY_MAC = "mac";
    public static final String OWNER_ID = "ownerID";
    public static final String USERNAME = "username";
    public static final String USER_ID = "userID";
    public static final int ENCDB_KEY_SIZE = 16;
    public static final int ENCDB_IV_SIZE = 12;
    public static final int ENCDB_MAC_SIZE = 16;
    public static final String ENCDB_SDK_VER = "1.2.18";
    public static final int CIPHER_VERSION_0_NONCE_LEN = 8;

    public static enum CipherVersionFormat {
        VERSION_0(0);

        private final int value;

        private CipherVersionFormat(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum KeyMgmtType {
        PG,
        MySQL;

    }

    public static enum SDKMode {
        Default,
        NoMekBypass,
        Offline,
        SimpleDek,
        ConstantDek,
        Crypto;

    }

    public static enum EncAlgo implements OrdinalEnum
    {
        AES_128_GCM(0),
        AES_128_ECB(1),
        AES_128_CTR(2),
        AES_128_CBC(3),
        SM4_128_CBC(4),
        SM4_128_ECB(5),
        SM4_128_CTR(6),
        SM4_128_GCM(7),
        CLWW_ORE(8);

        private final int val;

        private EncAlgo(int val) {
            this.val = val;
        }

        @Override
        public int getVal() {
            return this.val;
        }

        public static EncAlgo from(int i) {
            return Arrays.stream(EncAlgo.values()).filter(e -> e.val == i).findAny().orElseThrow(() -> new IllegalArgumentException("invalid value"));
        }
    }

    public static enum EncScheme implements OrdinalEnum
    {
        RND(1),
        DET(2);

        private final int val;

        private EncScheme(int i) {
            this.val = i;
        }

        @Override
        public int getVal() {
            return this.val;
        }

        public static EncScheme from(int i) {
            return Arrays.stream(EncScheme.values()).filter(e -> e.val == i).findAny().orElseThrow(() -> new IllegalArgumentException("invalid value"));
        }
    }

    public static enum DekGenMode implements OrdinalEnum
    {
        ENCLAVE(0),
        LOCAL(1);

        private final int val;

        private DekGenMode(int i) {
            this.val = i;
        }

        @Override
        public int getVal() {
            return this.val;
        }

        public static DekGenMode from(int i) {
            return Arrays.stream(DekGenMode.values()).filter(e -> e.val == i).findAny().orElseThrow(() -> new IllegalArgumentException("invalid value"));
        }
    }

    public static enum Stateless implements OrdinalEnum
    {
        NeverExpire(0),
        SessionExpire(1);

        private final int val;

        private Stateless(int val) {
            this.val = val;
        }

        @Override
        public int getVal() {
            return this.val;
        }
    }
}

