/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encdb.common.cipher;

import com.aliyun.encdb.common.common.Utils;
import com.aliyun.encdb.common.crypto.AsymCrypto;
import com.aliyun.encdb.common.crypto.AsymmAlgo;
import com.aliyun.encdb.common.crypto.CipherSuite;
import com.aliyun.encdb.common.crypto.SymCrypto;
import com.aliyun.encdb.mysql.jdbc.external.com.google.common.primitives.Bytes;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.bouncycastle.crypto.CryptoException;

public class Envelope {
    byte[] encryptedKey;
    byte[] data;
    CipherSuite cipherSuite;

    public Envelope(byte[] data) {
        this.data = data;
    }

    public byte[] getBytes() throws DataFormatException {
        int bufSize = 2 + this.encryptedKey.length + this.data.length;
        ByteBuffer buf = ByteBuffer.allocate(bufSize).order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort((short)this.encryptedKey.length);
        buf.put(this.encryptedKey);
        buf.put(this.data);
        return buf.array();
    }

    public static Envelope fromBytes(byte[] bytes) throws DataFormatException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            Envelope env = new Envelope(null);
            short encryptedKeyLen = buf.getShort();
            env.encryptedKey = new byte[encryptedKeyLen];
            buf.get(env.encryptedKey);
            int dataLen = buf.remaining();
            env.data = new byte[dataLen];
            buf.get(env.data);
            return env;
        }
        catch (BufferUnderflowException e) {
            throw new DataFormatException("Wrong encdb envelope bytes");
        }
    }

    public Envelope seal(String pukString, boolean usePemSMx) throws CryptoException, IOException {
        SecureRandom sr = new SecureRandom();
        byte[] tempKey = null;
        byte[] iv = null;
        byte[] tempData = null;
        ArrayList<Byte> encryptedDataBlob = new ArrayList<Byte>();
        assert (this.cipherSuite != null);
        if (this.cipherSuite.getAsymmAlgo() == AsymmAlgo.SM2 && this.cipherSuite.getSymmAlgo().name().startsWith("SM4")) {
            tempKey = new byte[16];
            switch (this.cipherSuite.getSymmAlgo()) {
                case SM4_128_CBC: {
                    iv = new byte[16];
                    sr.nextBytes(tempKey);
                    sr.nextBytes(iv);
                    encryptedDataBlob.addAll(Bytes.asList(iv));
                    tempData = SymCrypto.sm4CBCEncrypt(tempKey, this.data, iv);
                    encryptedDataBlob.addAll(Bytes.asList(tempData));
                    break;
                }
                case SM4_128_GCM: {
                    iv = new byte[12];
                    sr.nextBytes(tempKey);
                    sr.nextBytes(iv);
                    encryptedDataBlob.addAll(Bytes.asList(iv));
                    tempData = SymCrypto.sm4GcmEncrypt(tempKey, this.data, iv);
                    encryptedDataBlob.addAll(Utils.swapBytesByPivot(tempData, tempData.length - 16));
                    break;
                }
                default: {
                    throw new CryptoException("invalid algorithm " + this.cipherSuite.getSymmAlgo().name());
                }
            }
            this.data = Bytes.toArray(encryptedDataBlob);
            this.encryptedKey = usePemSMx ? AsymCrypto.sm2EncryptPem(pukString, tempKey) : AsymCrypto.sm2EncryptRaw(pukString, tempKey);
        } else if (this.cipherSuite.getAsymmAlgo() == AsymmAlgo.RSA && this.cipherSuite.getSymmAlgo().name().startsWith("AES")) {
            tempKey = new byte[16];
            switch (this.cipherSuite.getSymmAlgo()) {
                case AES_128_CBC: {
                    iv = new byte[16];
                    sr.nextBytes(tempKey);
                    sr.nextBytes(iv);
                    encryptedDataBlob.addAll(Bytes.asList(iv));
                    tempData = SymCrypto.aesCBCEncrypt(tempKey, this.data, iv);
                    encryptedDataBlob.addAll(Bytes.asList(tempData));
                    break;
                }
                case AES_128_GCM: {
                    iv = new byte[12];
                    sr.nextBytes(tempKey);
                    sr.nextBytes(iv);
                    encryptedDataBlob.addAll(Bytes.asList(iv));
                    tempData = SymCrypto.aesGcmEncrypt(tempKey, this.data, iv);
                    encryptedDataBlob.addAll(Utils.swapBytesByPivot(tempData, tempData.length - 16));
                    break;
                }
                default: {
                    throw new CryptoException("invalid algorithm " + this.cipherSuite.getSymmAlgo().name());
                }
            }
            this.data = Bytes.toArray(encryptedDataBlob);
            this.encryptedKey = AsymCrypto.rsaPKCS1EncryptPem(pukString, tempKey);
        } else {
            throw new CryptoException("Not supported seal algorithm");
        }
        return this;
    }

    public Envelope seal(String pukString) throws CryptoException, IOException {
        return this.seal(pukString, pukString.startsWith("-----BEGIN"));
    }

    public byte[] open(String priString) throws CryptoException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return this.open(priString, priString.startsWith("-----BEGIN"));
    }

    public byte[] open(String priString, boolean usePemSMx) throws CryptoException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        byte[] plaintext = null;
        byte[] tempKey = null;
        byte[] iv = null;
        byte[] tempData = null;
        List<Byte> encryptedDataBlob = Bytes.asList(this.data);
        int idx = 0;
        iv = Bytes.toArray(encryptedDataBlob.subList(0, idx + 16));
        tempData = Bytes.toArray(encryptedDataBlob.subList(16, encryptedDataBlob.size()));
        assert (this.cipherSuite != null);
        if (this.cipherSuite.getAsymmAlgo() == AsymmAlgo.SM2 && this.cipherSuite.getSymmAlgo().name().startsWith("SM4")) {
            tempKey = usePemSMx ? AsymCrypto.sm2DecryptPem(priString, this.encryptedKey) : AsymCrypto.sm2DecryptRaw(priString, this.encryptedKey);
            plaintext = SymCrypto.sm4CBCDecrypt(tempKey, tempData, iv);
        } else if (this.cipherSuite.getAsymmAlgo() == AsymmAlgo.RSA && this.cipherSuite.getSymmAlgo().name().startsWith("AES")) {
            tempKey = AsymCrypto.rsaPKCS1DecryptPem(priString, this.encryptedKey);
            plaintext = SymCrypto.aesCBCDecrypt(tempKey, tempData, iv);
        } else {
            throw new CryptoException("Not supported seal algorithm");
        }
        return plaintext;
    }

    public Envelope setCiperSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
        return this;
    }
}

