# HTTPDNS Node.js SDK 示例

本目录包含了 HTTPDNS Node.js SDK 的各种使用示例，帮助开发者快速上手和集成。

## 目录结构

### 📄 网络库集成示例
- `axios-integration.js` - Axios HTTP 客户端集成
- `urllib-integration.js` - urllib 网络库集成
- `oss-integration.js` - 阿里云 OSS SDK 集成示例

## 快速开始

1. 安装依赖：
```bash
npm install
```

2. 配置账户信息：
```javascript
const client = createClient({
  accountId: 'your-account-id',
  secretKey: 'your-secret-key'
});
```

3. 运行示例：
```bash
# Axios 集成
node examples/axios-integration.js

# urllib 集成
node examples/urllib-integration.js

# OSS 集成
node examples/oss-integration.js
```

## 功能特性

所有网络适配示例都已实现：
- **多 IP 故障转移**：返回所有 HTTPDNS IP，支持自动切换
- **自动重试机制**：连接失败时自动降级到系统 DNS
- **智能错误处理**：完善的错误检测和处理机制
- **生产环境就绪**：稳定可靠的网络连接

## 注意事项

- 请确保已正确配置 HTTPDNS 账户信息
- 所有示例都包含完整的错误处理和降级机制
- 推荐使用非阻塞解析方式获得最佳性能