from alibabacloud_tea_util import models as util_models
from alibabacloud_ecs20140526.client import Client as Ecs20140526Client
from alibabacloud_ecs20140526 import models as ecs_20140526_models
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_bssopenapi20171214.client import Client as BssOpenApi20171214Client
from dashscope import Application
import os
import dashscope

dashscope.base_http_api_url = 'https://dashscope-intl.aliyuncs.com/api/v1'
class ECS:
    @classmethod
    # Input: Region ID, such as cn-hangzhou, cn-beijing, or ap-southeast-1.
    # Output: ECS instance type information, including instance ID, instance type, and hourly charge. (The system disk is cloud_auto by default, with a size of 40 GiB.)
    def query_source(cls,RegionID):
        config = open_api_models.Config(
                # Obtain the AccessKey information of Alibaba Cloud from an environment variable.
                access_key_id=os.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"),
                access_key_secret=os.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET")
            )
        # The endpoints for regions such as China (Hangzhou), China (Beijing), and Shanghai are different. This is determined here.
        config.endpoint = f'ecs.{RegionID}.aliyuncs.com'
        client = Ecs20140526Client(config)
        describe_instances_request = ecs_20140526_models.DescribeInstancesRequest(region_id=RegionID)
        runtime = util_models.RuntimeOptions()
        # Obtain ECS instance information.
        response_source = client.describe_instances_with_options(describe_instances_request, runtime).body
        if len(response_source.instances.instance) == 0:
            return "You have no ECS instances in the current region."
        # Initialize the result to be returned.
        result = ""
        # There may be multiple instances, so a for loop is used to traverse all instances.
        for i in range(len(response_source.instances.instance)):
            # System disk type and storage space. Here, the default values are cloud_auto and 40 GiB.
            system_disk = ecs_20140526_models.DescribePriceRequestSystemDisk(
                category='cloud_auto',
                size=40
            )
            describe_price_request = ecs_20140526_models.DescribePriceRequest(
                region_id=RegionID,
                resource_type='instance',
                instance_type=response_source.instances.instance[i].instance_type,
                system_disk=system_disk
            )
            response = client.describe_price_with_options(describe_price_request, runtime).body
            cur_result = f"""The instance type of instance {response_source.instances.instance[i].instance_id} is {response_source.instances.instance[i].instance_type}.
    The hourly charge is {response.price_info.price.trade_price} USD.\n"""
            # Add the information of the current instance to the result.
            result += cur_result
        return result
    @classmethod
    # RAG application call
    def call_agent_app(cls,InstanceType):
        if len(InstanceType) == 0:
            return "You have no ECS instances in the current region."
        result = ""
        for i in range(len(InstanceType)):
            response = Application.call(
                # Enter the app_id of the RAG application here.
                app_id='xxx',
                prompt=f'Introduce {InstanceType[i]}',
                # Obtain the API Key for Dashscope from an environment variable.
                api_key=os.getenv("DASHSCOPE_API_KEY"))
            result += response.output.text
        return result

class Billing:
    # No input is required. The Alibaba Cloud account balance information is returned.
    @classmethod
    def get_balance(cls):
        # Create a client.
        config = open_api_models.Config(
            # Required. Make sure that the ALIBABA_CLOUD_ACCESS_KEY_ID environment variable is set in the code execution environment.
            access_key_id=os.environ['ALIBABA_CLOUD_ACCESS_KEY_ID'],
            # Required. Make sure that the ALIBABA_CLOUD_ACCESS_KEY_SECRET environment variable is set in the code execution environment.
            access_key_secret=os.environ['ALIBABA_CLOUD_ACCESS_KEY_SECRET']
        )
        # For the endpoint, see https://api.aliyun.com/product/BssOpenApi.
        config.endpoint = f'business.ap-southeast-1.aliyuncs.com'
        runtime = util_models.RuntimeOptions()
        client = BssOpenApi20171214Client(config)
        balance_info = client.query_account_balance_with_options(runtime).body.data
        return f"""The currency is {balance_info.currency}, the available amount is {balance_info.available_amount}, the credit balance is {balance_info.credit_amount},
        the Mybank balance is {balance_info.mybank_credit_amount}, the cash balance is {balance_info.available_cash_amount}, and the quota limit for ecological customers is {balance_info.quota_limit}."""

if __name__ == '__main__':
    print(Billing.get_balance())
    print(ECS.query_source('ap-southeast-1'))
