/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.jdbc;

import com.aliyun.polardb2.util.GT;
import com.aliyun.polardb2.util.PSQLException;
import com.aliyun.polardb2.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public class PgBlobBytea
implements Blob {
    private byte[] data;
    private boolean freed = false;
    protected static final int MAX_BYTES = 0x40000000;

    public PgBlobBytea() {
        this.data = new byte[0];
    }

    public PgBlobBytea(byte[] in) throws SQLException {
        if (in != null && in.length > 0x40000000) {
            throw new PSQLException(GT.tr("Input data too long for bytea type Blob {0}", in.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.data = in;
    }

    @Override
    public void free() {
        if (!this.freed) {
            this.data = new byte[0];
        }
        this.freed = true;
    }

    private void checkIfFreed() throws SQLException {
        if (this.freed) {
            throw new SQLException("Operation forbidden on freed Blob");
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkIfFreed();
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkIfFreed();
        if (this.data == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (pos < 1L) {
            throw new PSQLException(GT.tr("Invalid pos parameter {0}", pos), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (length < 0L || pos + length - 1L > (long)this.data.length) {
            throw new PSQLException(GT.tr("Invalid length parameter {0}", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        byte[] part = new byte[(int)length];
        System.arraycopy(this.data, (int)pos - 1, part, 0, (int)length);
        return new ByteArrayInputStream(part);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkIfFreed();
        if (this.data == null) {
            return this.data;
        }
        if (pos < 1L) {
            throw new PSQLException(GT.tr("Invalid pos parameter {0}", pos), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid length parameter {0}", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if ((int)(--pos) + length > this.data.length) {
            length = this.data.length - (int)pos;
        }
        byte[] part = new byte[length];
        System.arraycopy(this.data, (int)pos, part, 0, length);
        return part;
    }

    @Override
    public long length() throws SQLException {
        this.checkIfFreed();
        return this.data == null ? 0L : (long)this.data.length;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkIfFreed();
        if (this.data == null) {
            return -1L;
        }
        if (start < 1L || start > (long)this.data.length) {
            throw new PSQLException(GT.tr("Invalid start parameter {0}", start), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int res = PgBlobBytea.indexOf(this.data, pattern, (int)start - 1);
        if (res >= 0) {
            ++res;
        }
        return res;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkIfFreed();
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkIfFreed();
        return new ByteaBlobOutputStream(pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkIfFreed();
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkIfFreed();
        if (this.data == null) {
            if (pos == 1L) {
                this.data = new byte[0];
            } else {
                throw new PSQLException(GT.tr("Called setBytes on null Blob", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        if (pos < 1L || pos > (long)(this.data.length + 1)) {
            throw new PSQLException(GT.tr("Invalid pos parameter {0} for length {1}", pos, this.data.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (offset < 0) {
            throw new PSQLException(GT.tr("Invalid offset parameter {0}", offset), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (offset + len > bytes.length) {
            throw new PSQLException(GT.tr("Invalid offset/len parameters {0}/{1} for length {2}", offset, len, bytes.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (--pos + (long)len > (long)this.data.length) {
            this.data = Arrays.copyOf(this.data, (int)pos + len);
        }
        System.arraycopy(bytes, offset, this.data, (int)pos, len);
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkIfFreed();
        if (this.data == null) {
            throw new PSQLException(GT.tr("Called truncate on null Blob}", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len > (long)this.data.length) {
            throw new PSQLException(GT.tr("Called truncate with length too long for string of length {0}", this.data.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.data = Arrays.copyOf(this.data, (int)len);
    }

    private static int indexOf(byte[] haystack, byte[] needle, int offset) {
        if (needle == null || needle.length == 0) {
            return -1;
        }
        if (haystack == null || needle.length > haystack.length) {
            return -1;
        }
        int pos = 1;
        int cnd = 0;
        int[] next = new int[needle.length + 1];
        next[0] = -1;
        while (pos < needle.length) {
            if (needle[pos] == needle[cnd]) {
                next[pos] = next[cnd];
            } else {
                next[pos] = cnd;
                while (cnd >= 0 && needle[pos] != needle[cnd]) {
                    cnd = next[cnd];
                }
            }
            ++pos;
            ++cnd;
        }
        int j = offset;
        int k = 0;
        while (j < haystack.length) {
            if (needle[k] == haystack[j]) {
                ++j;
                if (++k != needle.length) continue;
                return j - k;
            }
            if ((k = next[k]) >= 0) continue;
            ++j;
            ++k;
        }
        return -1;
    }

    private class ByteaBlobOutputStream
    extends OutputStream {
        private int writePos;

        ByteaBlobOutputStream(long pos) {
            this.writePos = (int)pos;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] nb = new byte[]{(byte)b};
            this.write(nb);
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                this.writePos += PgBlobBytea.this.setBytes(this.writePos, b, 0, b.length);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.writePos += PgBlobBytea.this.setBytes(this.writePos, b, off, len);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

