/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.core;

import com.aliyun.polardb2.PGProperty;
import com.aliyun.polardb2.ssl.LibPQFactory;
import com.aliyun.polardb2.util.GT;
import com.aliyun.polardb2.util.ObjectFactory;
import com.aliyun.polardb2.util.PSQLException;
import com.aliyun.polardb2.util.PSQLState;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws PSQLException {
        String socketFactoryClassName = PGProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return (SocketFactory)ObjectFactory.instantiate(socketFactoryClassName, info, true, PGProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws PSQLException {
        String classname = PGProperty.SSL_FACTORY.get(info);
        if (classname == null || "com.aliyun.polardb2.ssl.jdbc4.LibPQFactory".equals(classname) || "com.aliyun.polardb2.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info);
        }
        try {
            return (SSLSocketFactory)ObjectFactory.instantiate(classname, info, true, PGProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

