/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.serdes;

import com.google.gson.Gson;
import com.ververica.models.Alert;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.kafka.clients.producer.ProducerRecord;

public class AlertSerializer
implements KafkaRecordSerializationSchema<Alert> {
    private final String topic;
    private transient Gson gson;

    public AlertSerializer(String topic) {
        this.topic = topic;
    }

    @Override
    public void open(SerializationSchema.InitializationContext context, KafkaRecordSerializationSchema.KafkaSinkContext sinkContext) throws Exception {
        this.gson = new Gson();
        KafkaRecordSerializationSchema.super.open(context, sinkContext);
    }

    @Override
    @Nullable
    public ProducerRecord<byte[], byte[]> serialize(Alert alert, KafkaRecordSerializationSchema.KafkaSinkContext kafkaSinkContext, Long aLong) {
        byte[] key = alert.getUserSession().getBytes();
        byte[] value = this.gson.toJson(alert).getBytes();
        return new ProducerRecord<byte[], byte[]>(this.topic, key, value);
    }
}

