/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.config;

import io.confluent.kafka.serializers.KafkaJsonSerializer;
import java.util.Properties;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.kafka.common.serialization.StringSerializer;

public class AppConfig {
    public static final String BOOTSTRAP_URL = "";
    public static final String CLICKEVENT_TOPIC = "clickevent";
    public static final String ALERTS_TOPIC = "alerts";
    public static final String CONSUMER_ID = "clickstream.consumer";

    public static Properties buildProducerProps() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", BOOTSTRAP_URL);
        properties.put("key.serializer", StringSerializer.class.getCanonicalName());
        properties.put("value.serializer", KafkaJsonSerializer.class.getCanonicalName());
        properties.put("acks", "1");
        return AppConfig.buildSecurityProps(properties);
    }

    public static Properties buildSecurityProps(Properties properties) {
        properties.put("security.protocol", "SASL_SSL");
        properties.put("sasl.mechanism", "SCRAM-SHA-256");
        properties.put("sasl.jaas.config", "org.apache.kafka.common.security.scram.ScramLoginModule required username=" + properties.get("kafka.username") + " password=" + properties.get("kafka.password") + ";");
        return properties;
    }

    public static Properties buildArgsProps(Properties properties, MultipleParameterTool params) {
        String bootstrapServers = params.get("bootstrap.servers");
        properties.setProperty("bootstrap.servers", bootstrapServers);
        if (params.has("clickstream_topic")) {
            properties.setProperty("clickstream_topic", params.get("clickstream_topic"));
        }
        if (params.has("group")) {
            properties.setProperty("group", params.get("group"));
        }
        if (params.has("alerts_topic")) {
            properties.setProperty("alerts_topic", params.get("alerts_topic"));
        }
        return properties;
    }
}

