/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.Family;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactOrderedSketch;
import org.apache.datasketches.theta.DirectCompactUnorderedSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapAlphaSketch;
import org.apache.datasketches.theta.HeapCompactOrderedSketch;
import org.apache.datasketches.theta.HeapCompactUnorderedSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateReturnState;
import org.apache.datasketches.theta.UpdateSketchBuilder;

public abstract class UpdateSketch
extends Sketch {
    UpdateSketch() {
    }

    public static UpdateSketch wrap(WritableMemory srcMem) {
        return UpdateSketch.wrap(srcMem, 9001L);
    }

    public static UpdateSketch wrap(WritableMemory srcMem, long seed) {
        int preLongs = srcMem.getByte(0L) & 0x3F;
        int serVer = srcMem.getByte(1L) & 0xFF;
        int familyID = srcMem.getByte(2L) & 0xFF;
        Family family = Family.idToFamily(familyID);
        if (family != Family.QUICKSELECT) {
            throw new SketchesArgumentException("A " + (Object)((Object)family) + " sketch cannot be wrapped as an UpdateSketch.");
        }
        if (serVer == 3 && preLongs == 3) {
            return DirectQuickSelectSketch.writableWrap(srcMem, seed);
        }
        throw new SketchesArgumentException("Corrupted: An UpdateSketch image: must have SerVer = 3 and preLongs = 3");
    }

    public static UpdateSketch heapify(Memory srcMem) {
        return UpdateSketch.heapify(srcMem, 9001L);
    }

    public static UpdateSketch heapify(Memory srcMem, long seed) {
        Family family = Family.idToFamily(srcMem.getByte(2L));
        if (family.equals((Object)Family.ALPHA)) {
            return HeapAlphaSketch.heapifyInstance(srcMem, seed);
        }
        return HeapQuickSelectSketch.heapifyInstance(srcMem, seed);
    }

    @Override
    public CompactSketch compact() {
        return this.compact(true, null);
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory dstMem) {
        int curCount = this.getRetainedEntries(true);
        long thetaLong = this.getThetaLong();
        thetaLong = Sketch.thetaOnCompact(this.isEmpty(), curCount, thetaLong);
        boolean empty = Sketch.emptyFromCountAndTheta(curCount, thetaLong);
        if (empty) {
            EmptyCompactSketch sk = EmptyCompactSketch.getInstance();
            if (dstMem != null) {
                dstMem.putByteArray(0L, sk.toByteArray(), 0, 8);
            }
            return sk;
        }
        if (thetaLong == Long.MAX_VALUE && curCount == 1) {
            long[] cache = this.getCache();
            long[] cacheOut = CompactSketch.compactCache(cache, curCount, thetaLong, dstOrdered);
            long hash = cacheOut[0];
            SingleItemSketch sis = new SingleItemSketch(hash, this.getSeedHash());
            if (dstMem != null) {
                dstMem.putByteArray(0L, sis.toByteArray(), 0, 16);
            }
            return new SingleItemSketch(hash, this.getSeedHash());
        }
        if (dstMem == null) {
            return UpdateSketch.compactHeap(this, dstOrdered, curCount, thetaLong);
        }
        return UpdateSketch.compactDirect(this, dstMem, dstOrdered, curCount, thetaLong);
    }

    private static CompactSketch compactHeap(UpdateSketch sketch, boolean ordered, int curCount, long thetaLong) {
        short seedHash = sketch.getSeedHash();
        long[] cache = sketch.getCache();
        long[] cacheOut = CompactSketch.compactCache(cache, curCount, thetaLong, ordered);
        if (ordered) {
            return new HeapCompactOrderedSketch(cacheOut, false, seedHash, curCount, thetaLong);
        }
        return new HeapCompactUnorderedSketch(cacheOut, false, seedHash, curCount, thetaLong);
    }

    static CompactSketch compactDirect(UpdateSketch sketch, WritableMemory dstMem, boolean ordered, int curCount, long thetaLong) {
        int preLongs = UpdateSketch.computeCompactPreLongs(thetaLong, false, curCount);
        short seedHash = sketch.getSeedHash();
        long[] cache = sketch.getCache();
        long[] compactCache = CompactSketch.compactCache(cache, curCount, thetaLong, ordered);
        if (ordered) {
            int flags = 26;
            CompactSketch.loadCompactMemory(compactCache, seedHash, curCount, thetaLong, dstMem, (byte)26, preLongs);
            return new DirectCompactOrderedSketch(dstMem);
        }
        int flags = 10;
        CompactSketch.loadCompactMemory(compactCache, seedHash, curCount, thetaLong, dstMem, (byte)10, preLongs);
        return new DirectCompactUnorderedSketch(dstMem);
    }

    @Override
    public boolean isCompact() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    public static final UpdateSketchBuilder builder() {
        return new UpdateSketchBuilder();
    }

    public abstract void reset();

    public abstract UpdateSketch rebuild();

    public abstract ResizeFactor getResizeFactor();

    public UpdateReturnState update(long datum) {
        long[] data = new long[]{datum};
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(String datum) {
        if (datum == null || datum.isEmpty()) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(byte[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(char[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(int[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(long[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    abstract UpdateReturnState hashUpdate(long var1);

    abstract int getLgArrLongs();

    public abstract int getLgNomLongs();

    abstract float getP();

    abstract long getSeed();

    abstract boolean isDirty();

    abstract boolean isOutOfSpace(int var1);

    static void checkUnionQuickSelectFamily(Memory mem, int preambleLongs, int lgNomLongs) {
        int familyID = PreambleUtil.extractFamilyID(mem);
        Family family = Family.idToFamily(familyID);
        if (family.equals((Object)Family.UNION)) {
            if (preambleLongs != Family.UNION.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for UNION: " + preambleLongs);
            }
        } else if (family.equals((Object)Family.QUICKSELECT)) {
            if (preambleLongs != Family.QUICKSELECT.getMinPreLongs()) {
                throw new SketchesArgumentException("Possible corruption: Invalid PreambleLongs value for QUICKSELECT: " + preambleLongs);
            }
        } else {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
        if (lgNomLongs < 4) {
            throw new SketchesArgumentException("Possible corruption: Current Memory lgNomLongs < min required size: " + lgNomLongs + " < " + 4);
        }
    }

    static void checkMemIntegrity(Memory srcMem, long seed, int preambleLongs, int lgNomLongs, int lgArrLongs) {
        int serVer = PreambleUtil.extractSerVer(srcMem);
        if (serVer != 3) {
            throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
        }
        int flags = PreambleUtil.extractFlags(srcMem);
        int flagsMask = 27;
        if ((flags & 0x1B) > 0) {
            throw new SketchesArgumentException("Possible corruption: Input srcMem cannot be: big-endian, compact, ordered, or read-only");
        }
        short seedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        Util.checkSeedHashes(seedHash, Util.computeSeedHash(seed));
        long curCapBytes = srcMem.getCapacity();
        int minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        if (curCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("Possible corruption: Current Memory size < min required size: " + curCapBytes + " < " + minReqBytes);
        }
        float p = PreambleUtil.extractP(srcMem);
        long thetaLong = PreambleUtil.extractThetaLong(srcMem);
        double theta = (double)thetaLong / 9.223372036854776E18;
        if (lgArrLongs <= lgNomLongs && theta < (double)p) {
            throw new SketchesArgumentException("Possible corruption: Theta cannot be < p and lgArrLongs <= lgNomLongs. " + lgArrLongs + " <= " + lgNomLongs + ", Theta: " + theta + ", p: " + p);
        }
    }
}

