/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.UpdateSketch;

abstract class HeapUpdateSketch
extends UpdateSketch {
    final int lgNomLongs_;
    private final long seed_;
    private final float p_;
    private final ResizeFactor rf_;

    HeapUpdateSketch(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        this.lgNomLongs_ = Math.max(lgNomLongs, 4);
        this.seed_ = seed;
        this.p_ = p;
        this.rf_ = rf;
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        int preLongs = this.getCurrentPreambleLongs(compact);
        int dataLongs = this.getCurrentDataLongs(compact);
        return preLongs + dataLongs << 3;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public int getLgNomLongs() {
        return this.lgNomLongs_;
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return this.rf_;
    }

    @Override
    float getP() {
        return this.p_;
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.getSeed());
    }

    byte[] toByteArray(int preLongs, byte familyID) {
        if (this.isDirty()) {
            this.rebuild();
        }
        int preBytes = preLongs << 3 & 0x3F;
        int dataBytes = this.getCurrentDataLongs(false) << 3;
        byte[] byteArrOut = new byte[preBytes + dataBytes];
        WritableMemory memOut = WritableMemory.wrap(byteArrOut);
        int lgRf = this.getResizeFactor().lg() & 3;
        PreambleUtil.insertPreLongs(memOut, preLongs);
        PreambleUtil.insertLgResizeFactor(memOut, lgRf);
        PreambleUtil.insertSerVer(memOut, 3);
        PreambleUtil.insertFamilyID(memOut, familyID);
        PreambleUtil.insertLgNomLongs(memOut, this.getLgNomLongs());
        PreambleUtil.insertLgArrLongs(memOut, this.getLgArrLongs());
        PreambleUtil.insertSeedHash(memOut, this.getSeedHash());
        PreambleUtil.insertCurCount(memOut, this.getRetainedEntries(true));
        PreambleUtil.insertP(memOut, this.getP());
        PreambleUtil.insertThetaLong(memOut, this.getThetaLong());
        int flags = this.isEmpty() ? 4 : 0;
        PreambleUtil.insertFlags(memOut, flags);
        int arrLongs = 1 << this.getLgArrLongs();
        long[] cache = this.getCache();
        memOut.putLongArray(preBytes, cache, 0, arrLongs);
        return byteArrOut;
    }
}

