/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.DirectQuickSelectSketchR;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Rebuilder;
import org.apache.datasketches.theta.UpdateReturnState;
import org.apache.datasketches.theta.UpdateSketch;

class DirectQuickSelectSketch
extends DirectQuickSelectSketchR {
    MemoryRequestServer memReqSvr_ = null;

    private DirectQuickSelectSketch(long seed, WritableMemory wmem) {
        super(seed, wmem);
    }

    DirectQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, MemoryRequestServer memReqSvr, WritableMemory dstMem, boolean unionGadget) {
        super(seed, dstMem);
        Family family;
        int preambleLongs;
        if (unionGadget) {
            preambleLongs = Family.UNION.getMinPreLongs();
            family = Family.UNION;
        } else {
            preambleLongs = Family.QUICKSELECT.getMinPreLongs();
            family = Family.QUICKSELECT;
        }
        int lgRF = rf.lg();
        int lgArrLongs = lgRF == 0 ? lgNomLongs + 1 : 5;
        int minReqBytes = PreambleUtil.getMemBytes(lgArrLongs, preambleLongs);
        long curMemCapBytes = dstMem.getCapacity();
        if (curMemCapBytes < (long)minReqBytes) {
            throw new SketchesArgumentException("Memory capacity is too small: " + curMemCapBytes + " < " + minReqBytes);
        }
        PreambleUtil.insertPreLongs(dstMem, preambleLongs);
        PreambleUtil.insertLgResizeFactor(dstMem, lgRF);
        PreambleUtil.insertSerVer(dstMem, 3);
        PreambleUtil.insertFamilyID(dstMem, family.getID());
        PreambleUtil.insertLgNomLongs(dstMem, lgNomLongs);
        PreambleUtil.insertLgArrLongs(dstMem, lgArrLongs);
        PreambleUtil.insertFlags(dstMem, 4);
        PreambleUtil.insertSeedHash(dstMem, Util.computeSeedHash(seed));
        PreambleUtil.insertCurCount(dstMem, 0);
        PreambleUtil.insertP(dstMem, p);
        long thetaLong = (long)((double)p * 9.223372036854776E18);
        PreambleUtil.insertThetaLong(dstMem, thetaLong);
        if (unionGadget) {
            PreambleUtil.insertUnionThetaLong(dstMem, thetaLong);
        }
        dstMem.clear(preambleLongs << 3, 8 << lgArrLongs);
        this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        this.memReqSvr_ = memReqSvr;
    }

    static DirectQuickSelectSketch writableWrap(WritableMemory srcMem, long seed) {
        int preambleLongs = PreambleUtil.extractPreLongs(srcMem);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcMem);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcMem);
        UpdateSketch.checkUnionQuickSelectFamily(srcMem, preambleLongs, lgNomLongs);
        DirectQuickSelectSketch.checkMemIntegrity(srcMem, seed, preambleLongs, lgNomLongs, lgArrLongs);
        int lgRF = PreambleUtil.extractLgResizeFactor(srcMem);
        ResizeFactor myRF = ResizeFactor.getRF(lgRF);
        if (myRF == ResizeFactor.X1 && lgArrLongs != Util.startingSubMultiple(lgNomLongs + 1, myRF, 5)) {
            PreambleUtil.insertLgResizeFactor(srcMem, ResizeFactor.X2.lg());
        }
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(seed, srcMem);
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqss;
    }

    static DirectQuickSelectSketch fastWritableWrap(WritableMemory srcMem, long seed) {
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcMem);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcMem);
        DirectQuickSelectSketch dqss = new DirectQuickSelectSketch(seed, srcMem);
        dqss.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqss;
    }

    @Override
    public UpdateSketch rebuild() {
        int lgNomLongs = this.getLgNomLongs();
        int preambleLongs = this.mem_.getByte(0L) & 0x3F;
        if (this.getRetainedEntries(true) > 1 << lgNomLongs) {
            Rebuilder.quickSelectAndRebuild(this.mem_, preambleLongs, lgNomLongs);
        }
        return this;
    }

    @Override
    public void reset() {
        int arrLongs = 1 << this.getLgArrLongs();
        int preambleLongs = this.mem_.getByte(0L) & 0x3F;
        int preBytes = preambleLongs << 3;
        this.mem_.clear(preBytes, (long)arrLongs * 8L);
        this.mem_.putByte(5L, (byte)4);
        this.mem_.putInt(8L, 0);
        float p = this.mem_.getFloat(12L);
        long thetaLong = (long)((double)p * 9.223372036854776E18);
        this.mem_.putLong(16L, thetaLong);
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        int preambleLongs;
        HashOperations.checkHashCorruption(hash);
        this.mem_.putByte(5L, (byte)(this.mem_.getByte(5L) & 0xFFFFFFFB));
        long thetaLong = this.getThetaLong();
        int lgNomLongs = this.getLgNomLongs();
        if (HashOperations.continueCondition(thetaLong, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        int lgArrLongs = this.getLgArrLongs();
        int index = HashOperations.fastHashSearchOrInsert(this.mem_, lgArrLongs, hash, (preambleLongs = this.mem_.getByte(0L) & 0x3F) << 3);
        if (index >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        int curCount = this.getRetainedEntries() + 1;
        this.mem_.putInt(8L, curCount);
        if (this.isOutOfSpace(curCount)) {
            if (lgArrLongs > lgNomLongs) {
                assert (lgArrLongs == lgNomLongs + 1) : "lgArr: " + lgArrLongs + ", lgNom: " + lgNomLongs;
                Rebuilder.quickSelectAndRebuild(this.mem_, preambleLongs, lgNomLongs);
            } else {
                int lgRF = this.getLgRF();
                int actLgRF = Rebuilder.actLgResizeFactor(this.mem_.getCapacity(), lgArrLongs, preambleLongs, lgRF);
                int tgtLgArrLongs = Math.min(lgArrLongs + actLgRF, lgNomLongs + 1);
                if (actLgRF > 0) {
                    Rebuilder.resize(this.mem_, preambleLongs, lgArrLongs, tgtLgArrLongs);
                    this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, tgtLgArrLongs);
                } else {
                    int preBytes = preambleLongs << 3;
                    tgtLgArrLongs = Math.min(lgArrLongs + lgRF, lgNomLongs + 1);
                    int tgtArrBytes = 8 << tgtLgArrLongs;
                    int reqBytes = tgtArrBytes + preBytes;
                    this.memReqSvr_ = this.memReqSvr_ == null ? this.mem_.getMemoryRequestServer() : this.memReqSvr_;
                    WritableMemory newDstMem = this.memReqSvr_.request(reqBytes);
                    Rebuilder.moveAndResize(this.mem_, preambleLongs, lgArrLongs, newDstMem, tgtLgArrLongs, thetaLong);
                    this.memReqSvr_.requestClose(this.mem_, newDstMem);
                    this.mem_ = newDstMem;
                    this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(lgNomLongs, tgtLgArrLongs);
                }
            }
        }
        return UpdateReturnState.InsertedCountIncremented;
    }
}

