/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.DirectCompactSketch;

final class DirectCompactUnorderedSketch
extends DirectCompactSketch {
    DirectCompactUnorderedSketch(Memory mem) {
        super(mem);
    }

    static DirectCompactUnorderedSketch wrapInstance(Memory srcMem, long seed) {
        short memSeedHash = srcMem.getShort(6L);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        return new DirectCompactUnorderedSketch(srcMem);
    }

    static DirectCompactUnorderedSketch compact(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong, WritableMemory dstMem) {
        int preLongs = DirectCompactUnorderedSketch.computeCompactPreLongs(thetaLong, empty, curCount);
        int requiredFlags = 10;
        byte flags = (byte)(0xA | (empty ? 4 : 0));
        DirectCompactUnorderedSketch.loadCompactMemory(cache, seedHash, curCount, thetaLong, dstMem, flags, preLongs);
        return new DirectCompactUnorderedSketch(dstMem);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

