/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.MemoryHashIterator;
import org.apache.datasketches.theta.PreambleUtil;

abstract class DirectCompactSketch
extends CompactSketch {
    final Memory mem_;

    DirectCompactSketch(Memory mem) {
        this.mem_ = mem;
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        int preLongs = this.getCurrentPreambleLongs(true);
        int curCount = PreambleUtil.extractCurCount(this.mem_);
        return preLongs + curCount << 3;
    }

    @Override
    public HashIterator iterator() {
        return new MemoryHashIterator(this.mem_, this.getRetainedEntries(), this.getThetaLong());
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return PreambleUtil.extractCurCount(this.mem_);
    }

    @Override
    public long getThetaLong() {
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        return preLongs > 2 ? PreambleUtil.extractThetaLong(this.mem_) : Long.MAX_VALUE;
    }

    @Override
    public boolean hasMemory() {
        return true;
    }

    @Override
    public boolean isDirect() {
        return this.mem_.isDirect();
    }

    @Override
    public boolean isEmpty() {
        return PreambleUtil.isEmpty(this.mem_);
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.mem_.isSameResource(that);
    }

    @Override
    public byte[] toByteArray() {
        return DirectCompactSketch.compactMemoryToByteArray(this.mem_, this.getCurrentPreambleLongs(true), this.getRetainedEntries(true));
    }

    @Override
    long[] getCache() {
        int curCount = this.getRetainedEntries(true);
        if (curCount > 0) {
            long[] cache = new long[curCount];
            int preLongs = this.getCurrentPreambleLongs(true);
            this.mem_.getLongArray(preLongs << 3, cache, 0, curCount);
            return cache;
        }
        return new long[0];
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        return PreambleUtil.extractPreLongs(this.mem_);
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    short getSeedHash() {
        return (short)PreambleUtil.extractSeedHash(this.mem_);
    }

    static byte[] compactMemoryToByteArray(Memory srcMem, int preLongs, int curCount) {
        int outBytes = curCount + preLongs << 3;
        byte[] byteArrOut = new byte[outBytes];
        srcMem.getByteArray(0L, byteArrOut, 0, outBytes);
        return byteArrOut;
    }
}

