/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.QuantilesHelper;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ItemsAuxiliary;
import org.apache.datasketches.quantiles.ItemsByteArrayImpl;
import org.apache.datasketches.quantiles.ItemsMergeImpl;
import org.apache.datasketches.quantiles.ItemsPmfCdfImpl;
import org.apache.datasketches.quantiles.ItemsSketchIterator;
import org.apache.datasketches.quantiles.ItemsUtil;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.Util;

public final class ItemsSketch<T> {
    private final Comparator<? super T> comparator_;
    final int k_;
    long n_;
    T minValue_;
    T maxValue_;
    int combinedBufferItemCapacity_;
    int baseBufferCount_;
    long bitPattern_;
    Object[] combinedBuffer_;
    public static final Random rand = new Random();

    private ItemsSketch(int k, Comparator<? super T> comparator) {
        Util.checkK(k);
        this.k_ = k;
        this.comparator_ = comparator;
    }

    public static <T> ItemsSketch<T> getInstance(Comparator<? super T> comparator) {
        return ItemsSketch.getInstance(128, comparator);
    }

    public static <T> ItemsSketch<T> getInstance(int k, Comparator<? super T> comparator) {
        ItemsSketch<? super T> qs = new ItemsSketch<T>(k, comparator);
        int bufAlloc = 2 * Math.min(2, k);
        qs.n_ = 0L;
        qs.combinedBufferItemCapacity_ = bufAlloc;
        qs.combinedBuffer_ = new Object[bufAlloc];
        qs.baseBufferCount_ = 0;
        qs.bitPattern_ = 0L;
        qs.minValue_ = null;
        qs.maxValue_ = null;
        return qs;
    }

    public static <T> ItemsSketch<T> getInstance(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Memory too small: " + memCapBytes);
        }
        int preambleLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        int k = PreambleUtil.extractK(srcMem);
        ItemsUtil.checkItemsSerVer(serVer);
        if (serVer == 3 && (flags & 8) == 0) {
            throw new SketchesArgumentException("Non-compact Memory images are not supported.");
        }
        boolean empty = Util.checkPreLongsFlagsCap(preambleLongs, flags, memCapBytes);
        Util.checkFamilyID(familyID);
        ItemsSketch<? super T> qs = ItemsSketch.getInstance(k, comparator);
        if (empty) {
            return qs;
        }
        long n = PreambleUtil.extractN(srcMem);
        int extra = 2;
        int numMemItems = Util.computeRetainedItems(k, n) + 2;
        qs.n_ = n;
        qs.combinedBufferItemCapacity_ = Util.computeCombinedBufferItemCapacity(k, n);
        qs.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        qs.bitPattern_ = Util.computeBitPattern(k, n);
        qs.combinedBuffer_ = new Object[qs.combinedBufferItemCapacity_];
        int srcMemItemsOffsetBytes = preambleLongs * 8;
        Memory mReg = srcMem.region(srcMemItemsOffsetBytes, srcMem.getCapacity() - (long)srcMemItemsOffsetBytes);
        T[] itemsArray = serDe.deserializeFromMemory(mReg, numMemItems);
        super.itemsArrayToCombinedBuffer(itemsArray);
        return qs;
    }

    static <T> ItemsSketch<T> copy(ItemsSketch<T> sketch) {
        ItemsSketch<? super T> qsCopy = ItemsSketch.getInstance(sketch.k_, sketch.comparator_);
        qsCopy.n_ = sketch.n_;
        qsCopy.minValue_ = sketch.getMinValue();
        qsCopy.maxValue_ = sketch.getMaxValue();
        qsCopy.combinedBufferItemCapacity_ = sketch.getCombinedBufferAllocatedCount();
        qsCopy.baseBufferCount_ = sketch.getBaseBufferCount();
        qsCopy.bitPattern_ = sketch.getBitPattern();
        Object[] combBuf = sketch.getCombinedBuffer();
        qsCopy.combinedBuffer_ = Arrays.copyOf(combBuf, combBuf.length);
        return qsCopy;
    }

    public void update(T dataItem) {
        if (dataItem == null) {
            return;
        }
        if (this.maxValue_ == null || this.comparator_.compare(dataItem, this.maxValue_) > 0) {
            this.maxValue_ = dataItem;
        }
        if (this.minValue_ == null || this.comparator_.compare(dataItem, this.minValue_) < 0) {
            this.minValue_ = dataItem;
        }
        if (this.baseBufferCount_ + 1 > this.combinedBufferItemCapacity_) {
            ItemsSketch.growBaseBuffer(this);
        }
        this.combinedBuffer_[this.baseBufferCount_++] = dataItem;
        ++this.n_;
        if (this.baseBufferCount_ == 2 * this.k_) {
            ItemsUtil.processFullBaseBuffer(this);
        }
    }

    public T getQuantile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new SketchesArgumentException("Fraction cannot be less than zero or greater than 1.0");
        }
        if (fraction == 0.0) {
            return this.minValue_;
        }
        if (fraction == 1.0) {
            return this.maxValue_;
        }
        ItemsAuxiliary<T> aux = this.constructAuxiliary();
        return aux.getQuantile(fraction);
    }

    public T getQuantileUpperBound(double fraction) {
        return this.getQuantile(Math.min(1.0, fraction + Util.getNormalizedRankError(this.k_, false)));
    }

    public T getQuantileLowerBound(double fraction) {
        return this.getQuantile(Math.max(0.0, fraction - Util.getNormalizedRankError(this.k_, false)));
    }

    public T[] getQuantiles(double[] fRanks) {
        if (this.isEmpty()) {
            return null;
        }
        ItemsAuxiliary<T> aux = null;
        Object[] quantiles = (Object[])Array.newInstance(this.minValue_.getClass(), fRanks.length);
        for (int i = 0; i < fRanks.length; ++i) {
            double fRank = fRanks[i];
            if (fRank == 0.0) {
                quantiles[i] = this.minValue_;
                continue;
            }
            if (fRank == 1.0) {
                quantiles[i] = this.maxValue_;
                continue;
            }
            if (aux == null) {
                aux = this.constructAuxiliary();
            }
            quantiles[i] = aux.getQuantile(fRank);
        }
        return quantiles;
    }

    public T[] getQuantiles(int evenlySpaced) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getQuantiles(QuantilesHelper.getEvenlySpacedRanks(evenlySpaced));
    }

    public double getRank(T value) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        long total = 0L;
        int weight = 1;
        for (int i = 0; i < this.baseBufferCount_; ++i) {
            if (this.comparator_.compare(this.combinedBuffer_[i], value) >= 0) continue;
            total += (long)weight;
        }
        int lvl = 0;
        for (long bitPattern = this.bitPattern_; bitPattern != 0L; bitPattern >>>= 1) {
            weight *= 2;
            if ((bitPattern & 1L) > 0L) {
                int offset = (2 + lvl) * this.k_;
                for (int i = 0; i < this.k_ && this.comparator_.compare(this.combinedBuffer_[i + offset], value) < 0; ++i) {
                    total += (long)weight;
                }
            }
            ++lvl;
        }
        return (double)total / (double)this.n_;
    }

    public double[] getPMF(T[] splitPoints) {
        if (this.isEmpty()) {
            return null;
        }
        return ItemsPmfCdfImpl.getPMFOrCDF(this, splitPoints, false);
    }

    public double[] getCDF(T[] splitPoints) {
        if (this.isEmpty()) {
            return null;
        }
        return ItemsPmfCdfImpl.getPMFOrCDF(this, splitPoints, true);
    }

    public int getK() {
        return this.k_;
    }

    public T getMinValue() {
        return this.minValue_;
    }

    public T getMaxValue() {
        return this.maxValue_;
    }

    public long getN() {
        return this.n_;
    }

    @Deprecated
    public double getNormalizedRankError() {
        return Util.getNormalizedRankError(this.getK(), true);
    }

    public double getNormalizedRankError(boolean pmf) {
        return Util.getNormalizedRankError(this.k_, pmf);
    }

    @Deprecated
    public static double getNormalizedRankError(int k) {
        return Util.getNormalizedRankError(k, true);
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return Util.getNormalizedRankError(k, pmf);
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return Util.getKFromEpsilon(epsilon, pmf);
    }

    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    public void reset() {
        this.n_ = 0L;
        this.combinedBufferItemCapacity_ = 2 * Math.min(2, this.k_);
        this.combinedBuffer_ = new Object[this.combinedBufferItemCapacity_];
        this.baseBufferCount_ = 0;
        this.bitPattern_ = 0L;
        this.minValue_ = null;
        this.maxValue_ = null;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        return this.toByteArray(false, serDe);
    }

    public byte[] toByteArray(boolean ordered, ArrayOfItemsSerDe<T> serDe) {
        return ItemsByteArrayImpl.toByteArray(this, ordered, serDe);
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        return ItemsUtil.toString(sketchSummary, dataDetail, this);
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr, false);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.toString(mem, false);
    }

    public ItemsSketch<T> downSample(int newK) {
        ItemsSketch<? super T> newSketch = ItemsSketch.getInstance(newK, this.comparator_);
        ItemsMergeImpl.downSamplingMergeInto(this, newSketch);
        return newSketch;
    }

    public int getRetainedItems() {
        return Util.computeRetainedItems(this.getK(), this.getN());
    }

    public void putMemory(WritableMemory dstMem, ArrayOfItemsSerDe<T> serDe) {
        byte[] byteArr = this.toByteArray(serDe);
        long memCap = dstMem.getCapacity();
        if (memCap < (long)byteArr.length) {
            throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + byteArr.length);
        }
        dstMem.putByteArray(0L, byteArr, 0, byteArr.length);
    }

    public ItemsSketchIterator<T> iterator() {
        return new ItemsSketchIterator(this, this.bitPattern_);
    }

    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    int getCombinedBufferAllocatedCount() {
        return this.combinedBufferItemCapacity_;
    }

    long getBitPattern() {
        return this.bitPattern_;
    }

    Object[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    Comparator<? super T> getComparator() {
        return this.comparator_;
    }

    private void itemsArrayToCombinedBuffer(T[] itemsArray) {
        long bits;
        int extra = 2;
        this.minValue_ = itemsArray[0];
        this.maxValue_ = itemsArray[1];
        System.arraycopy(itemsArray, 2, this.combinedBuffer_, 0, this.baseBufferCount_);
        if (bits > 0L) {
            int index = 2 + this.baseBufferCount_;
            int level = 0;
            for (bits = this.bitPattern_; bits != 0L; bits >>>= 1) {
                if ((bits & 1L) > 0L) {
                    System.arraycopy(itemsArray, index, this.combinedBuffer_, (2 + level) * this.k_, this.k_);
                    index += this.k_;
                }
                ++level;
            }
        }
    }

    private ItemsAuxiliary<T> constructAuxiliary() {
        return new ItemsAuxiliary(this);
    }

    private static <T> void growBaseBuffer(ItemsSketch<T> sketch) {
        int newSize;
        Object[] baseBuffer = sketch.getCombinedBuffer();
        int oldSize = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        assert (oldSize < 2 * k);
        sketch.combinedBufferItemCapacity_ = newSize = Math.max(Math.min(2 * k, 2 * oldSize), 1);
        sketch.combinedBuffer_ = Arrays.copyOf(baseBuffer, newSize);
    }
}

