/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.Family;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.PreambleUtil;

final class ItemsByteArrayImpl {
    private ItemsByteArrayImpl() {
    }

    static <T> byte[] toByteArray(ItemsSketch<T> sketch, boolean ordered, ArrayOfItemsSerDe<T> serDe) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | 8;
        if (empty) {
            byte[] outByteArr = new byte[8];
            WritableMemory memOut = WritableMemory.wrap(outByteArr);
            boolean preLongs = true;
            ItemsByteArrayImpl.insertPre0(memOut, 1, flags, sketch.getK());
            return outByteArr;
        }
        T[] dataArr = ItemsByteArrayImpl.combinedBufferToItemsArray(sketch, ordered);
        int preLongs = 2;
        byte[] itemsByteArr = serDe.serializeToByteArray(dataArr);
        int numOutBytes = 16 + itemsByteArr.length;
        byte[] outByteArr = new byte[numOutBytes];
        WritableMemory memOut = WritableMemory.wrap(outByteArr);
        ItemsByteArrayImpl.insertPre0(memOut, 2, flags, sketch.getK());
        PreambleUtil.insertN(memOut, sketch.getN());
        memOut.putByteArray(16L, itemsByteArr, 0, itemsByteArr.length);
        return outByteArr;
    }

    private static <T> T[] combinedBufferToItemsArray(ItemsSketch<T> sketch, boolean ordered) {
        long bitPattern;
        int extra = 2;
        int outArrCap = sketch.getRetainedItems();
        T minValue = sketch.getMinValue();
        Object[] outArr = (Object[])Array.newInstance(minValue.getClass(), outArrCap + 2);
        outArr[0] = minValue;
        outArr[1] = sketch.getMaxValue();
        int baseBufferCount = sketch.getBaseBufferCount();
        Object[] combinedBuffer = sketch.getCombinedBuffer();
        System.arraycopy(combinedBuffer, 0, outArr, 2, baseBufferCount);
        if (bitPattern > 0L) {
            int k = sketch.getK();
            int index = 2 + baseBufferCount;
            int level = 0;
            for (bitPattern = sketch.getBitPattern(); bitPattern != 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    System.arraycopy(combinedBuffer, (2 + level) * k, outArr, index, k);
                    index += k;
                }
                ++level;
            }
        }
        if (ordered) {
            Arrays.sort(outArr, 2, baseBufferCount + 2, sketch.getComparator());
        }
        return outArr;
    }

    private static void insertPre0(WritableMemory wmem, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(wmem, preLongs);
        PreambleUtil.insertSerVer(wmem, 3);
        PreambleUtil.insertFamilyID(wmem, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(wmem, flags);
        PreambleUtil.insertK(wmem, k);
    }
}

