/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantiles.Util;

final class HeapCompactDoublesSketch
extends CompactDoublesSketch {
    static final int MIN_HEAP_DOUBLES_SER_VER = 1;
    private double minValue_;
    private double maxValue_;
    private long n_;
    private int baseBufferCount_;
    private long bitPattern_;
    private double[] combinedBuffer_;

    private HeapCompactDoublesSketch(int k) {
        super(k);
    }

    static HeapCompactDoublesSketch createFromUpdateSketch(UpdateDoublesSketch sketch) {
        int k = sketch.getK();
        long n = sketch.getN();
        HeapCompactDoublesSketch hcds = new HeapCompactDoublesSketch(k);
        hcds.n_ = n;
        hcds.bitPattern_ = Util.computeBitPattern(k, n);
        assert (hcds.bitPattern_ == sketch.getBitPattern());
        hcds.minValue_ = sketch.getMinValue();
        hcds.maxValue_ = sketch.getMaxValue();
        hcds.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        assert (hcds.baseBufferCount_ == sketch.getBaseBufferCount());
        int retainedItems = Util.computeRetainedItems(k, n);
        double[] combinedBuffer = new double[retainedItems];
        DoublesSketchAccessor accessor = DoublesSketchAccessor.wrap(sketch);
        assert (hcds.baseBufferCount_ == accessor.numItems());
        System.arraycopy(accessor.getArray(0, hcds.baseBufferCount_), 0, combinedBuffer, 0, hcds.baseBufferCount_);
        Arrays.sort(combinedBuffer, 0, hcds.baseBufferCount_);
        int combinedBufferOffset = hcds.baseBufferCount_;
        int lvl = 0;
        for (long bitPattern = hcds.bitPattern_; bitPattern > 0L; bitPattern >>>= 1) {
            if ((bitPattern & 1L) > 0L) {
                accessor.setLevel(lvl);
                System.arraycopy(accessor.getArray(0, k), 0, combinedBuffer, combinedBufferOffset, k);
                combinedBufferOffset += k;
            }
            ++lvl;
        }
        hcds.combinedBuffer_ = combinedBuffer;
        return hcds;
    }

    static HeapCompactDoublesSketch heapifyInstance(Memory srcMem) {
        long memCapBytes = srcMem.getCapacity();
        if (memCapBytes < 8L) {
            throw new SketchesArgumentException("Source Memory too small: " + memCapBytes + " < 8");
        }
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        int k = PreambleUtil.extractK(srcMem);
        boolean empty = (flags & 4) > 0;
        long n = empty ? 0L : PreambleUtil.extractN(srcMem);
        DoublesUtil.checkDoublesSerVer(serVer, 1);
        Util.checkHeapFlags(flags);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer(flags, serVer, preLongs);
        Util.checkFamilyID(familyID);
        HeapCompactDoublesSketch hds = new HeapCompactDoublesSketch(k);
        if (empty) {
            hds.n_ = 0L;
            hds.combinedBuffer_ = null;
            hds.baseBufferCount_ = 0;
            hds.bitPattern_ = 0L;
            hds.minValue_ = Double.NaN;
            hds.maxValue_ = Double.NaN;
            return hds;
        }
        boolean srcIsCompact = serVer == 2 | (flags & 0xA) > 0;
        HeapUpdateDoublesSketch.checkHeapMemCapacity(k, n, srcIsCompact, serVer, memCapBytes);
        hds.n_ = n;
        hds.baseBufferCount_ = Util.computeBaseBufferItems(k, n);
        hds.bitPattern_ = Util.computeBitPattern(k, n);
        hds.minValue_ = srcMem.getDouble(16L);
        hds.maxValue_ = srcMem.getDouble(24L);
        int totItems = Util.computeRetainedItems(k, n);
        hds.srcMemoryToCombinedBuffer(srcMem, serVer, srcIsCompact, totItems);
        return hds;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public double getMinValue() {
        return this.minValue_;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue_;
    }

    private void srcMemoryToCombinedBuffer(Memory srcMem, int serVer, boolean srcIsCompact, int combBufCap) {
        int preLongs = 2;
        int extra = serVer == 1 ? 3 : 2;
        int preBytes = 2 + extra << 3;
        int k = this.getK();
        this.combinedBuffer_ = new double[combBufCap];
        if (srcIsCompact) {
            srcMem.getDoubleArray(preBytes, this.combinedBuffer_, 0, combBufCap);
            if (serVer == 2) {
                Arrays.sort(this.combinedBuffer_, 0, this.baseBufferCount_);
            }
        } else {
            srcMem.getDoubleArray(preBytes, this.combinedBuffer_, 0, this.baseBufferCount_);
            Arrays.sort(this.combinedBuffer_, 0, this.baseBufferCount_);
            int srcOffset = preBytes + (2 * k << 3);
            int dstOffset = this.baseBufferCount_;
            for (long bitPattern = this.bitPattern_; bitPattern != 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    srcMem.getDoubleArray(srcOffset, this.combinedBuffer_, dstOffset, k);
                    dstOffset += k;
                }
                srcOffset += k << 3;
            }
        }
    }

    @Override
    int getBaseBufferCount() {
        return this.baseBufferCount_;
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return this.combinedBuffer_.length;
    }

    @Override
    double[] getCombinedBuffer() {
        return this.combinedBuffer_;
    }

    @Override
    long getBitPattern() {
        return this.bitPattern_;
    }

    @Override
    WritableMemory getMemory() {
        return null;
    }
}

