/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesReadOnlyException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantiles.Util;

class DirectUpdateDoublesSketchR
extends UpdateDoublesSketch {
    static final int MIN_DIRECT_DOUBLES_SER_VER = 3;
    WritableMemory mem_;

    DirectUpdateDoublesSketchR(int k) {
        super(k);
    }

    static DirectUpdateDoublesSketchR wrapInstance(Memory srcMem) {
        long memCap = srcMem.getCapacity();
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        int k = PreambleUtil.extractK(srcMem);
        boolean empty = (flags & 4) > 0;
        long n = empty ? 0L : PreambleUtil.extractN(srcMem);
        DirectUpdateDoublesSketchR.checkPreLongs(preLongs);
        Util.checkFamilyID(familyID);
        DoublesUtil.checkDoublesSerVer(serVer, 3);
        DirectUpdateDoublesSketchR.checkDirectFlags(flags);
        Util.checkK(k);
        DirectUpdateDoublesSketchR.checkCompact(serVer, flags);
        DirectUpdateDoublesSketchR.checkDirectMemCapacity(k, n, memCap);
        DirectUpdateDoublesSketchR.checkEmptyAndN(empty, n);
        DirectUpdateDoublesSketchR dds = new DirectUpdateDoublesSketchR(k);
        dds.mem_ = (WritableMemory)srcMem;
        return dds;
    }

    @Override
    public double getMaxValue() {
        return this.isEmpty() ? Double.NaN : this.mem_.getDouble(24L);
    }

    @Override
    public double getMinValue() {
        return this.isEmpty() ? Double.NaN : this.mem_.getDouble(16L);
    }

    @Override
    public long getN() {
        return this.mem_.getCapacity() < 32L ? 0L : this.mem_.getLong(8L);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.mem_.isSameResource(that);
    }

    @Override
    public void reset() {
        throw new SketchesReadOnlyException("Call to reset() on read-only buffer");
    }

    @Override
    public void update(double dataItem) {
        throw new SketchesReadOnlyException("Call to update() on read-only buffer");
    }

    @Override
    int getBaseBufferCount() {
        return Util.computeBaseBufferItems(this.getK(), this.getN());
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return ((int)this.mem_.getCapacity() - 32) / 8;
    }

    @Override
    double[] getCombinedBuffer() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new double[k << 1];
        }
        long n = this.getN();
        int itemCap = Util.computeCombinedBufferItemCapacity(k, n);
        double[] combinedBuffer = new double[itemCap];
        this.mem_.getDoubleArray(32L, combinedBuffer, 0, itemCap);
        return combinedBuffer;
    }

    @Override
    long getBitPattern() {
        int k = this.getK();
        long n = this.getN();
        return Util.computeBitPattern(k, n);
    }

    @Override
    WritableMemory getMemory() {
        return this.mem_;
    }

    @Override
    void putMinValue(double minValue) {
        throw new SketchesReadOnlyException("Call to putMinValue() on read-only buffer");
    }

    @Override
    void putMaxValue(double maxValue) {
        throw new SketchesReadOnlyException("Call to putMaxValue() on read-only buffer");
    }

    @Override
    void putN(long n) {
        throw new SketchesReadOnlyException("Call to putN() on read-only buffer");
    }

    @Override
    void putCombinedBuffer(double[] combinedBuffer) {
        throw new SketchesReadOnlyException("Call to putCombinedBuffer() on read-only buffer");
    }

    @Override
    void putBaseBufferCount(int baseBufferCount) {
        throw new SketchesReadOnlyException("Call to putBaseBufferCount() on read-only buffer");
    }

    @Override
    void putBitPattern(long bitPattern) {
        throw new SketchesReadOnlyException("Call to putBaseBufferCount() on read-only buffer");
    }

    @Override
    double[] growCombinedBuffer(int curCombBufItemCap, int itemSpaceNeeded) {
        throw new SketchesReadOnlyException("Call to growCombinedBuffer() on read-only buffer");
    }

    static void checkDirectMemCapacity(int k, long n, long memCapBytes) {
        int reqBufBytes = DirectUpdateDoublesSketchR.getUpdatableStorageBytes(k, n);
        if (memCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: Memory capacity too small: " + memCapBytes + " < " + reqBufBytes);
        }
    }

    static void checkCompact(int serVer, int flags) {
        boolean compact = serVer == 2 | (flags & 8) > 0;
        if (compact) {
            throw new SketchesArgumentException("Compact Memory is not supported for Wrap Instance.");
        }
    }

    static void checkPreLongs(int preLongs) {
        if (preLongs < 1 || preLongs > 2) {
            throw new SketchesArgumentException("Possible corruption: PreLongs must be 1 or 2: " + preLongs);
        }
    }

    static void checkDirectFlags(int flags) {
        int allowedFlags = 22;
        int flagsMask = -23;
        if ((flags & 0xFFFFFFE9) > 0) {
            throw new SketchesArgumentException("Possible corruption: Invalid flags field: Cannot be compact! " + Integer.toBinaryString(flags));
        }
    }

    static void checkEmptyAndN(boolean empty, long n) {
        if (empty && n > 0L) {
            throw new SketchesArgumentException("Possible corruption: Empty Flag = true and N > 0: " + n);
        }
    }
}

