/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.Family;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketchR;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUpdateImpl;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.Util;

final class DirectUpdateDoublesSketch
extends DirectUpdateDoublesSketchR {
    MemoryRequestServer memReqSvr = null;

    private DirectUpdateDoublesSketch(int k) {
        super(k);
    }

    static DirectUpdateDoublesSketch newInstance(int k, WritableMemory dstMem) {
        long memCap = dstMem.getCapacity();
        DirectUpdateDoublesSketch.checkDirectMemCapacity(k, 0L, memCap);
        dstMem.putLong(0L, 0L);
        PreambleUtil.insertPreLongs(dstMem, 2);
        PreambleUtil.insertSerVer(dstMem, 3);
        PreambleUtil.insertFamilyID(dstMem, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(dstMem, 4);
        PreambleUtil.insertK(dstMem, k);
        if (memCap >= 32L) {
            PreambleUtil.insertN(dstMem, 0L);
            PreambleUtil.insertMinDouble(dstMem, Double.NaN);
            PreambleUtil.insertMaxDouble(dstMem, Double.NaN);
        }
        DirectUpdateDoublesSketch dds = new DirectUpdateDoublesSketch(k);
        dds.mem_ = dstMem;
        return dds;
    }

    static DirectUpdateDoublesSketch wrapInstance(WritableMemory srcMem) {
        long memCap = srcMem.getCapacity();
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        int k = PreambleUtil.extractK(srcMem);
        boolean empty = (flags & 4) > 0;
        long n = empty ? 0L : PreambleUtil.extractN(srcMem);
        DirectUpdateDoublesSketch.checkPreLongs(preLongs);
        Util.checkFamilyID(familyID);
        DoublesUtil.checkDoublesSerVer(serVer, 3);
        DirectUpdateDoublesSketch.checkDirectFlags(flags);
        Util.checkK(k);
        DirectUpdateDoublesSketch.checkCompact(serVer, flags);
        DirectUpdateDoublesSketch.checkDirectMemCapacity(k, n, memCap);
        DirectUpdateDoublesSketch.checkEmptyAndN(empty, n);
        DirectUpdateDoublesSketch dds = new DirectUpdateDoublesSketch(k);
        dds.mem_ = srcMem;
        return dds;
    }

    @Override
    public void update(double dataItem) {
        int combBufItemCap;
        if (Double.isNaN(dataItem)) {
            return;
        }
        int curBBCount = this.getBaseBufferCount();
        int newBBCount = curBBCount + 1;
        if (newBBCount > (combBufItemCap = this.getCombinedBufferItemCapacity())) {
            this.mem_ = this.growCombinedMemBuffer(2 * this.getK());
        }
        long curN = this.getN();
        long newN = curN + 1L;
        if (curN == 0L) {
            this.putMaxValue(dataItem);
            this.putMinValue(dataItem);
        } else {
            if (dataItem > this.getMaxValue()) {
                this.putMaxValue(dataItem);
            }
            if (dataItem < this.getMinValue()) {
                this.putMinValue(dataItem);
            }
        }
        this.mem_.putDouble(32L + (long)curBBCount * 8L, dataItem);
        this.mem_.putByte(3L, (byte)0);
        if (newBBCount == 2 * this.k_) {
            int curMemItemCap = this.getCombinedBufferItemCapacity();
            int itemSpaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(this.k_, newN);
            if (itemSpaceNeeded > curMemItemCap) {
                this.mem_ = this.growCombinedMemBuffer(itemSpaceNeeded);
            }
            DoublesSketchAccessor bbAccessor = DoublesSketchAccessor.wrap(this, true);
            bbAccessor.sort();
            long newBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(0, null, bbAccessor, true, this.k_, DoublesSketchAccessor.wrap(this, true), this.getBitPattern());
            assert (newBitPattern == Util.computeBitPattern(this.k_, newN));
        }
        this.putN(newN);
    }

    @Override
    public void reset() {
        if (this.mem_.getCapacity() >= 32L) {
            this.mem_.putByte(3L, (byte)4);
            this.mem_.putLong(8L, 0L);
            this.mem_.putDouble(16L, Double.NaN);
            this.mem_.putDouble(24L, Double.NaN);
        }
    }

    @Override
    void putMinValue(double minValue) {
        assert (this.mem_.getCapacity() >= 32L);
        this.mem_.putDouble(16L, minValue);
    }

    @Override
    void putMaxValue(double maxValue) {
        assert (this.mem_.getCapacity() >= 32L);
        this.mem_.putDouble(24L, maxValue);
    }

    @Override
    void putN(long n) {
        assert (this.mem_.getCapacity() >= 32L);
        this.mem_.putLong(8L, n);
    }

    @Override
    void putCombinedBuffer(double[] combinedBuffer) {
        this.mem_.putDoubleArray(32L, combinedBuffer, 0, combinedBuffer.length);
    }

    @Override
    void putBaseBufferCount(int baseBufferCount) {
    }

    @Override
    void putBitPattern(long bitPattern) {
    }

    @Override
    double[] growCombinedBuffer(int curCombBufItemCap, int itemSpaceNeeded) {
        this.mem_ = this.growCombinedMemBuffer(itemSpaceNeeded);
        double[] newCombBuf = new double[itemSpaceNeeded];
        this.mem_.getDoubleArray(32L, newCombBuf, 0, curCombBufItemCap);
        return newCombBuf;
    }

    private WritableMemory growCombinedMemBuffer(int itemSpaceNeeded) {
        long memBytes = this.mem_.getCapacity();
        int needBytes = (itemSpaceNeeded << 3) + 32;
        assert ((long)needBytes > memBytes);
        this.memReqSvr = this.memReqSvr == null ? this.mem_.getMemoryRequestServer() : this.memReqSvr;
        WritableMemory newMem = this.memReqSvr.request(needBytes);
        this.mem_.copyTo(0L, newMem, 0L, memBytes);
        this.memReqSvr.requestClose(this.mem_, newMem);
        return newMem;
    }
}

