/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.BaseHllSketch;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public class Union
extends BaseHllSketch {
    final int lgMaxK;
    private final HllSketch gadget;

    public Union() {
        this.lgMaxK = 12;
        this.gadget = new HllSketch(this.lgMaxK, TgtHllType.HLL_8);
    }

    public Union(int lgMaxK) {
        this.lgMaxK = HllUtil.checkLgK(lgMaxK);
        this.gadget = new HllSketch(lgMaxK, TgtHllType.HLL_8);
    }

    public Union(int lgMaxK, WritableMemory dstMem) {
        this.lgMaxK = HllUtil.checkLgK(lgMaxK);
        this.gadget = new HllSketch(lgMaxK, TgtHllType.HLL_8, dstMem);
    }

    Union(HllSketch sketch) {
        this.lgMaxK = sketch.getLgConfigK();
        TgtHllType tgtHllType = sketch.getTgtHllType();
        if (tgtHllType != TgtHllType.HLL_8) {
            throw new SketchesArgumentException("Union can only wrap HLL_8 sketches.");
        }
        this.gadget = sketch;
    }

    public static final Union heapify(byte[] byteArray) {
        return Union.heapify(Memory.wrap(byteArray));
    }

    public static final Union heapify(Memory mem) {
        int lgK = HllUtil.checkLgK(mem.getByte(PreambleUtil.LG_K_BYTE));
        HllSketch sk = HllSketch.heapify(mem);
        Union union = new Union(lgK);
        union.update(sk);
        return union;
    }

    public static final Union writableWrap(WritableMemory wmem) {
        return new Union(HllSketch.writableWrap(wmem));
    }

    @Override
    public double getCompositeEstimate() {
        return this.gadget.hllSketchImpl.getCompositeEstimate();
    }

    @Override
    CurMode getCurMode() {
        return this.gadget.getCurMode();
    }

    @Override
    public int getCompactSerializationBytes() {
        return this.gadget.getCompactSerializationBytes();
    }

    @Override
    public double getEstimate() {
        return this.gadget.getEstimate();
    }

    @Override
    public int getLgConfigK() {
        return this.gadget.getLgConfigK();
    }

    public static int getMaxSerializationBytes(int lgK) {
        return HllSketch.getMaxUpdatableSerializationBytes(lgK, TgtHllType.HLL_8);
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return this.gadget.getLowerBound(numStdDev);
    }

    public HllSketch getResult() {
        return this.gadget.copyAs(HllSketch.DEFAULT_HLL_TYPE);
    }

    public HllSketch getResult(TgtHllType tgtHllType) {
        return this.gadget.copyAs(tgtHllType);
    }

    @Override
    public TgtHllType getTgtHllType() {
        return TgtHllType.HLL_8;
    }

    @Override
    public int getUpdatableSerializationBytes() {
        return this.gadget.getUpdatableSerializationBytes();
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return this.gadget.getUpperBound(numStdDev);
    }

    @Override
    public boolean isCompact() {
        return this.gadget.isCompact();
    }

    @Override
    public boolean isEmpty() {
        return this.gadget.isEmpty();
    }

    @Override
    public boolean isMemory() {
        return this.gadget.isMemory();
    }

    @Override
    public boolean isOffHeap() {
        return this.gadget.isOffHeap();
    }

    @Override
    boolean isOutOfOrderFlag() {
        return this.gadget.isOutOfOrderFlag();
    }

    @Override
    public boolean isSameResource(Memory mem) {
        return this.gadget.isSameResource(mem);
    }

    @Override
    public void reset() {
        this.gadget.reset();
    }

    @Override
    public byte[] toCompactByteArray() {
        return this.gadget.toCompactByteArray();
    }

    @Override
    public byte[] toUpdatableByteArray() {
        return this.gadget.toUpdatableByteArray();
    }

    @Override
    public String toString(boolean summary, boolean hllDetail, boolean auxDetail, boolean all) {
        return this.gadget.toString(summary, hllDetail, auxDetail, all);
    }

    public void update(HllSketch sketch) {
        this.gadget.hllSketchImpl = Union.unionImpl(sketch.hllSketchImpl, this.gadget.hllSketchImpl, this.lgMaxK);
    }

    @Override
    void couponUpdate(int coupon) {
        if (coupon == 0) {
            return;
        }
        this.gadget.hllSketchImpl = this.gadget.hllSketchImpl.couponUpdate(coupon);
    }

    private static final HllSketchImpl unionImpl(HllSketchImpl incomingImpl, HllSketchImpl gadgetImpl, int lgMaxK) {
        assert (gadgetImpl.getTgtHllType() == TgtHllType.HLL_8);
        HllSketchImpl srcImpl = incomingImpl;
        HllSketchImpl dstImpl = gadgetImpl;
        if (incomingImpl == null || incomingImpl.isEmpty()) {
            return gadgetImpl;
        }
        int hi2bits = gadgetImpl.isEmpty() ? 3 : gadgetImpl.getCurMode().ordinal();
        int lo2bits = incomingImpl.getCurMode().ordinal();
        int sw = hi2bits << 2 | lo2bits;
        switch (sw) {
            case 0: {
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(dstImpl.isOutOfOrderFlag() | srcImpl.isOutOfOrderFlag());
                break;
            }
            case 1: {
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(true);
                break;
            }
            case 2: {
                srcImpl = gadgetImpl;
                dstImpl = Union.copyOrDownsampleHll(incomingImpl, lgMaxK);
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(srcImpl.isOutOfOrderFlag() | dstImpl.isOutOfOrderFlag());
                break;
            }
            case 4: {
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(true);
                break;
            }
            case 5: {
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(true);
                break;
            }
            case 6: {
                srcImpl = gadgetImpl;
                dstImpl = Union.copyOrDownsampleHll(incomingImpl, lgMaxK);
                PairIterator srcItr = srcImpl.iterator();
                assert (dstImpl.getCurMode() == CurMode.HLL);
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(true);
                break;
            }
            case 8: {
                assert (dstImpl.getCurMode() == CurMode.HLL);
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(dstImpl.isOutOfOrderFlag() | srcImpl.isOutOfOrderFlag());
                break;
            }
            case 9: {
                assert (dstImpl.getCurMode() == CurMode.HLL);
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(true);
                break;
            }
            case 10: {
                int srcLgK = srcImpl.getLgConfigK();
                int dstLgK = dstImpl.getLgConfigK();
                if (srcLgK < dstLgK || dstImpl.getTgtHllType() != TgtHllType.HLL_8) {
                    dstImpl = Union.copyOrDownsampleHll(dstImpl, Math.min(dstLgK, srcLgK));
                }
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(true);
                break;
            }
            case 12: {
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(srcImpl.isOutOfOrderFlag());
                break;
            }
            case 13: {
                PairIterator srcItr = srcImpl.iterator();
                while (srcItr.nextValid()) {
                    dstImpl = dstImpl.couponUpdate(srcItr.getPair());
                }
                dstImpl.putOutOfOrderFlag(true);
                break;
            }
            case 14: {
                dstImpl = Union.copyOrDownsampleHll(srcImpl, lgMaxK);
                dstImpl.putOutOfOrderFlag(srcImpl.isOutOfOrderFlag());
            }
        }
        if (gadgetImpl.isMemory() && !dstImpl.isMemory()) {
            WritableMemory gadgetWmem = gadgetImpl.getWritableMemory();
            assert (gadgetWmem != null);
            int bytes = HllSketch.getMaxUpdatableSerializationBytes(dstImpl.getLgConfigK(), TgtHllType.HLL_8);
            gadgetWmem.clear(0L, bytes);
            byte[] dstByteArr = dstImpl.toUpdatableByteArray();
            gadgetWmem.putByteArray(0L, dstByteArr, 0, dstByteArr.length);
            dstImpl = HllSketch.writableWrap((WritableMemory)gadgetWmem).hllSketchImpl;
        }
        return dstImpl;
    }

    private static final HllSketchImpl copyOrDownsampleHll(HllSketchImpl srcImpl, int tgtLgK) {
        assert (srcImpl.getCurMode() == CurMode.HLL);
        AbstractHllArray src = (AbstractHllArray)srcImpl;
        int srcLgK = src.getLgConfigK();
        if (srcLgK <= tgtLgK && src.getTgtHllType() == TgtHllType.HLL_8) {
            return src.copy();
        }
        int minLgK = Math.min(srcLgK, tgtLgK);
        HllArray tgtHllArr = HllArray.newHeapHll(minLgK, TgtHllType.HLL_8);
        PairIterator srcItr = src.iterator();
        while (srcItr.nextValid()) {
            tgtHllArr.couponUpdate(srcItr.getPair());
        }
        tgtHllArr.putHipAccum(src.getHipAccum());
        tgtHllArr.putOutOfOrderFlag(src.isOutOfOrderFlag());
        return tgtHllArr;
    }
}

