/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;

class IntArrayPairIterator
implements PairIterator {
    private final int[] array;
    private final int slotMask;
    private final int lengthPairs;
    private int index;
    private int pair;

    IntArrayPairIterator(int[] array, int lgConfigK) {
        this.array = array;
        this.slotMask = (1 << lgConfigK) - 1;
        this.lengthPairs = array.length;
        this.index = -1;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getKey() {
        return HllUtil.getLow26(this.pair);
    }

    @Override
    public int getPair() {
        return this.pair;
    }

    @Override
    public int getSlot() {
        return this.getKey() & this.slotMask;
    }

    @Override
    public int getValue() {
        return HllUtil.getValue(this.pair);
    }

    @Override
    public boolean nextAll() {
        if (++this.index < this.lengthPairs) {
            this.pair = this.array[this.index];
            return true;
        }
        return false;
    }

    @Override
    public boolean nextValid() {
        while (++this.index < this.lengthPairs) {
            int pair = this.array[this.index];
            if (pair == 0) continue;
            this.pair = pair;
            return true;
        }
        return false;
    }
}

