/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectAuxHashMap;
import org.apache.datasketches.hll.DirectCouponList;
import org.apache.datasketches.hll.HeapAuxHashMap;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

abstract class DirectHllArray
extends AbstractHllArray {
    WritableMemory wmem;
    Memory mem;
    Object memObj;
    long memAdd;
    final boolean compact;

    DirectHllArray(int lgConfigK, TgtHllType tgtHllType, WritableMemory wmem) {
        super(lgConfigK, tgtHllType, CurMode.HLL);
        this.wmem = wmem;
        this.mem = wmem;
        this.memObj = wmem.getArray();
        this.memAdd = wmem.getCumulativeOffset(0L);
        this.compact = PreambleUtil.extractCompactFlag(this.mem);
        assert (!this.compact);
    }

    DirectHllArray(int lgConfigK, TgtHllType tgtHllType, Memory mem) {
        super(lgConfigK, tgtHllType, CurMode.HLL);
        this.wmem = null;
        this.mem = mem;
        this.memObj = ((WritableMemory)mem).getArray();
        this.memAdd = mem.getCumulativeOffset(0L);
        this.compact = PreambleUtil.extractCompactFlag(mem);
    }

    final void updateMemory(WritableMemory newWmem) {
        this.wmem = newWmem;
        this.mem = newWmem;
        this.memObj = this.wmem.getArray();
        this.memAdd = this.wmem.getCumulativeOffset(0L);
    }

    @Override
    void addToHipAccum(double delta) {
        double hipAccum = this.mem.getDouble(PreambleUtil.HIP_ACCUM_DOUBLE);
        this.wmem.putDouble(PreambleUtil.HIP_ACCUM_DOUBLE, hipAccum + delta);
    }

    @Override
    void decNumAtCurMin() {
        int numAtCurMin = this.mem.getInt(PreambleUtil.CUR_MIN_COUNT_INT);
        this.wmem.putInt(PreambleUtil.CUR_MIN_COUNT_INT, --numAtCurMin);
    }

    @Override
    int getCurMin() {
        return PreambleUtil.extractCurMin(this.mem);
    }

    @Override
    CurMode getCurMode() {
        return PreambleUtil.extractCurMode(this.mem);
    }

    @Override
    double getHipAccum() {
        return PreambleUtil.extractHipAccum(this.mem);
    }

    @Override
    double getKxQ0() {
        return PreambleUtil.extractKxQ0(this.mem);
    }

    @Override
    double getKxQ1() {
        return PreambleUtil.extractKxQ1(this.mem);
    }

    @Override
    int getLgConfigK() {
        return PreambleUtil.extractLgK(this.mem);
    }

    @Override
    AuxHashMap getNewAuxHashMap() {
        return new DirectAuxHashMap(this, true);
    }

    @Override
    int getNumAtCurMin() {
        return PreambleUtil.extractNumAtCurMin(this.mem);
    }

    @Override
    TgtHllType getTgtHllType() {
        return PreambleUtil.extractTgtHllType(this.mem);
    }

    @Override
    WritableMemory getWritableMemory() {
        return this.wmem;
    }

    @Override
    boolean isCompact() {
        return this.compact;
    }

    @Override
    boolean isEmpty() {
        return PreambleUtil.extractEmptyFlag(this.mem);
    }

    @Override
    boolean isMemory() {
        return true;
    }

    @Override
    boolean isOffHeap() {
        return this.mem.isDirect();
    }

    @Override
    boolean isOutOfOrderFlag() {
        return PreambleUtil.extractOooFlag(this.mem);
    }

    @Override
    boolean isSameResource(Memory mem) {
        return this.mem.isSameResource(mem);
    }

    @Override
    void putAuxHashMap(AuxHashMap auxHashMap, boolean compact) {
        if (auxHashMap instanceof HeapAuxHashMap) {
            if (compact) {
                this.auxHashMap = auxHashMap;
            } else {
                int[] auxArr = auxHashMap.getAuxIntArr();
                this.wmem.putIntArray(this.auxStart, auxArr, 0, auxArr.length);
                PreambleUtil.insertLgArr(this.wmem, auxHashMap.getLgAuxArrInts());
                PreambleUtil.insertAuxCount(this.wmem, auxHashMap.getAuxCount());
                this.auxHashMap = new DirectAuxHashMap(this, false);
            }
        } else {
            assert (!compact);
            this.auxHashMap = auxHashMap;
        }
    }

    @Override
    void putCurMin(int curMin) {
        PreambleUtil.insertCurMin(this.wmem, curMin);
    }

    @Override
    void putHipAccum(double hipAccum) {
        PreambleUtil.insertHipAccum(this.wmem, hipAccum);
    }

    @Override
    void putKxQ0(double kxq0) {
        PreambleUtil.insertKxQ0(this.wmem, kxq0);
    }

    @Override
    void putKxQ1(double kxq1) {
        PreambleUtil.insertKxQ1(this.wmem, kxq1);
    }

    @Override
    void putNumAtCurMin(int numAtCurMin) {
        PreambleUtil.insertNumAtCurMin(this.wmem, numAtCurMin);
    }

    @Override
    void putOutOfOrderFlag(boolean oooFlag) {
        PreambleUtil.insertOooFlag(this.wmem, oooFlag);
    }

    @Override
    byte[] toCompactByteArray() {
        return this.toUpdatableByteArray();
    }

    @Override
    byte[] toUpdatableByteArray() {
        int totBytes = this.getCompactSerializationBytes();
        byte[] byteArr = new byte[totBytes];
        WritableMemory memOut = WritableMemory.wrap(byteArr);
        this.mem.copyTo(0L, memOut, 0L, totBytes);
        PreambleUtil.insertCompactFlag(memOut, false);
        return byteArr;
    }

    @Override
    HllSketchImpl reset() {
        if (this.wmem == null) {
            throw new SketchesArgumentException("Cannot reset a read-only sketch");
        }
        int bytes = HllSketch.getMaxUpdatableSerializationBytes(this.lgConfigK, this.tgtHllType);
        this.wmem.clear(0L, bytes);
        return DirectCouponList.newInstance(this.lgConfigK, this.tgtHllType, this.wmem);
    }
}

