/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;

public final class HashOperations {
    private static final int STRIDE_HASH_BITS = 7;
    private static final int EMPTY = 0;
    public static final int STRIDE_MASK = 127;

    private HashOperations() {
    }

    public static int countPart(long[] srcArr, int lgArrLongs, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = 1 << lgArrLongs;
        while (i-- > 0) {
            long hash = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int count(long[] srcArr, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = srcArr.length;
        while (i-- > 0) {
            long hash = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash)) continue;
            ++cnt;
        }
        return cnt;
    }

    private static int getStride(long hash, int lgArrLongs) {
        return 2 * (int)(hash >>> lgArrLongs & 0x7FL) + 1;
    }

    public static int hashSearch(long[] hashTable, int lgArrLongs, long hash) {
        int curProbe;
        if (hash == 0L) {
            throw new SketchesArgumentException("Given hash cannot be zero: " + hash);
        }
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int loopIndex = curProbe = (int)(hash & (long)arrayMask);
        do {
            long arrVal;
            if ((arrVal = hashTable[curProbe]) == 0L) {
                return -1;
            }
            if (arrVal != hash) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        return -1;
    }

    public static int hashInsertOnly(long[] hashTable, int lgArrLongs, long hash) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int curProbe = (int)(hash & (long)arrayMask);
        long loopIndex = curProbe;
        do {
            long arrVal;
            if ((arrVal = hashTable[curProbe]) != 0L) continue;
            hashTable[curProbe] = hash;
            return curProbe;
        } while ((long)(curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("No empty slot in table!");
    }

    public static int hashSearchOrInsert(long[] hashTable, int lgArrLongs, long hash) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int loopIndex = curProbe = (int)(hash & (long)arrayMask);
        do {
            long arrVal;
            if ((arrVal = hashTable[curProbe]) == 0L) {
                hashTable[curProbe] = hash;
                return ~curProbe;
            }
            if (arrVal != hash) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    public static int hashArrayInsert(long[] srcArr, long[] hashTable, int lgArrLongs, long thetaLong) {
        int count = 0;
        int arrLen = srcArr.length;
        HashOperations.checkThetaCorruption(thetaLong);
        for (int i = 0; i < arrLen; ++i) {
            long hash = srcArr[i];
            HashOperations.checkHashCorruption(hash);
            if (HashOperations.continueCondition(thetaLong, hash) || HashOperations.hashSearchOrInsert(hashTable, lgArrLongs, hash) >= 0) continue;
            ++count;
        }
        return count;
    }

    public static int hashSearch(Memory mem, int lgArrLongs, long hash, int memOffsetBytes) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int loopIndex = curProbe = (int)(hash & (long)arrayMask);
        do {
            int curProbeOffsetBytes;
            long curArrayHash;
            if ((curArrayHash = mem.getLong(curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes)) == 0L) {
                return -1;
            }
            if (curArrayHash != hash) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        return -1;
    }

    public static int fastHashInsertOnly(WritableMemory wmem, int lgArrLongs, long hash, int memOffsetBytes) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int loopIndex = curProbe = (int)(hash & (long)arrayMask);
        do {
            int curProbeOffsetBytes;
            long curArrayHash;
            if ((curArrayHash = wmem.getLong(curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes)) != 0L) continue;
            wmem.putLong(curProbeOffsetBytes, hash);
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("No empty slot in table!");
    }

    public static int fastHashSearchOrInsert(WritableMemory wmem, int lgArrLongs, long hash, int memOffsetBytes) {
        int curProbe;
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = HashOperations.getStride(hash, lgArrLongs);
        int loopIndex = curProbe = (int)(hash & (long)arrayMask);
        do {
            int curProbeOffsetBytes;
            long curArrayHash;
            if ((curArrayHash = wmem.getLong(curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes)) == 0L) {
                wmem.putLong(curProbeOffsetBytes, hash);
                return ~curProbe;
            }
            if (curArrayHash != hash) continue;
            return curProbe;
        } while ((curProbe = curProbe + stride & arrayMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slot in table!");
    }

    public static void checkThetaCorruption(long thetaLong) {
        if ((thetaLong | thetaLong - 1L) < 0L) {
            throw new SketchesStateException("Data Corruption: thetaLong was negative or zero: ThetaLong: " + thetaLong);
        }
    }

    public static void checkHashCorruption(long hash) {
        if (hash < 0L) {
            throw new SketchesArgumentException("Data Corruption: hash was negative: Hash: " + hash);
        }
    }

    public static boolean continueCondition(long thetaLong, long hash) {
        return (hash - 1L | thetaLong - hash - 1L) < 0L;
    }
}

