/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.zorder.serializer;

import com.aliyun.odps.zorder.BitsCalculator;
import com.aliyun.odps.zorder.serializer.TypedDictionary;
import java.util.Map;
import java.util.TreeMap;

class TypedDictionaryImpl<T>
implements TypedDictionary {
    private boolean isReady = false;
    private boolean hasNullValue = false;
    private Map<T, Long> dictionary = new TreeMap<T, Long>();

    TypedDictionaryImpl() {
    }

    @Override
    public void add(Object value) {
        if (this.isReady) {
            throw new RuntimeException("Cannot add new item!");
        }
        if (value != null) {
            this.dictionary.put(value, 0L);
        } else if (!this.hasNullValue) {
            this.hasNullValue = true;
        }
    }

    @Override
    public long get(Object value) {
        this.ensureSorted();
        if (value != null) {
            return this.dictionary.get(value);
        }
        if (this.hasNullValue) {
            return 0L;
        }
        throw new IllegalArgumentException("input key is null but no null value is in dictionary!");
    }

    @Override
    public int getMaxBits() {
        this.ensureSorted();
        int entryCount = this.dictionary.size() + (this.hasNullValue ? 1 : 0);
        return BitsCalculator.calculate(0, entryCount - 1);
    }

    @Override
    public boolean hasNull() {
        return this.hasNullValue;
    }

    private void ensureSorted() {
        if (!this.isReady) {
            long id = this.hasNullValue ? 1L : 0L;
            for (T key : this.dictionary.keySet()) {
                this.dictionary.replace(key, id++);
            }
            this.isReady = true;
        }
    }
}

