/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.zorder;

import com.aliyun.odps.zorder.serializer.TypedDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class ZSort {
    public static void zorder(String[] zCoType, int[] zColId, List<Object[]> buffer) {
        System.out.println("Entering z-order preparation.");
        int zOrderColCount = zCoType.length;
        ArrayList dictionaries = new ArrayList(zOrderColCount);
        Stream.of(zCoType).forEach(type -> dictionaries.add(TypedDictionary.createInstance(type)));
        buffer.stream().forEach(objects -> {
            for (int i = 0; i != zOrderColCount; ++i) {
                ((TypedDictionary)dictionaries.get(i)).add(objects[zColId[i]]);
            }
        });
        System.out.println("Compute z-values.");
        for (int i = 0; i != buffer.size(); ++i) {
            Object[] objects3 = buffer.get(i);
            long[] zOrderColValues = new long[zOrderColCount];
            for (int j = 0; j != zOrderColCount; ++j) {
                zOrderColValues[j] = ((TypedDictionary)dictionaries.get(j)).get(objects3[zColId[j]]);
            }
            long zValue = 0L;
            for (int j = zOrderColCount - 1; j >= 0; --j) {
                long zColValue = zOrderColValues[j];
                long shiftedValue = 0L;
                int maxBits = ((TypedDictionary)dictionaries.get(j)).getMaxBits();
                for (int k = 0; k < maxBits; ++k) {
                    shiftedValue >>>= zOrderColCount;
                    shiftedValue |= (zColValue >>> k & 1L) << 63;
                }
                zValue >>>= 1;
                zValue |= shiftedValue;
            }
            objects3[objects3.length - 1] = zValue;
        }
        System.out.println("Begin z-sorting.");
        buffer.sort((objects1, objects2) -> {
            Long zvalue1 = (Long)objects1[((Object[])objects1).length - 1];
            Long zvalue2 = (Long)objects2[((Object[])objects2).length - 1];
            return Long.compare(zvalue1 + Long.MIN_VALUE, zvalue2 + Long.MIN_VALUE);
        });
        System.out.println("End z-sorting.");
    }
}

