/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.zorder;

import com.aliyun.odps.zorder.BitsCalculator;

public class Statistics {
    Type type;
    boolean hasNull = false;
    Object min = null;
    Object max = null;

    public Statistics(String t) {
        switch (t) {
            case "string": {
                this.type = Type.STRING;
                return;
            }
            case "bigint": {
                this.type = Type.BIGINT;
                return;
            }
            case "int": {
                this.type = Type.INT;
                return;
            }
            case "double": {
                this.type = Type.DOUBLE;
                return;
            }
            case "float": {
                this.type = Type.FLOAT;
                return;
            }
        }
        throw new IllegalArgumentException("unknown type: " + t);
    }

    public void update(Object value) {
        if (value == null) {
            this.hasNull = true;
        } else if (this.type == Type.STRING) {
            this.updateString((String)value);
        } else if (this.type == Type.BIGINT) {
            this.updateLong((Long)value);
        } else if (this.type == Type.INT) {
            this.updateInt((Integer)value);
        } else if (this.type == Type.DOUBLE) {
            this.updateDouble((Double)value);
        } else if (this.type == Type.FLOAT) {
            this.updateFloat((Float)value);
        } else {
            throw new RuntimeException("Should never reach here!");
        }
    }

    private void updateString(String value) {
        if (this.min == null) {
            this.min = value;
            this.max = value;
        } else if (value.compareTo((String)this.min) < 0) {
            this.min = value;
        } else if (value.compareTo((String)this.max) > 0) {
            this.max = value;
        }
    }

    private void updateLong(Long value) {
        if (this.min == null) {
            this.min = value;
            this.max = value;
        } else if (value < (Long)this.min) {
            this.min = value;
        } else if (value > (Long)this.max) {
            this.max = value;
        }
    }

    private void updateInt(Integer value) {
        if (this.min == null) {
            this.min = value;
            this.max = value;
        } else if (value < (Integer)this.min) {
            this.min = value;
        } else if (value > (Integer)this.max) {
            this.max = value;
        }
    }

    private void updateDouble(Double value) {
        if (this.min == null) {
            this.min = value;
            this.max = value;
        } else if (value < (Double)this.min) {
            this.min = value;
        } else if (value > (Double)this.max) {
            this.max = value;
        }
    }

    private void updateFloat(Float value) {
        if (this.min == null) {
            this.min = value;
            this.max = value;
        } else if (value.floatValue() < ((Float)this.min).floatValue()) {
            this.min = value;
        } else if (value.floatValue() > ((Float)this.max).floatValue()) {
            this.max = value;
        }
    }

    public int calculateUsefulBits(int upperBound) {
        if (this.min == null) {
            return 1;
        }
        if (this.type == Type.BIGINT) {
            return BitsCalculator.calculate((Long)this.min, (Long)this.max);
        }
        if (this.type == Type.INT) {
            return BitsCalculator.calculate((Integer)this.min, (Integer)this.max);
        }
        if (this.type == Type.DOUBLE) {
            return BitsCalculator.calculate((Double)this.min, (Double)this.max);
        }
        if (this.type == Type.FLOAT) {
            return BitsCalculator.calculate(((Float)this.min).floatValue(), ((Float)this.max).floatValue());
        }
        return upperBound;
    }

    public static enum Type {
        STRING,
        BIGINT,
        INT,
        DOUBLE,
        FLOAT;

    }
}

